/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.robocode.core.Container;
import net.sf.robocode.ui.IRobotDialogManager;
import net.sf.robocode.ui.dialog.BattleButton;
import net.sf.robocode.ui.dialog.BattleDialog;
import net.sf.robocode.ui.dialog.RobotButton;
import net.sf.robocode.ui.dialog.RobotDialog;
import net.sf.robocode.ui.dialog.WindowUtil;
import robocode.control.snapshot.IRobotSnapshot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RobotDialogManager
implements IRobotDialogManager {
    public static final int MAX_PRE_ATTACHED = 25;
    private final Map<String, RobotDialog> robotDialogMap = new ConcurrentHashMap<String, RobotDialog>();
    private BattleDialog battleDialog = null;

    @Override
    public void trim(List<IRobotSnapshot> robots) {
        for (String name : new ArrayList<String>(this.robotDialogMap.keySet())) {
            boolean found = false;
            for (IRobotSnapshot robot : robots) {
                if (!robot.getName().equals(name)) continue;
                found = true;
                break;
            }
            if (found) continue;
            RobotDialog dialog = this.robotDialogMap.get(name);
            this.robotDialogMap.remove(name);
            dialog.dispose();
            dialog.detach();
        }
    }

    @Override
    public void reset() {
        for (String name : this.robotDialogMap.keySet()) {
            RobotDialog dialog = this.robotDialogMap.get(name);
            if (dialog.isVisible()) continue;
            this.robotDialogMap.remove(name);
            dialog.detach();
            dialog.dispose();
        }
    }

    @Override
    public RobotDialog getRobotDialog(RobotButton robotButton, String name, boolean create) {
        RobotDialog robotDialog = this.robotDialogMap.get(name);
        if (create && robotDialog == null) {
            if (this.robotDialogMap.size() > 25) {
                this.reset();
            }
            robotDialog = (RobotDialog)Container.createComponent(RobotDialog.class);
            robotDialog.setup(robotButton);
            robotDialog.pack();
            WindowUtil.place(robotDialog);
            this.robotDialogMap.put(name, robotDialog);
        }
        return robotDialog;
    }

    @Override
    public BattleDialog getBattleDialog(BattleButton battleButton, boolean create) {
        if (create && this.battleDialog == null) {
            this.battleDialog = (BattleDialog)Container.getComponent(BattleDialog.class);
            this.battleDialog.pack();
            WindowUtil.place(this.battleDialog);
        }
        return this.battleDialog;
    }
}

