/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui;

import java.io.IOException;
import net.sf.robocode.io.FileUtil;

public class BrowserManager {
    private static final String browserCommand = System.getProperty("os.name").toLowerCase().startsWith("windows") ? "rundll32 url.dll, FileProtocolHandler" : "browser.sh";

    public static void openURL(String url) throws IOException {
        url = FileUtil.quoteFileName((String)url);
        String command = browserCommand + ' ' + url;
        ProcessBuilder pb = new ProcessBuilder(command.split(" "));
        pb.directory(FileUtil.getCwd());
        Process p = pb.start();
        try {
            p.waitFor();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (p.exitValue() < 0) {
            throw new IOException("Unable to launch " + browserCommand + ".  Please check it, or launch " + url + " in your browser.");
        }
    }
}

