/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.editor;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import net.sf.robocode.ui.editor.EditWindow;

public class WindowMenuItem
extends JCheckBoxMenuItem
implements ActionListener {
    public static final int WINDOW_MENU_MAX_SIZE = 9;
    public static final int PRECEDING_WINDOW_MENU_ITEMS = 3;
    public static final int SUBSEQUENT_WINDOW_MENU_ITEMS = 1;
    public static final int MAX_WINDOW_NAME_LENGTH = 30;
    public static final int REGULAR_WINDOW = 0;
    public static final int SPECIAL_MORE = 2;
    private EditWindow window;
    private JMenu parentMenu;
    private final int type;

    public WindowMenuItem(EditWindow window, JMenu parentMenu) {
        this.window = window;
        this.parentMenu = parentMenu;
        this.type = 0;
        parentMenu.add((Component)this, parentMenu.getMenuComponentCount() - 1);
        this.addActionListener(this);
    }

    public WindowMenuItem() {
        this.type = 2;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.window.isIcon()) {
            try {
                this.window.setIcon(false);
            }
            catch (Throwable ignored) {
                // empty catch block
            }
        }
        if (this.window.getDesktopPane() != null) {
            this.window.getDesktopPane().setSelectedFrame(this.window);
        }
        this.window.toFront();
        this.window.grabFocus();
        try {
            this.window.setSelected(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getText() {
        if (this.type == 2) {
            Container parent = this.getParent();
            if (parent == null) {
                return "";
            }
            int numWindows = parent.getComponentCount() - 3 - 1;
            if (numWindows <= 0) {
                return "No Windows Open";
            }
            return "More Windows...";
        }
        if (this.window == null || this.parentMenu == null) {
            return "";
        }
        String text = this.getIndex() + 1 + " " + this.getFileName();
        if (this.window.modified) {
            text = text + " *";
        }
        return text;
    }

    protected String getFileName() {
        boolean change;
        if (this.window.getFileName() == null) {
            return "Untitled " + (this.getPrecedingNewFiles() + 1);
        }
        String name = this.window.getFileName();
        if (name.length() < 30) {
            return name;
        }
        if (name.indexOf(File.separatorChar) < 0) {
            return name;
        }
        int startLength = name.indexOf(File.separatorChar, 1) + 1;
        int endLength = name.length() - name.lastIndexOf(File.separatorChar);
        if (endLength + startLength + 3 > name.length()) {
            return name;
        }
        do {
            change = false;
            int newEndLength = name.length() - name.lastIndexOf(File.separatorChar, name.length() - endLength - 1);
            if (newEndLength + startLength + 3 <= 30) {
                endLength = newEndLength;
                change = true;
            }
            int newStartLength = name.indexOf(File.separatorChar, startLength + 1) + 1;
            if (endLength + startLength + 3 > 30) continue;
            startLength = newStartLength;
            change = true;
        } while (change);
        return name.substring(0, startLength) + "..." + name.substring(name.length() - endLength);
    }

    protected int getPrecedingNewFiles() {
        int count = 0;
        for (int i = 0; i < 9 && i < this.parentMenu.getMenuComponentCount() - 3 - 1 && this.parentMenu.getMenuComponent(i + 3) != this; ++i) {
            if (!(this.parentMenu.getMenuComponent(i + 3) instanceof WindowMenuItem) || ((WindowMenuItem)this.parentMenu.getMenuComponent((int)(i + 3))).window.getFileName() != null) continue;
            ++count;
        }
        return count;
    }

    protected int getIndex() {
        for (int i = 0; i < 9 && i < this.parentMenu.getMenuComponentCount() - 3 - 1; ++i) {
            if (this != this.parentMenu.getMenuComponent(i + 3)) continue;
            return i;
        }
        return -1;
    }

    public int getDisplayedMnemonicIndex() {
        return this.type == 2 ? 11 : 0;
    }

    public int getMnemonic() {
        return this.type == 2 ? 83 : 49 + this.getIndex();
    }

    public boolean isVisible() {
        if (this.type == 2) {
            Container parent = this.getParent();
            if (parent == null) {
                return true;
            }
            int numWindows = parent.getComponentCount() - 3 - 1;
            this.updateSelection();
            return numWindows <= 0 || numWindows > 9;
        }
        this.updateSelection();
        return this.getIndex() >= 0;
    }

    public boolean isEnabled() {
        if (this.type == 2) {
            Container parent = this.getParent();
            if (parent == null) {
                return true;
            }
            int numWindows = parent.getComponentCount() - 3 - 1;
            return numWindows > 0;
        }
        return true;
    }

    public boolean isSelected() {
        return this.type != 2 && this.window != null && this.window.getDesktopPane() != null && this.window.getDesktopPane().getSelectedFrame() == this.window;
    }

    public void updateSelection() {
        this.setSelected(this.isSelected());
        this.setEnabled(this.isEnabled());
    }

    public EditWindow getEditWindow() {
        return this.window;
    }

    public String toString() {
        return this.type == 2 ? "" : this.getFileName();
    }
}

