/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import net.sf.robocode.io.FileUtil;
import net.sf.robocode.io.Logger;
import net.sf.robocode.ui.dialog.ConsoleDialog;
import net.sf.robocode.ui.dialog.WindowUtil;
import net.sf.robocode.ui.editor.CompilerProperties;
import net.sf.robocode.ui.editor.RobocodeCompiler;
import net.sf.robocode.ui.editor.RobocodeEditor;
import net.sf.robocode.version.IVersionManager;

public class RobocodeCompilerFactory {
    private static final String COMPILER_CLASSPATH = "-classpath " + RobocodeCompilerFactory.getJavaLib() + File.pathSeparator + "libs" + File.separator + "robocode.jar" + File.pathSeparator + FileUtil.quoteFileName((String)FileUtil.getRobotsDir().toString());
    private static CompilerProperties compilerProperties;
    private static boolean compilerInstalling;
    private static final char[] SPINNER;
    private final IVersionManager versionManager;

    public RobocodeCompilerFactory(IVersionManager versionManager) {
        this.versionManager = versionManager;
    }

    public RobocodeCompiler createCompiler(RobocodeEditor editor) {
        compilerProperties = null;
        if (this.getCompilerProperties().getCompilerBinary() == null || this.getCompilerProperties().getCompilerBinary().length() == 0) {
            if (this.installCompiler(editor)) {
                return new RobocodeCompiler(editor, this.getCompilerProperties().getCompilerBinary(), this.getCompilerProperties().getCompilerOptions(), this.getCompilerProperties().getCompilerClasspath());
            }
            Logger.logError((String)"Unable to create compiler.");
            return null;
        }
        return new RobocodeCompiler(editor, this.getCompilerProperties().getCompilerBinary(), this.getCompilerProperties().getCompilerOptions(), this.getCompilerProperties().getCompilerClasspath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean extract(File src, File dest) {
        boolean bl;
        JDialog statusDialog = new JDialog();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int height = 50;
        if (File.separatorChar == '/') {
            height = 100;
        }
        statusDialog.setTitle("Installing");
        statusDialog.setLocation((screenSize.width - 500) / 2, (screenSize.height - height) / 2);
        statusDialog.setSize(500, height);
        JLabel status = new JLabel();
        statusDialog.getContentPane().setLayout(new BorderLayout());
        statusDialog.getContentPane().add((Component)status, "Center");
        statusDialog.setVisible(true);
        FileInputStream fis = null;
        FileOutputStream fos = null;
        JarInputStream jarIS = null;
        byte[] buf = new byte[2048];
        try {
            fis = new FileInputStream(src);
            jarIS = new JarInputStream(fis);
            JarEntry entry = jarIS.getNextJarEntry();
            while (entry != null) {
                block13: {
                    String entryName;
                    int spin;
                    block12: {
                        spin = 0;
                        entryName = entry.getName();
                        if (!entry.isDirectory()) break block12;
                        File dir = new File(dest, entry.getName());
                        if (!dir.exists() && !dir.mkdirs()) {
                            Logger.logError((String)("Can't create " + dir));
                        }
                        break block13;
                    }
                    status.setText(entryName + " " + SPINNER[spin++]);
                    File out = new File(dest, entry.getName());
                    File parentDirectory = new File(out.getParent());
                    if (!parentDirectory.exists() && !parentDirectory.mkdirs()) {
                        Logger.logError((String)("Can't create " + parentDirectory));
                    }
                    int index = 0;
                    try {
                        int num;
                        fos = new FileOutputStream(out);
                        int count = 0;
                        while ((num = jarIS.read(buf, 0, 2048)) != -1) {
                            fos.write(buf, 0, num);
                            index += num;
                            if (++count <= 80) continue;
                            status.setText(entryName + " " + SPINNER[spin++] + " (" + index + " bytes)");
                            if (spin > 3) {
                                spin = 0;
                            }
                            count = 0;
                        }
                    }
                    catch (Throwable throwable) {
                        FileUtil.cleanupStream(fos);
                        throw throwable;
                    }
                    FileUtil.cleanupStream((Object)fos);
                    status.setText(entryName + " " + SPINNER[spin] + " (" + index + " bytes)");
                }
                entry = jarIS.getNextJarEntry();
            }
            statusDialog.dispose();
            bl = true;
        }
        catch (IOException e) {
            boolean bl2;
            try {
                statusDialog.dispose();
                WindowUtil.error(null, (String)e.toString());
                bl2 = false;
            }
            catch (Throwable throwable) {
                FileUtil.cleanupStream(fis);
                FileUtil.cleanupStream(jarIS);
                throw throwable;
            }
            FileUtil.cleanupStream((Object)fis);
            FileUtil.cleanupStream((Object)jarIS);
            return bl2;
        }
        FileUtil.cleanupStream((Object)fis);
        FileUtil.cleanupStream((Object)jarIS);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompilerProperties getCompilerProperties() {
        if (compilerProperties == null) {
            compilerProperties = new CompilerProperties();
            FileInputStream in = null;
            File file = null;
            try {
                file = FileUtil.getCompilerConfigFile();
                in = new FileInputStream(file);
                compilerProperties.load(in);
                if (compilerProperties.getRobocodeVersion() == null) {
                    Logger.logMessage((String)"Setting up new compiler");
                    compilerProperties.setCompilerBinary("");
                }
            }
            catch (FileNotFoundException e) {
                Logger.logMessage((String)"Compiler configuration file was not found. A new one will be created.");
            }
            catch (IOException e) {
                Logger.logError((String)("IO Exception reading " + file), (Throwable)e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ignored) {}
                }
            }
        }
        return compilerProperties;
    }

    private static String getJavaLib() {
        String javahome = System.getProperty("java.home");
        String javalib = System.getProperty("os.name").indexOf("Mac") == 0 ? new File(javahome).getParentFile().getPath() + "/Classes/classes.jar" : javahome + "/lib/rt.jar";
        return FileUtil.quoteFileName((String)javalib);
    }

    public boolean installCompiler(RobocodeEditor editor) {
        String compilerOptions;
        String compilerBinary;
        String jikesBinary;
        String jikesJar;
        if (compilerInstalling) {
            JOptionPane.showMessageDialog(editor, "Sorry, the compiler is still installing.\nPlease wait until it is complete.", "Error", 0);
            return false;
        }
        compilerInstalling = true;
        String osName = System.getProperty("os.name");
        ConsoleDialog console = new ConsoleDialog((Frame)editor, "Setting up compiler", false);
        console.setSize(500, 400);
        console.getOkButton().setEnabled(false);
        console.setText("Please wait while Robocode sets up a compiler for you...\n\n");
        WindowUtil.centerShow((Window)editor, (Window)console);
        console.append("Setting up compiler for " + osName + "\n");
        console.append("Java home is " + System.getProperty("java.home") + "\n\n");
        boolean javacOk = RobocodeCompilerFactory.testJavac(console);
        boolean jikesOk = false;
        boolean rv = true;
        boolean mustBuildJikes = false;
        boolean noExtract = false;
        compilerProperties.setRobocodeVersion(this.versionManager.getVersion());
        if (osName.indexOf("Windows") == 0) {
            jikesJar = "compilers/jikes-1.22.win.jar";
            jikesBinary = "./jikes-1.22/bin/jikes.exe";
            mustBuildJikes = false;
        } else if (osName.indexOf("Linux") == 0) {
            jikesJar = "compilers/jikes-1.22.src.jar";
            jikesBinary = "./jikes-1.22/bin/jikes";
            mustBuildJikes = true;
        } else if (osName.indexOf("Mac") == 0) {
            jikesJar = "compilers/jikes-1.22.src.jar";
            jikesBinary = "/usr/bin/jikes";
            jikesOk = RobocodeCompilerFactory.testJikes(console, jikesBinary + " -classpath " + RobocodeCompilerFactory.getJavaLib());
            if (!jikesOk) {
                mustBuildJikes = true;
                jikesBinary = "./jikes-1.22/bin/jikes";
            }
        } else {
            jikesJar = "compilers/jikes-1.22.src.jar";
            mustBuildJikes = true;
            jikesBinary = "./jikes-1.22/bin/jikes";
        }
        if (javacOk) {
            int rc;
            String noString = "(If you click No, Robocode will install and use Jikes)";
            if (jikesOk) {
                noString = "(If you click No, Robocode will use Jikes)";
            }
            if ((rc = JOptionPane.showConfirmDialog(editor, "Robocode has found a working javac on this system.\nWould you like to use it?\n" + noString, "Confirm javac", 0, 3)) == 1) {
                javacOk = false;
            }
        }
        if (javacOk) {
            compilerBinary = "javac";
            compilerOptions = "-deprecation -g";
            this.getCompilerProperties().setCompilerBinary(compilerBinary);
            this.getCompilerProperties().setCompilerOptions(compilerOptions);
            this.getCompilerProperties().setCompilerClasspath(COMPILER_CLASSPATH);
            RobocodeCompilerFactory.saveCompilerProperties();
            console.append("\nCongratulations!  Compiler set up successfully.\n");
            console.append("Click OK to continue.\n");
            console.scrollToBottom();
            rv = true;
        } else if (jikesOk) {
            compilerBinary = jikesBinary;
            compilerOptions = "-deprecation -g -Xstdout +T4";
            this.getCompilerProperties().setCompilerBinary(compilerBinary);
            this.getCompilerProperties().setCompilerOptions(compilerOptions);
            this.getCompilerProperties().setCompilerClasspath(COMPILER_CLASSPATH);
            RobocodeCompilerFactory.saveCompilerProperties();
            console.append("\nCongratulations!  Jikes set up successfully.\n");
            console.append("Click OK to continue.\n");
            console.scrollToBottom();
            rv = true;
        }
        if (!javacOk && !jikesOk) {
            String MESSAGE_BOX_HELP_TEXT = "\n\nPlease consult the console window for errors.\nFor help with this, please post to the discussion at:\nhttp://robocode.sourceforge.net/forum";
            console.append("\nExtracting Jikes...\n");
            if (noExtract || this.extract(new File(FileUtil.getCwd(), jikesJar), new File("."))) {
                if (!noExtract) {
                    console.append("Jikes extracted successfully.\n");
                }
                if (mustBuildJikes) {
                    if (JOptionPane.showConfirmDialog(editor, "Robocode is now going to build Jikes for you.\nThis will take a while...\n", "Java time", 2) == 0) {
                        if (RobocodeCompilerFactory.makeJikes(console, jikesBinary + " -classpath " + RobocodeCompilerFactory.getJavaLib())) {
                            compilerBinary = jikesBinary;
                            compilerOptions = "-deprecation -g -Xstdout +T4";
                            this.getCompilerProperties().setCompilerBinary(compilerBinary);
                            this.getCompilerProperties().setCompilerOptions(compilerOptions);
                            this.getCompilerProperties().setCompilerClasspath(COMPILER_CLASSPATH);
                            RobocodeCompilerFactory.saveCompilerProperties();
                            console.append("\nCongratulations!  Jikes is installed successfully.\n");
                            console.append("Click OK to continue.\n");
                            console.scrollToBottom();
                            rv = true;
                        } else {
                            JOptionPane.showMessageDialog(editor, "Robocode was unable to build and test Jikes.\n\nPlease consult the console window for errors.\nFor help with this, please post to the discussion at:\nhttp://robocode.sourceforge.net/forum", "Error", 0);
                            compilerOptions = "-deprecation -g";
                            this.getCompilerProperties().setCompilerOptions(compilerOptions);
                            this.getCompilerProperties().setCompilerClasspath(COMPILER_CLASSPATH);
                            RobocodeCompilerFactory.saveCompilerProperties();
                            rv = false;
                        }
                    }
                } else {
                    compilerBinary = jikesBinary;
                    compilerOptions = "-deprecation -g -Xstdout +T4";
                    this.getCompilerProperties().setCompilerBinary(compilerBinary);
                    this.getCompilerProperties().setCompilerOptions(compilerOptions);
                    this.getCompilerProperties().setCompilerClasspath(COMPILER_CLASSPATH);
                    if (RobocodeCompilerFactory.testJikes(console, jikesBinary + " -classpath " + RobocodeCompilerFactory.getJavaLib())) {
                        RobocodeCompilerFactory.saveCompilerProperties();
                        console.append("\nCongratulations! Jikes set up successfully.\n");
                        console.append("Click OK to continue.\n");
                        console.scrollToBottom();
                        rv = true;
                    } else {
                        JOptionPane.showMessageDialog(editor, "Robocode was unable to successfully compile with Jikes.\n\nPlease consult the console window for errors.\nFor help with this, please post to the discussion at:\nhttp://robocode.sourceforge.net/forum", "Error", 0);
                        RobocodeCompilerFactory.saveCompilerProperties();
                        rv = false;
                    }
                }
            } else {
                console.append("\nUnable to set up a compiler for Robocode.\n");
                console.append("javac could not be detected and Jikes could not be\n");
                console.append("extracted and set up as an alternative to javac.\n");
                console.scrollToBottom();
                JOptionPane.showMessageDialog(editor, "Robocode was unable set up a compiler for Robocode.\n\nPlease consult the console window for errors.\nFor help with this, please post to the discussion at:\nhttp://robocode.sourceforge.net/forum", "Error", 0);
                compilerOptions = "-deprecation -g";
                this.getCompilerProperties().setCompilerOptions(compilerOptions);
                this.getCompilerProperties().setCompilerClasspath(COMPILER_CLASSPATH);
                RobocodeCompilerFactory.saveCompilerProperties();
                rv = false;
            }
        }
        compilerInstalling = false;
        console.getOkButton().setEnabled(true);
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean makeJikes(ConsoleDialog console, String jikesBinary) {
        boolean result = false;
        console.append("\nRobocode building Jikes...\n");
        try {
            String command = "./compilers/buildJikes.sh";
            Logger.logMessage((String)command);
            ProcessBuilder pb = new ProcessBuilder(command);
            pb.directory(FileUtil.getCwd());
            pb.redirectErrorStream(true);
            Process p = pb.start();
            console.processStream(p.getInputStream());
            p.waitFor();
            if (p.exitValue() == 0) {
                console.append("Finished building Jikes\n");
                result = RobocodeCompilerFactory.testJikes(console, jikesBinary);
            } else {
                console.append("Jikes compile Failed (" + p.exitValue() + ")\n");
            }
        }
        catch (IOException e) {
            console.append("\n" + e.toString() + "\n");
            console.setTitle("Jikes compile failed.\n");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            console.append("\n" + e.toString() + "\n");
            console.setTitle("Jikes compile failed.\n");
        }
        finally {
            console.scrollToBottom();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveCompilerProperties() {
        if (compilerProperties == null) {
            Logger.logError((String)"Cannot save null compiler properties");
            return;
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(FileUtil.getCompilerConfigFile());
            compilerProperties.store(out, "Robocode Compiler Properties");
        }
        catch (IOException e) {
            Logger.logError((Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static boolean testJavac(ConsoleDialog console) {
        console.append("Testing compile with javac...\n");
        boolean javacOk = false;
        try {
            ProcessBuilder pb = new ProcessBuilder("javac", "compilers/CompilerTest.java");
            pb.directory(FileUtil.getCwd());
            pb.redirectErrorStream(true);
            Process p = pb.start();
            console.processStream(p.getInputStream());
            p.waitFor();
            javacOk = p.exitValue() == 0;
        }
        catch (IOException e) {
            Logger.logError((Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (javacOk) {
            console.append("javac ok.\n");
        } else {
            console.append("javac does not exist.\n");
        }
        return javacOk;
    }

    private static boolean testJikes(ConsoleDialog console, String jikesBinary) {
        console.append("\nTesting compile with Jikes...\n");
        boolean jikesOk = false;
        String command = jikesBinary + " compilers/CompilerTest.java";
        try {
            ProcessBuilder pb = new ProcessBuilder(command.split(" "));
            pb.directory(FileUtil.getCwd());
            pb.redirectErrorStream(true);
            Process p = pb.start();
            console.processStream(p.getInputStream());
            p.waitFor();
            jikesOk = p.exitValue() == 0;
        }
        catch (IOException e) {
            Logger.logError((Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (jikesOk) {
            console.append("Jikes ok.\n");
        } else {
            console.append("Unable to compile with Jikes!\n");
        }
        return jikesOk;
    }

    static {
        SPINNER = new char[]{'-', '\\', '|', '/'};
    }
}

