/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.editor;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.robocode.core.Container;
import net.sf.robocode.io.FileUtil;
import net.sf.robocode.io.Logger;
import net.sf.robocode.ui.editor.CompilerProperties;
import net.sf.robocode.ui.editor.RobocodeCompilerFactory;

public class CompilerPreferencesDialog
extends JDialog {
    private JButton cancelButton;
    private JTextField compilerBinaryField;
    private JTextField compilerClasspathField;
    private JTextField compilerOptionsField;
    private JPanel compilerPreferencesContentPane;
    private CompilerProperties compilerProperties;
    private JButton okButton;
    private final EventHandler eventHandler = new EventHandler();

    public CompilerPreferencesDialog(JFrame owner) {
        super((Frame)owner, true);
        this.compilerProperties = ((RobocodeCompilerFactory)Container.getComponent(RobocodeCompilerFactory.class)).getCompilerProperties();
        this.initialize();
    }

    private void initialize() {
        this.setTitle("Compiler Preferences");
        this.setContentPane(this.getCompilerPreferencesContentPane());
    }

    public JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.setMnemonic('C');
            this.cancelButton.addActionListener(this.eventHandler);
        }
        return this.cancelButton;
    }

    public JTextField getCompilerBinaryField() {
        if (this.compilerBinaryField == null) {
            this.compilerBinaryField = new JTextField(40);
            this.compilerBinaryField.setText(this.compilerProperties.getCompilerBinary());
        }
        return this.compilerBinaryField;
    }

    public JTextField getCompilerClasspathField() {
        if (this.compilerClasspathField == null) {
            this.compilerClasspathField = new JTextField(40);
            this.compilerClasspathField.setText(this.compilerProperties.getCompilerClasspath());
        }
        return this.compilerClasspathField;
    }

    public JTextField getCompilerOptionsField() {
        if (this.compilerOptionsField == null) {
            this.compilerOptionsField = new JTextField(40);
            this.compilerOptionsField.setText(this.compilerProperties.getCompilerOptions());
        }
        return this.compilerOptionsField;
    }

    private JPanel getCompilerPreferencesContentPane() {
        if (this.compilerPreferencesContentPane == null) {
            this.compilerPreferencesContentPane = new JPanel();
            this.compilerPreferencesContentPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.compilerPreferencesContentPane.setLayout(new BoxLayout(this.compilerPreferencesContentPane, 1));
            JLabel label = new JLabel("Compiler Binary:");
            label.setAlignmentX(0.0f);
            this.compilerPreferencesContentPane.add(label);
            this.getCompilerBinaryField().setAlignmentX(0.0f);
            this.compilerPreferencesContentPane.add(this.getCompilerBinaryField());
            label = new JLabel(" ");
            label.setAlignmentX(0.0f);
            this.compilerPreferencesContentPane.add(label);
            label = new JLabel("Compiler Options:");
            label.setAlignmentX(0.0f);
            this.compilerPreferencesContentPane.add(label);
            this.getCompilerOptionsField().setAlignmentX(0.0f);
            this.compilerPreferencesContentPane.add(this.getCompilerOptionsField());
            label = new JLabel(" ");
            label.setAlignmentX(0.0f);
            this.compilerPreferencesContentPane.add(label);
            label = new JLabel("Compiler Classpath:");
            label.setAlignmentX(0.0f);
            this.compilerPreferencesContentPane.add(label);
            this.getCompilerClasspathField().setAlignmentX(0.0f);
            this.compilerPreferencesContentPane.add(this.getCompilerClasspathField());
            JPanel panel = new JPanel();
            panel.setAlignmentX(0.0f);
            panel.add(this.getOkButton());
            panel.add(this.getCancelButton());
            this.compilerPreferencesContentPane.add(panel);
        }
        return this.compilerPreferencesContentPane;
    }

    public JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton("OK");
            this.okButton.setMnemonic('O');
            this.okButton.addActionListener(this.eventHandler);
        }
        return this.okButton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCompilerProperties() {
        if (this.compilerProperties == null) {
            Logger.logError((String)"Cannot save null compiler properties");
            return;
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(FileUtil.getCompilerConfigFile());
            this.compilerProperties.store(out, "Robocode Compiler Properties");
        }
        catch (IOException e) {
            Logger.logError((Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private class EventHandler
    implements ActionListener {
        private EventHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource().equals(CompilerPreferencesDialog.this.getOkButton())) {
                if (CompilerPreferencesDialog.this.compilerProperties == null) {
                    CompilerPreferencesDialog.this.compilerProperties = new CompilerProperties();
                }
                CompilerPreferencesDialog.this.compilerProperties.setCompilerBinary(CompilerPreferencesDialog.this.getCompilerBinaryField().getText());
                CompilerPreferencesDialog.this.compilerProperties.setCompilerOptions(CompilerPreferencesDialog.this.getCompilerOptionsField().getText());
                CompilerPreferencesDialog.this.compilerProperties.setCompilerClasspath(CompilerPreferencesDialog.this.getCompilerClasspathField().getText());
                CompilerPreferencesDialog.this.saveCompilerProperties();
                CompilerPreferencesDialog.this.dispose();
            }
            if (e.getSource().equals(CompilerPreferencesDialog.this.getCancelButton())) {
                CompilerPreferencesDialog.this.dispose();
            }
        }
    }
}

