/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.editor;

import java.awt.Frame;
import java.awt.Window;
import java.io.IOException;
import net.sf.robocode.io.FileUtil;
import net.sf.robocode.io.Logger;
import net.sf.robocode.ui.dialog.ConsoleDialog;
import net.sf.robocode.ui.dialog.WindowUtil;
import net.sf.robocode.ui.editor.RobocodeEditor;

public class RobocodeCompiler {
    private final String compilerBinary;
    private final RobocodeEditor editor;
    private final String compilerOptions;
    private final String compilerClassPath;

    protected RobocodeCompiler(RobocodeEditor editor, String binary, String options, String classPath) {
        this.compilerBinary = binary;
        this.compilerOptions = options;
        this.compilerClassPath = classPath;
        this.editor = editor;
    }

    public void compile(String fileName) {
        fileName = FileUtil.quoteFileName((String)fileName);
        ConsoleDialog console = this.editor != null ? new ConsoleDialog((Frame)this.editor, "Compiling", false) : new ConsoleDialog();
        console.setSize(500, 400);
        console.setText("Compiling...\n");
        WindowUtil.centerShow((Window)this.editor, (Window)console);
        try {
            StringBuffer command = new StringBuffer(this.compilerBinary).append(' ').append(this.compilerOptions).append(' ').append(this.compilerClassPath).append(' ').append(fileName);
            Logger.logMessage((String)("Compile command: " + command));
            ProcessBuilder pb = new ProcessBuilder(command.toString().split(" "));
            pb.redirectErrorStream(true);
            pb.directory(FileUtil.getCwd());
            Process p = pb.start();
            console.processStream(p.getInputStream());
            p.waitFor();
            if (p.exitValue() == 0) {
                console.append("Compiled successfully.\n");
                console.setTitle("Compiled successfully.");
            } else {
                console.append("Compile Failed (" + p.exitValue() + ")\n");
                console.setTitle("Compile failed.");
            }
        }
        catch (IOException e) {
            console.append("Unable to compile!\n");
            console.append("Exception was: " + e.toString() + "\n");
            console.append("Does " + this.compilerBinary + " exist?\n");
            console.setTitle("Exception while compiling");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            console.append("Compile interrupted.\n");
            console.setTitle("Compile interrupted.");
        }
    }
}

