/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.editor;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;

public class LineNumbers
extends JComponent
implements DocumentListener,
MouseListener,
MouseMotionListener,
CaretListener {
    private final JEditorPane editorPane;
    private int currentLines;
    private int lineWidth;
    private int anchor;
    private int lastIndex;
    private int offset;
    private int textWidth;

    public LineNumbers(JEditorPane editorPane) {
        this.editorPane = editorPane;
        editorPane.getDocument().addDocumentListener(this);
        this.setForeground(editorPane.getForeground());
        this.setBackground(editorPane.getBackground());
        this.currentLines = 1;
        this.lastIndex = -1;
        this.anchor = -1;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        editorPane.addMouseListener(this);
        this.setPreferredSize(new Dimension(24, 17));
        editorPane.addCaretListener(this);
    }

    public void changedUpdate(DocumentEvent e) {
        this.lastIndex = -1;
        this.anchor = -1;
        try {
            this.checkLines(e.getDocument().getText(0, e.getDocument().getLength()));
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.lastIndex = -1;
        this.anchor = -1;
        try {
            this.checkLines(e.getDocument().getText(0, e.getDocument().getLength()));
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
    }

    public void removeUpdate(DocumentEvent e) {
        this.lastIndex = -1;
        this.anchor = -1;
        try {
            this.checkLines(e.getDocument().getText(0, e.getDocument().getLength()));
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
    }

    protected void checkLines(String text) {
        int lines = 0;
        int index = -1;
        do {
            ++lines;
        } while ((index = text.indexOf(10, index + 1)) >= 0);
        if (lines != this.currentLines) {
            this.currentLines = lines;
            this.repaint();
        }
    }

    public void paint(Graphics g) {
        this.checkLines(this.editorPane.getText());
        g.setFont(this.editorPane.getFont());
        FontMetrics fm = g.getFontMetrics();
        if (this.lineWidth == 0) {
            this.lineWidth = fm.getHeight();
            this.offset = fm.getAscent() - this.lineWidth;
        }
        g.setFont(this.editorPane.getFont().deriveFont(1));
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(this.editorPane.getSelectionColor());
        int start = Math.max(1, Math.min(this.anchor, this.lastIndex));
        int end = Math.min(this.currentLines, Math.max(this.anchor, this.lastIndex));
        g.fillRect(0, (start - 1) * this.lineWidth - this.offset, this.textWidth, (end - start + 1) * this.lineWidth);
        int maxwidth = Math.max(this.textWidth, fm.stringWidth("000"));
        for (int i = 1; i <= this.currentLines; ++i) {
            String str = Integer.toString(i);
            maxwidth = Math.max(maxwidth, fm.stringWidth(str));
            if (i >= start && i <= end) {
                g.setColor(this.editorPane.getSelectedTextColor());
            } else {
                g.setColor(this.getForeground());
            }
            g.drawString(str, this.textWidth - fm.stringWidth(str), i * this.lineWidth + this.offset);
        }
        this.textWidth = maxwidth;
        g.setColor(this.getForeground());
        g.drawLine(maxwidth + 2, 0, maxwidth + 2, this.getHeight());
        g.drawLine(maxwidth + 1, 0, maxwidth + 1, this.getHeight());
        Dimension dim = this.getPreferredSize();
        if (dim.height != this.lineWidth * this.currentLines || dim.width != maxwidth + 8) {
            this.setPreferredSize(new Dimension(maxwidth + 8, this.lineWidth * this.currentLines));
            this.setMinimumSize(new Dimension(maxwidth + 8, this.lineWidth * this.currentLines));
            this.repaint();
        }
    }

    protected void doSelection() {
        int first = Math.min(this.anchor, this.lastIndex);
        int last = Math.max(this.anchor, this.lastIndex);
        try {
            int lines;
            String text = this.editorPane.getDocument().getText(0, this.editorPane.getDocument().getLength());
            int index = -1;
            for (lines = 1; lines < first; ++lines) {
                index = text.indexOf(10, index + 1);
            }
            int firstindex = index + 1;
            do {
                index = text.indexOf(10, index + 1);
            } while (++lines <= last && index > 0);
            int lastindex = index < 0 ? this.editorPane.getDocument().getLength() : index + 1;
            this.editorPane.setSelectionStart(firstindex);
            this.editorPane.setSelectionEnd(lastindex);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void mousePressed(MouseEvent e) {
        if (e.getSource() == this) {
            if (e.getX() < this.textWidth) {
                this.lastIndex = this.anchor = e.getY() / this.lineWidth + 1;
                this.doSelection();
                this.repaint();
                this.editorPane.requestFocus();
            }
        } else {
            this.lastIndex = -1;
            this.anchor = -1;
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getSource() == this) {
            if (e.getX() < this.textWidth) {
                if (this.lastIndex != e.getY() / this.lineWidth + 1) {
                    this.lastIndex = e.getY() / this.lineWidth + 1;
                    this.doSelection();
                    this.repaint();
                }
                this.editorPane.requestFocus();
            }
        } else {
            this.lastIndex = -1;
            this.anchor = -1;
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.lastIndex != e.getY() / this.lineWidth + 1 && e.getX() < this.textWidth) {
            this.lastIndex = e.getY() / this.lineWidth + 1;
            this.doSelection();
            this.repaint();
        }
        this.editorPane.requestFocus();
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void caretUpdate(CaretEvent e) {
        this.repaint();
    }
}

