/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.editor;

import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.PlainDocument;
import javax.swing.undo.UndoManager;
import net.sf.robocode.io.Logger;
import net.sf.robocode.ui.editor.EditWindow;

public class JavaDocument
extends PlainDocument {
    private UndoHandler undoHandler;
    private boolean needsRedraw;
    private EditWindow editWindow;
    private boolean editing;

    public JavaDocument() {
        this.init();
    }

    public EditWindow getEditWindow() {
        return this.editWindow;
    }

    private void init() {
        this.addUndoableEditListener(this.getUndoHandler());
    }

    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (!this.editing) {
            super.insertString(offs, str, a);
            return;
        }
        if (str.equals("}")) {
            if (this.getText(offs - 1, 1).equals("\t")) {
                super.remove(offs - 1, 1);
                super.insertString(offs - 1, str, a);
            } else {
                super.insertString(offs, str, a);
            }
        } else if (str.equals("\n")) {
            int elementIndex = this.getDefaultRootElement().getElementIndex(offs);
            Element element = this.getDefaultRootElement().getElement(elementIndex);
            int startOffset = element.getStartOffset();
            int endOffset = element.getEndOffset();
            String elementText = this.getText(startOffset, endOffset - startOffset);
            int tabCount = 0;
            while (elementText.charAt(tabCount) == '\t') {
                ++tabCount;
            }
            if (elementText.indexOf("{") >= 0) {
                ++tabCount;
            }
            if (elementText.indexOf("}") >= 0) {
                --tabCount;
            }
            String tabs = "";
            for (int i = 0; i < tabCount; ++i) {
                tabs = tabs + "\t";
            }
            super.insertString(offs, str + tabs, a);
        } else {
            super.insertString(offs, str, a);
        }
    }

    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent event, AttributeSet attributeSet) {
        if (this.editWindow != null) {
            this.editWindow.setModified(true);
        }
        int orgChangedIndex = this.getDefaultRootElement().getElementIndex(event.getOffset());
        super.insertUpdate(event, attributeSet);
        Element rootElement = this.getDefaultRootElement();
        DocumentEvent.ElementChange deltas = event.getChange(rootElement);
        if (deltas == null) {
            Element changedElement = this.getDefaultRootElement().getElement(orgChangedIndex);
            this.processMultilineComments(changedElement, false);
        } else {
            Element[] changedElements = deltas.getChildrenAdded();
            if (changedElements == null || changedElements.length == 0) {
                Logger.logError((String)"Unknown insert even, 0 children added.");
            } else {
                for (Element element : changedElements) {
                    this.processMultilineComments(element, true);
                }
            }
        }
    }

    public boolean isNeedsRedraw() {
        return this.needsRedraw;
    }

    protected void postRemoveUpdate(AbstractDocument.DefaultDocumentEvent event) {
        if (this.editWindow != null) {
            this.editWindow.setModified(true);
        }
        super.postRemoveUpdate(event);
        this.processMultilineComments(event);
    }

    public void processMultilineComments(AbstractDocument.DefaultDocumentEvent event) {
        Element rootElement = this.getDefaultRootElement();
        int changedIndex = this.getDefaultRootElement().getElementIndex(event.getOffset());
        Element changedElement = this.getDefaultRootElement().getElement(changedIndex);
        this.processMultilineComments(changedElement, event.getChange(rootElement) != null);
    }

    public void processMultilineComments(Element element, boolean isDeltas) {
        int sIndex;
        int eIndex;
        AbstractDocument.AbstractElement lastElement;
        int lastElementIndex;
        String elementText;
        int elementIndex = this.getDefaultRootElement().getElementIndex(element.getStartOffset());
        int startOffset = element.getStartOffset();
        int endOffset = element.getEndOffset();
        try {
            elementText = this.getText(startOffset, endOffset - startOffset);
        }
        catch (BadLocationException e) {
            Logger.logError((String)"Error processing updates: ", (Throwable)e);
            return;
        }
        boolean previousLineComment = false;
        boolean startsComment = false;
        boolean endsComment = false;
        MutableAttributeSet a = (MutableAttributeSet)element.getAttributes();
        if (a.isDefined("inComment")) {
            previousLineComment = true;
        } else if (isDeltas && (lastElementIndex = elementIndex - 1) >= 0 && (!(lastElement = (AbstractDocument.AbstractElement)this.getDefaultRootElement().getElement(lastElementIndex)).isDefined("endsComment") && lastElement.isDefined("inComment") || lastElement.isDefined("startsComment"))) {
            a.addAttribute("inComment", "inComment");
            previousLineComment = true;
        }
        boolean followingLineComment = previousLineComment;
        int cIndex = elementText.indexOf("//");
        if (cIndex >= 0) {
            eIndex = elementText.lastIndexOf("*/", cIndex);
            sIndex = elementText.lastIndexOf("/*", cIndex);
        } else {
            eIndex = elementText.lastIndexOf("*/");
            sIndex = elementText.lastIndexOf("/*");
        }
        if (eIndex > sIndex) {
            followingLineComment = false;
            endsComment = true;
            startsComment = false;
        } else if (sIndex > eIndex) {
            followingLineComment = true;
            startsComment = true;
            endsComment = false;
        }
        if (followingLineComment) {
            if (startsComment) {
                if (!a.isDefined("startsComment")) {
                    a.addAttribute("startsComment", "startsComment");
                    this.setFollowingLinesCommentFlag(startOffset, true);
                }
            } else if (a.isDefined("startsComment")) {
                a.removeAttribute("startsComment");
            }
            if (a.isDefined("endsComment")) {
                a.removeAttribute("endsComment");
                this.setFollowingLinesCommentFlag(startOffset, true);
            } else if (isDeltas) {
                this.setFollowingLinesCommentFlag(startOffset, true);
            }
        } else {
            if (endsComment) {
                if (!a.isDefined("endsComment")) {
                    a.addAttribute("endsComment", "endsComment");
                    this.setFollowingLinesCommentFlag(startOffset, false);
                }
            } else if (a.isDefined("endsComment")) {
                a.removeAttribute("endsComment");
            }
            if (a.isDefined("startsComment")) {
                a.removeAttribute("startsComment");
                this.setFollowingLinesCommentFlag(startOffset, false);
            } else if (isDeltas) {
                this.setFollowingLinesCommentFlag(startOffset, false);
            }
        }
    }

    public void setEditWindow(EditWindow newEditWindow) {
        this.editWindow = newEditWindow;
    }

    public void setFollowingLinesCommentFlag(int offset, boolean commentFlag) {
        int elementIndex = this.getDefaultRootElement().getElementIndex(offset);
        ++elementIndex;
        boolean done = false;
        while (!done) {
            Element e = this.getDefaultRootElement().getElement(elementIndex);
            if (e == null) {
                done = true;
                continue;
            }
            MutableAttributeSet a = (MutableAttributeSet)e.getAttributes();
            if (commentFlag) {
                if (a.isDefined("inComment")) {
                    done = true;
                } else {
                    a.addAttribute("inComment", "inComment");
                    this.needsRedraw = true;
                }
                if (a.isDefined("endsComment")) {
                    done = true;
                }
            } else {
                if (!a.isDefined("inComment")) {
                    done = true;
                } else {
                    a.removeAttribute("inComment");
                    this.needsRedraw = true;
                }
                if (a.isDefined("startsComment")) {
                    done = true;
                }
            }
            ++elementIndex;
        }
    }

    public void setNeedsRedraw(boolean newNeedsRedraw) {
        this.needsRedraw = newNeedsRedraw;
    }

    public boolean getEditing() {
        return this.editing;
    }

    public void setEditing(boolean editing) {
        this.editing = editing;
    }

    private UndoHandler getUndoHandler() {
        if (this.undoHandler == null) {
            this.undoHandler = new UndoHandler();
        }
        return this.undoHandler;
    }

    public void undo() {
        if (this.getUndoHandler().canUndo()) {
            this.writeLock();
            this.getUndoHandler().undo();
            this.writeUnlock();
            this.needsRedraw = true;
        }
    }

    public void redo() {
        if (this.getUndoHandler().canRedo()) {
            this.writeLock();
            this.getUndoHandler().redo();
            this.writeUnlock();
            this.needsRedraw = true;
        }
    }

    private class UndoHandler
    extends UndoManager {
        private UndoHandler() {
        }

        public synchronized void undo() {
            super.undo();
            JavaDocument.this.processMultilineComments((AbstractDocument.DefaultDocumentEvent)this.lastEdit());
        }

        public synchronized void redo() {
            super.redo();
            JavaDocument.this.processMultilineComments((AbstractDocument.DefaultDocumentEvent)this.lastEdit());
        }
    }
}

