/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.filechooser.FileFilter;
import net.sf.robocode.io.Logger;
import net.sf.robocode.repository.IRepositoryManager;
import net.sf.robocode.ui.editor.JavaDocument;
import net.sf.robocode.ui.editor.LineNumbers;
import net.sf.robocode.ui.editor.RobocodeCompiler;
import net.sf.robocode.ui.editor.RobocodeEditor;
import net.sf.robocode.ui.editor.RobocodeEditorKit;

public class EditWindow
extends JInternalFrame
implements CaretListener {
    private String fileName;
    private String robotName;
    public boolean modified;
    private final RobocodeEditor editor;
    private final IRepositoryManager repositoryManager;
    private JEditorPane editorPane;
    private JPanel editWindowContentPane;
    private final File robotsDirectory;
    private JScrollPane scrollPane;
    private LineNumbers lineNumbers;

    public EditWindow(IRepositoryManager repositoryManager, RobocodeEditor editor, File robotsDirectory) {
        this.editor = editor;
        this.robotsDirectory = robotsDirectory;
        this.repositoryManager = repositoryManager;
        this.initialize();
    }

    public JEditorPane getEditorPane() {
        if (this.editorPane == null) {
            this.editorPane = new JEditorPane();
            this.editorPane.setFont(new Font("monospaced", 0, 12));
            RobocodeEditorKit editorKit = new RobocodeEditorKit();
            this.editorPane.setEditorKitForContentType("text/java", editorKit);
            this.editorPane.setContentType("text/java");
            editorKit.setEditWindow(this);
            this.editorPane.addCaretListener(this);
            ((JavaDocument)this.editorPane.getDocument()).setEditWindow(this);
            InputMap im = this.editorPane.getInputMap();
            im.put(KeyStroke.getKeyStroke("ctrl H"), this.editor.getReplaceAction());
        }
        return this.editorPane;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getRobotName() {
        return this.robotName;
    }

    private void initialize() {
        try {
            this.addInternalFrameListener(new InternalFrameAdapter(){

                public void internalFrameClosing(InternalFrameEvent e) {
                    if (!EditWindow.this.modified || EditWindow.this.fileSave(true)) {
                        EditWindow.this.editor.setLineStatus(-1);
                        EditWindow.this.dispose();
                    }
                    EditWindow.this.editor.removeFromWindowMenu(EditWindow.this);
                }

                public void internalFrameDeactivated(InternalFrameEvent e) {
                    EditWindow.this.editor.setLineStatus(-1);
                }

                public void internalFrameIconified(InternalFrameEvent e) {
                    EditWindow.this.editor.setLineStatus(-1);
                }
            });
            this.setResizable(true);
            this.setDefaultCloseOperation(0);
            this.setIconifiable(true);
            this.setClosable(true);
            this.setMaximum(false);
            this.setFrameIcon(new ImageIcon(EditWindow.class.getResource("/net/sf/robocode/ui/icons/robocode-icon.png")));
            this.setSize(553, 441);
            this.setMaximizable(true);
            this.setTitle("Edit Window");
            this.setContentPane(this.getEditWindowContentPane());
            this.editor.addToWindowMenu(this);
        }
        catch (Throwable e) {
            Logger.logError((Throwable)e);
        }
    }

    public void setFileName(String newFileName) {
        this.fileName = newFileName;
    }

    public void setModified(boolean modified) {
        if (modified && !this.modified) {
            this.modified = true;
            if (this.fileName != null) {
                this.setTitle("Editing - " + this.fileName + " *");
            } else if (this.robotName != null) {
                this.setTitle("Editing - " + this.robotName + " *");
            } else {
                this.setTitle("Editing - *");
            }
        } else if (!modified) {
            this.modified = false;
            if (this.fileName != null) {
                this.setTitle("Editing - " + this.fileName);
            } else if (this.robotName != null) {
                this.setTitle("Editing - " + this.robotName);
            } else {
                this.setTitle("Editing");
            }
        }
        this.editor.setSaveFileMenuItemsEnabled(modified);
    }

    public void setRobotName(String newRobotName) {
        this.robotName = newRobotName;
    }

    public void caretUpdate(CaretEvent e) {
        int lineend = this.getEditorPane().getDocument().getDefaultRootElement().getElementIndex(e.getDot());
        this.editor.setLineStatus(lineend);
    }

    public void compile() {
        if (!this.fileSave(true, true)) {
            this.error("You must save before compiling.");
            return;
        }
        RobocodeCompiler compiler = this.editor.getCompiler();
        if (compiler != null) {
            compiler.compile(this.fileName);
            this.repositoryManager.reload(this.fileName);
        } else {
            JOptionPane.showMessageDialog(this.editor, "No compiler installed.", "Error", 0);
        }
    }

    private void error(String msg) {
        Object[] options = new Object[]{"OK"};
        JOptionPane.showOptionDialog(this, msg, "Error", -1, 0, null, options, options[0]);
    }

    public boolean fileSave(boolean confirm) {
        return this.fileSave(confirm, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fileSave(boolean confirm, boolean mustSave) {
        String fileName;
        if (confirm) {
            int ok;
            if (!this.modified) {
                return true;
            }
            String s = this.fileName;
            if (s == null) {
                s = this.robotName;
            }
            if (s == null) {
                s = "This file";
            }
            if ((ok = JOptionPane.showConfirmDialog(this, s + " has been modified.  Do you wish to save it?", "Modified file", 1)) == 1) {
                return !mustSave;
            }
            if (ok == 2) {
                return false;
            }
        }
        if ((fileName = this.getFileName()) == null) {
            return this.fileSaveAs();
        }
        String reasonableFilename = this.getReasonableFilename();
        if (reasonableFilename != null) {
            try {
                String a = new File(reasonableFilename).getCanonicalPath();
                String b = new File(fileName).getCanonicalPath();
                if (!a.equals(b)) {
                    int ok = JOptionPane.showConfirmDialog(this, fileName + " should be saved in: \n" + reasonableFilename + "\n  Would you like to save it there instead?", "Name has changed", 1);
                    if (ok == 2) {
                        return false;
                    }
                    if (ok == 0) {
                        this.repositoryManager.clearRobotList();
                        return this.fileSaveAs();
                    }
                }
            }
            catch (IOException e) {
                Logger.logError((String)"Unable to check reasonable filename: ", (Throwable)e);
            }
        }
        OutputStreamWriter writer = null;
        try {
            writer = new FileWriter(new File(fileName));
            this.getEditorPane().write(writer);
            this.setModified(false);
        }
        catch (IOException e) {
            this.error("Cannot write file: " + e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ignored) {}
            }
        }
        return true;
    }

    public boolean fileSaveAs() {
        File f;
        int pEIndex;
        String fileName;
        String javaFileName = null;
        String saveDir = fileName = this.robotsDirectory.getPath() + File.separatorChar;
        String text = this.getEditorPane().getText();
        int pIndex = text.indexOf("package ");
        if (pIndex >= 0 && (pEIndex = text.indexOf(";", pIndex)) > 0) {
            String packageTree = text.substring(pIndex + 8, pEIndex) + File.separatorChar;
            packageTree = packageTree.replace('.', File.separatorChar);
            saveDir = fileName = fileName + packageTree;
        }
        if ((pIndex = text.indexOf("public class ")) >= 0) {
            pEIndex = text.indexOf(" ", pIndex + 13);
            if (pEIndex > 0) {
                int pEIndex2 = text.indexOf("\n", pIndex + 13);
                if (pEIndex2 > 0 && pEIndex2 < pEIndex) {
                    pEIndex = pEIndex2;
                }
                javaFileName = text.substring(pIndex + 13, pEIndex).trim() + ".java";
            } else {
                pEIndex = text.indexOf("\n", pIndex + 13);
                if (pEIndex > 0) {
                    javaFileName = text.substring(pIndex + 13, pEIndex).trim() + ".java";
                }
            }
        }
        if (!(f = new File(saveDir)).exists()) {
            int ok = JOptionPane.showConfirmDialog(this, "Your robot should be saved in the directory: " + saveDir + "\nThis directory does not exist, would you like to create it?", "Create Directory", 1);
            if (ok == 0) {
                if (!f.exists() && !f.mkdirs()) {
                    Logger.logError((String)("Can't create" + f));
                }
                f = new File(saveDir);
            }
            if (ok == 2) {
                return false;
            }
        }
        JFileChooser chooser = new JFileChooser(f);
        chooser.setCurrentDirectory(f);
        FileFilter filter = new FileFilter(){

            public boolean accept(File pathname) {
                if (pathname.isDirectory()) {
                    return true;
                }
                String fn = pathname.getName();
                int idx = fn.lastIndexOf(46);
                String extension = "";
                if (idx >= 0) {
                    extension = fn.substring(idx);
                }
                return extension.equalsIgnoreCase(".java");
            }

            public String getDescription() {
                return "Robots";
            }
        };
        chooser.setFileFilter(filter);
        boolean done = false;
        while (!done) {
            int rv;
            done = true;
            if (javaFileName != null) {
                chooser.setSelectedFile(new File(f, javaFileName));
            }
            if ((rv = chooser.showSaveDialog(this)) == 0) {
                String robotFileName = chooser.getSelectedFile().getPath();
                File outFile = new File(robotFileName);
                if (outFile.exists()) {
                    int ok = JOptionPane.showConfirmDialog(this, robotFileName + " already exists.  Are you sure you want to replace it?", "Warning", 1);
                    if (ok == 1) {
                        done = false;
                        continue;
                    }
                    if (ok == 2) {
                        return false;
                    }
                }
                this.setFileName(robotFileName);
                this.fileSave(false);
                continue;
            }
            return false;
        }
        return true;
    }

    private JPanel getEditWindowContentPane() {
        if (this.editWindowContentPane == null) {
            this.editWindowContentPane = new JPanel();
            this.editWindowContentPane.setLayout(new BorderLayout());
            this.editWindowContentPane.setDoubleBuffered(true);
            this.editWindowContentPane.add((Component)this.getScrollPane(), "Center");
        }
        return this.editWindowContentPane;
    }

    public String getPackage() {
        int pEIndex;
        String text = this.getEditorPane().getText();
        int pIndex = text.indexOf("package ");
        if (pIndex >= 0 && (pEIndex = text.indexOf(";", pIndex)) > 0) {
            return text.substring(pIndex + 8, pEIndex);
        }
        return "";
    }

    private String getReasonableFilename() {
        String fileName = this.robotsDirectory.getPath() + File.separatorChar;
        String packageTree = null;
        String text = this.getEditorPane().getText();
        StringTokenizer tokenizer = new StringTokenizer(text, " \t\r\n;");
        boolean inComment = false;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (!inComment && (token.equals("/*") || token.equals("/**"))) {
                inComment = true;
            }
            if (inComment && (token.equals("*/") || token.equals("**/"))) {
                inComment = false;
            }
            if (inComment) continue;
            if (packageTree == null && token.equals("package")) {
                packageTree = tokenizer.nextToken();
                if (packageTree == null || packageTree.length() == 0) {
                    return null;
                }
                packageTree = packageTree.replace('.', File.separatorChar);
                packageTree = packageTree + File.separator;
                fileName = fileName + packageTree;
            }
            if (!token.equals("class")) continue;
            String javaFileName = tokenizer.nextToken() + ".java";
            fileName = fileName + javaFileName;
            return fileName;
        }
        return null;
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setViewportView(this.getEditorPane());
            this.scrollPane.setRowHeaderView(this.getLineNumbers());
        }
        return this.scrollPane;
    }

    private LineNumbers getLineNumbers() {
        if (this.lineNumbers == null) {
            this.lineNumbers = new LineNumbers(this.getEditorPane());
        }
        return this.lineNumbers;
    }

    public void undo() {
        ((JavaDocument)this.getEditorPane().getDocument()).undo();
        this.repaint();
    }

    public void redo() {
        ((JavaDocument)this.getEditorPane().getDocument()).redo();
        this.repaint();
    }
}

