/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.editor;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public class CompilerProperties {
    public static final String COMPILER_BINARY = "compiler.binary";
    public static final String COMPILER_OPTIONS = "compiler.options";
    public static final String COMPILER_CLASSPATH = "compiler.classpath";
    public static final String ROBOCODE_VERSION = "robocode.version";
    private String compilerBinary;
    private String compilerOptions;
    private String compilerClasspath;
    private String robocodeVersion;
    private final Properties props = new Properties();

    public String getCompilerBinary() {
        if (this.compilerBinary == null) {
            this.setCompilerBinary("");
        }
        return this.compilerBinary;
    }

    public String getCompilerClasspath() {
        if (this.compilerClasspath == null) {
            this.setCompilerClasspath("");
        }
        return this.compilerClasspath;
    }

    public String getCompilerOptions() {
        if (this.compilerOptions == null) {
            this.setCompilerOptions("");
        }
        return this.compilerOptions;
    }

    public String getRobocodeVersion() {
        return this.robocodeVersion;
    }

    public void resetCompiler() {
        this.compilerBinary = null;
        this.props.remove(COMPILER_BINARY);
    }

    public void setCompilerBinary(String compilerBinary) {
        this.compilerBinary = compilerBinary;
        this.props.setProperty(COMPILER_BINARY, compilerBinary);
    }

    public void setCompilerClasspath(String compilerClasspath) {
        this.compilerClasspath = compilerClasspath;
        this.props.setProperty(COMPILER_CLASSPATH, compilerClasspath);
    }

    public void setCompilerOptions(String compilerOptions) {
        this.compilerOptions = compilerOptions;
        this.props.setProperty(COMPILER_OPTIONS, compilerOptions);
    }

    public void setRobocodeVersion(String robocodeVersion) {
        this.robocodeVersion = robocodeVersion;
        this.props.setProperty(ROBOCODE_VERSION, robocodeVersion);
    }

    public void load(InputStream is) throws IOException {
        this.props.load(is);
        this.compilerBinary = this.props.getProperty(COMPILER_BINARY);
        this.compilerOptions = this.props.getProperty(COMPILER_OPTIONS);
        this.compilerClasspath = this.props.getProperty(COMPILER_CLASSPATH);
        this.robocodeVersion = this.props.getProperty(ROBOCODE_VERSION);
    }

    public void store(OutputStream os, String header) throws IOException {
        this.props.store(os, header);
    }
}

