/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.repository.root;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.util.ArrayList;
import net.sf.robocode.core.Container;
import net.sf.robocode.io.Logger;
import net.sf.robocode.repository.Database;
import net.sf.robocode.repository.items.IItem;
import net.sf.robocode.repository.items.handlers.ItemHandler;
import net.sf.robocode.repository.root.BaseRoot;
import net.sf.robocode.repository.root.IRepositoryRoot;
import net.sf.robocode.ui.IWindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathRoot
extends BaseRoot
implements IRepositoryRoot {
    private static final long serialVersionUID = 1L;
    private final File parentPath;

    public ClassPathRoot(Database db, File rootPath, File parentPath) {
        super(db, rootPath);
        this.parentPath = parentPath;
    }

    @Override
    public void update(boolean updateInvalid) {
        IWindowManager windowManager = (IWindowManager)Container.getComponent(IWindowManager.class);
        this.setStatus(windowManager, "Updating class path: " + this.rootPath);
        this.db.moveOldItems(this);
        ArrayList<IItem> items = new ArrayList<IItem>();
        ArrayList<Long> modified = new ArrayList<Long>();
        this.visitDirectory(this.rootPath, items, modified);
        for (int i = 0; i < items.size(); ++i) {
            IItem item = items.get(i);
            item.update(modified.get(i), updateInvalid);
        }
    }

    private void visitDirectory(File path, final ArrayList<IItem> items, final ArrayList<Long> modified) {
        path.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                if (pathname.isFile()) {
                    try {
                        IItem item = ItemHandler.registerItems(pathname.toURI().toURL(), ClassPathRoot.this, ClassPathRoot.this.db);
                        if (item != null) {
                            items.add(item);
                            modified.add(pathname.lastModified());
                        }
                    }
                    catch (MalformedURLException e) {
                        Logger.logError((Throwable)e);
                        return false;
                    }
                }
                return false;
            }
        });
        for (File subDir : path.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory() && !pathname.getName().toLowerCase().endsWith(".data") && !pathname.getName().toLowerCase().endsWith(".robotcache");
            }
        })) {
            this.visitDirectory(subDir, items, modified);
        }
    }

    @Override
    public void update(IItem item, boolean force) {
        File f = new File(item.getFullUrl().toString());
        item.update(f.lastModified(), force);
    }

    @Override
    public boolean isChanged(IItem item) {
        File f = new File(item.getFullUrl().toString());
        return f.lastModified() > item.getLastModified();
    }

    @Override
    public boolean isDevel() {
        return true;
    }

    @Override
    public boolean isJar() {
        return false;
    }

    public File getParentPath() {
        return this.parentPath;
    }

    private void setStatus(IWindowManager windowManager, String message) {
        if (windowManager != null) {
            windowManager.setStatus(message);
        }
    }
}

