/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.repository.packager;

import codesize.Codesize;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import net.sf.robocode.core.Container;
import net.sf.robocode.host.IHostManager;
import net.sf.robocode.io.FileUtil;
import net.sf.robocode.io.Logger;
import net.sf.robocode.repository.IRobotRepositoryItem;
import net.sf.robocode.repository.items.RobotItem;
import net.sf.robocode.repository.items.TeamItem;
import net.sf.robocode.version.IVersionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarCreator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createPackage(File target, boolean includeSources, List<RobotItem> robots, List<TeamItem> teams, URL web, String desc, String author, String version) {
        HashSet<String> entries;
        block15: {
            IHostManager host = (IHostManager)Container.getComponent(IHostManager.class);
            String rVersion = ((IVersionManager)Container.getComponent(IVersionManager.class)).getVersion();
            JarOutputStream jarout = null;
            FileOutputStream fos = null;
            entries = new HashSet<String>();
            try {
                JarEntry jt;
                fos = new FileOutputStream(target);
                jarout = new JarOutputStream((OutputStream)fos, JarCreator.createManifest(robots));
                jarout.setComment(rVersion + " - Robocode version");
                for (TeamItem team : teams) {
                    String teamEntry = team.getRelativePath() + '/' + team.getShortClassName() + ".team";
                    if (entries.contains(teamEntry)) continue;
                    jt = new JarEntry(teamEntry);
                    jarout.putNextEntry(jt);
                    entries.add(teamEntry);
                    try {
                        team.storeProperties(jarout, web, desc, author, version, includeSources);
                    }
                    finally {
                        jarout.closeEntry();
                    }
                }
                for (RobotItem robot : robots) {
                    String propsEntry = robot.getRelativePath() + '/' + robot.getShortClassName() + ".properties";
                    if (entries.contains(propsEntry)) continue;
                    jt = new JarEntry(propsEntry);
                    jarout.putNextEntry(jt);
                    entries.add(propsEntry);
                    try {
                        robot.storeProperties(jarout, web, desc, author, version, includeSources);
                    }
                    finally {
                        jarout.closeEntry();
                    }
                    JarCreator.packageSourceAndClasses(includeSources, host, jarout, robot, entries);
                }
                FileUtil.cleanupStream((Object)jarout);
            }
            catch (IOException e) {
                Logger.logError((Throwable)e);
                break block15;
            }
            finally {
                FileUtil.cleanupStream(jarout);
                FileUtil.cleanupStream((Object)fos);
            }
            FileUtil.cleanupStream((Object)fos);
        }
        StringBuilder sb = new StringBuilder();
        for (String entry : entries) {
            sb.append(entry);
            sb.append('\n');
        }
        JarCreator.codeSize(target, sb);
        return sb.toString();
    }

    private static void codeSize(File target, StringBuilder sb) {
        Codesize.Item item = Codesize.processZipFile((File)target);
        int codesize = item.getCodeSize();
        String weightClass = codesize >= 1500 ? "MegaBot  (codesize >= 1500 bytes)" : (codesize > 750 ? "MiniBot  (codesize < 1500 bytes)" : (codesize > 250 ? "MicroBot  (codesize < 750 bytes)" : "NanoBot  (codesize < 250 bytes)"));
        sb.append("\n\n---- Codesize ----\n");
        sb.append("Codesize: ").append(codesize).append(" bytes\n");
        sb.append("Robot weight class: ").append(weightClass).append('\n');
    }

    private static Manifest createManifest(List<RobotItem> robots) {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        StringBuilder robotsString = new StringBuilder();
        for (int i = 0; i < robots.size(); ++i) {
            robotsString.append(robots.get(i).getFullClassName());
            if (i >= robots.size() - 1) continue;
            robotsString.append(',');
        }
        manifest.getMainAttributes().put(new Attributes.Name("robots"), robotsString.toString());
        return manifest;
    }

    private static void packageSourceAndClasses(boolean includeSources, IHostManager host, JarOutputStream jarout, RobotItem robot, Set<String> entries) throws IOException {
        for (String className : host.getReferencedClasses((IRobotRepositoryItem)robot)) {
            if (className.startsWith("java") || className.startsWith("robocode")) continue;
            String name = className.replace('.', '/');
            JarCreator.packageSourceAndClass(includeSources, jarout, robot, name, entries);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void packageSourceAndClass(boolean includeSource, JarOutputStream jarout, RobotItem robot, String name, Set<String> entries) throws IOException {
        File classFile;
        String javaFileName = name + ".java";
        String classFileName = name + ".class";
        if (includeSource && !entries.contains(javaFileName) && !name.contains("$")) {
            for (URL sourcePathURL : robot.getSourcePathURLs()) {
                File javaFile = new File(sourcePathURL.getFile(), javaFileName);
                if (!javaFile.exists()) continue;
                JarEntry je = new JarEntry(javaFileName);
                jarout.putNextEntry(je);
                entries.add(javaFileName);
                try {
                    JarCreator.copy(javaFile, jarout);
                }
                finally {
                    jarout.closeEntry();
                }
            }
        }
        if ((classFile = new File(robot.getClassPathURL().getFile(), classFileName)).exists() && !entries.contains(classFileName)) {
            JarEntry je = new JarEntry(classFileName);
            jarout.putNextEntry(je);
            entries.add(classFileName);
            try {
                JarCreator.copy(classFile, jarout);
            }
            finally {
                jarout.closeEntry();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(File inFile, JarOutputStream out) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(inFile);
            byte[] buf = new byte[4096];
            while (in.available() > 0) {
                int count = in.read(buf, 0, 4096);
                out.write(buf, 0, count);
            }
        }
        catch (Throwable throwable) {
            FileUtil.cleanupStream(in);
            throw throwable;
        }
        FileUtil.cleanupStream((Object)in);
    }
}

