/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.repository.items.handlers;

import java.net.URL;
import net.sf.robocode.repository.Database;
import net.sf.robocode.repository.items.IItem;
import net.sf.robocode.repository.items.RobotItem;
import net.sf.robocode.repository.items.handlers.ItemHandler;
import net.sf.robocode.repository.root.IRepositoryRoot;

public class SourceHandler
extends ItemHandler {
    public IItem acceptItem(URL itemURL, IRepositoryRoot root, Database db) {
        String name = itemURL.toString().toLowerCase();
        if (name.endsWith(".java") && !name.contains("$")) {
            return this.register(itemURL, root, db);
        }
        return null;
    }

    private IItem register(URL itemURL, IRepositoryRoot root, Database db) {
        String itemKey = SourceHandler.getItemKey(itemURL, root);
        RobotItem item = (RobotItem)db.getOldItem(itemKey);
        if (item == null) {
            item = (RobotItem)db.getItem(itemKey);
        }
        if (item == null) {
            item = new RobotItem(root);
        }
        item.addSourcePathURL(root.getRootUrl());
        db.putItem(itemKey, item);
        return item;
    }
}

