/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.repository;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.robocode.core.Container;
import net.sf.robocode.io.FileUtil;
import net.sf.robocode.io.Logger;
import net.sf.robocode.io.URLJarCollector;
import net.sf.robocode.repository.Database;
import net.sf.robocode.repository.IRepositoryItem;
import net.sf.robocode.repository.IRepositoryManager;
import net.sf.robocode.repository.items.BaseItem;
import net.sf.robocode.repository.items.IItem;
import net.sf.robocode.repository.items.RobotItem;
import net.sf.robocode.repository.items.TeamItem;
import net.sf.robocode.repository.packager.JarCreator;
import net.sf.robocode.security.HiddenAccess;
import net.sf.robocode.settings.ISettingsListener;
import net.sf.robocode.settings.ISettingsManager;
import net.sf.robocode.ui.IWindowManager;
import net.sf.robocode.version.IVersionManager;
import robocode.control.RobotSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryManager
implements IRepositoryManager {
    private final ISettingsManager properties;
    private Database db;

    public RepositoryManager(ISettingsManager properties) {
        this.properties = properties;
        properties.addPropertyListener(new ISettingsListener(){

            public void settingChanged(String property) {
                if (property.equals("robocode.options.development.path")) {
                    RepositoryManager.this.reload(false);
                }
            }
        });
    }

    public File getRobotsDirectory() {
        return FileUtil.getRobotsDir();
    }

    public List<File> getDevelDirectories() {
        ArrayList<File> develDirectories = new ArrayList<File>();
        String externalPath = this.properties.getOptionsDevelopmentPath();
        StringTokenizer tokenizer = new StringTokenizer(externalPath, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            try {
                File f = new File(tokenizer.nextToken()).getCanonicalFile();
                develDirectories.add(f);
            }
            catch (IOException e) {
                throw new Error(e);
            }
        }
        return develDirectories;
    }

    public void refresh(String file) {
        if (!this.db.update(file, true)) {
            this.refresh(true);
        }
        URLJarCollector.gc();
    }

    public boolean refresh() {
        return this.refresh(false);
    }

    public boolean refresh(boolean updateInvalid) {
        boolean refreshed = this.db.update(this.getRobotsDirectory(), this.getDevelDirectories(), updateInvalid);
        if (refreshed) {
            this.setStatus("Saving robot database");
            this.db.save();
        }
        this.setStatus("");
        URLJarCollector.gc();
        return refreshed;
    }

    public void reload(boolean forced) {
        if (forced) {
            this.db = new Database(this);
            Logger.logMessage((String)"Rebuilding robot database...");
        } else if (this.db == null) {
            this.setStatus("Reading robot database");
            this.db = Database.load(this);
            if (this.db == null) {
                this.setStatus("Building robot database");
                this.db = new Database(this);
            }
        }
        this.refresh(true);
        this.setStatus("");
    }

    public RobotSpecification[] getSpecifications() {
        this.checkDbExists();
        List<IRepositoryItem> list = this.db.getAllSpecifications();
        ArrayList<RobotSpecification> res = new ArrayList<RobotSpecification>();
        for (IRepositoryItem s : list) {
            res.add(s.createRobotSpecification());
        }
        return res.toArray(new RobotSpecification[res.size()]);
    }

    public RobotSpecification[] loadSelectedRobots(RobotSpecification[] selectedRobots) {
        this.checkDbExists();
        ArrayList<RobotSpecification> battlingRobotsList = new ArrayList<RobotSpecification>();
        int teamNum = 0;
        for (RobotSpecification spec : selectedRobots) {
            IRepositoryItem item = (IRepositoryItem)HiddenAccess.getFileSpecification((RobotSpecification)spec);
            if (item == null) {
                item = this.getRobot(spec.getNameAndVersion());
            }
            this.loadItem(battlingRobotsList, spec, item, teamNum);
            ++teamNum;
        }
        return battlingRobotsList.toArray(new RobotSpecification[battlingRobotsList.size()]);
    }

    public RobotSpecification[] loadSelectedRobots(String selectedRobots) {
        this.checkDbExists();
        ArrayList<RobotSpecification> battlingRobotsList = new ArrayList<RobotSpecification>();
        List<IRepositoryItem> list = this.db.getSelectedSpecifications(selectedRobots);
        int teamNum = 0;
        for (IRepositoryItem item : list) {
            this.loadItem(battlingRobotsList, null, item, teamNum);
            ++teamNum;
        }
        return battlingRobotsList.toArray(new RobotSpecification[battlingRobotsList.size()]);
    }

    private boolean loadItem(List<RobotSpecification> battlingRobotsList, RobotSpecification spec, IRepositoryItem item, int teamNum) {
        String teamId = String.format("%4d", teamNum);
        if (item != null) {
            if (item.isTeam()) {
                teamId = item.getFullClassNameWithVersion() + "[" + teamId + "]";
                List<RobotItem> members = this.db.expandTeam((TeamItem)item);
                Iterator<RobotItem> i$ = members.iterator();
                while (i$.hasNext()) {
                    RobotItem member;
                    RobotItem robot = member = i$.next();
                    boolean tested = false;
                    for (RobotSpecification loaded : battlingRobotsList) {
                        if (!HiddenAccess.getFileSpecification((RobotSpecification)loaded).equals(robot)) continue;
                        tested = true;
                        break;
                    }
                    if (!tested && !robot.validate()) continue;
                    battlingRobotsList.add(robot.createRobotSpecification(null, teamId));
                }
            } else {
                RobotItem robot = (RobotItem)item;
                if (robot.validate()) {
                    battlingRobotsList.add(robot.createRobotSpecification(spec, null));
                } else {
                    Logger.logError((String)("Could not load robot: " + robot.getFullClassName()));
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public RobotSpecification[] getSelectedRobots(String selectedRobots) {
        this.checkDbExists();
        ArrayList<RobotSpecification> battlingRobotsList = new ArrayList<RobotSpecification>();
        List<IRepositoryItem> list = this.db.getSelectedSpecifications(selectedRobots);
        for (IRepositoryItem item : list) {
            battlingRobotsList.add(item.createRobotSpecification());
        }
        return battlingRobotsList.toArray(new RobotSpecification[battlingRobotsList.size()]);
    }

    public List<IRepositoryItem> getSelectedSpecifications(String selectedRobots) {
        this.checkDbExists();
        return this.db.getSelectedSpecifications(selectedRobots);
    }

    public List<IRepositoryItem> filterRepositoryItems(boolean onlyWithSource, boolean onlyWithPackage, boolean onlyRobots, boolean onlyDevelopment, boolean onlyNotDevelopment, boolean ignoreTeamRobots, boolean onlyInJar) {
        this.checkDbExists();
        return this.db.filterSpecifications(onlyWithSource, onlyWithPackage, onlyRobots, onlyDevelopment, onlyNotDevelopment, onlyInJar);
    }

    public boolean verifyRobotName(String robotName, String shortClassName) {
        return RobotItem.verifyRobotName(robotName, shortClassName, true);
    }

    public int extractJar(IRepositoryItem item) {
        if (!item.isInJar()) {
            return -2;
        }
        ((BaseItem)item).getRoot().extractJar();
        return 0;
    }

    public void createTeam(File target, URL web, String desc, String author, String members, String teamVersion) throws IOException {
        this.checkDbExists();
        String ver = ((IVersionManager)Container.getComponent(IVersionManager.class)).getVersion();
        TeamItem.createOrUpdateTeam(target, web, desc, author, members, teamVersion, ver);
        this.refresh(target.toURI().toString());
    }

    public String createPackage(File target, URL web, String desc, String author, String version, boolean source, List<IRepositoryItem> selectedRobots) {
        this.checkDbExists();
        List<RobotItem> robots = this.db.expandTeams(selectedRobots);
        List<TeamItem> teams = this.db.filterTeams(selectedRobots);
        String res = JarCreator.createPackage(target, source, robots, teams, web, desc, author, version);
        this.refresh(target.toURI().toString());
        return res;
    }

    private IRepositoryItem getRobot(String fullClassNameWithVersion) {
        IItem item = this.db.getItem(fullClassNameWithVersion);
        if (item == null || !item.isValid()) {
            return null;
        }
        return (IRepositoryItem)item;
    }

    private void setStatus(String message) {
        IWindowManager windowManager = (IWindowManager)Container.getComponent(IWindowManager.class);
        if (windowManager != null) {
            windowManager.setStatus(message);
        }
        if (message.length() > 0) {
            Logger.logMessage((String)message);
        }
    }

    private void checkDbExists() {
        if (this.db == null) {
            this.reload(false);
        }
    }
}

