/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.repository;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import net.sf.robocode.io.FileUtil;
import net.sf.robocode.io.Logger;
import net.sf.robocode.repository.ITeamFileSpecificationExt;
import net.sf.robocode.repository.NamedFileSpecification;
import net.sf.robocode.repository.RobotFileSpecification;

class TeamFileSpecification
extends NamedFileSpecification
implements ITeamFileSpecificationExt {
    private static final String TEAM_DESCRIPTION = "team.description";
    private static final String TEAM_AUTHOR_NAME = "team.author.name";
    private static final String TEAM_AUTHOR_EMAIL = "team.author.email";
    private static final String TEAM_AUTHOR_WEBSITE = "team.author.website";
    private static final String TEAM_VERSION = "team.version";
    private static final String TEAM_WEBPAGE = "team.webpage";
    private static final String TEAM_MEMBERS = "team.members";
    private static final String TEAM_JAVA_SOURCE_INCLUDED = "team.java.source.included";
    protected boolean teamJavaSourceIncluded = false;
    private String members = "";
    private String uid = "";

    protected TeamFileSpecification(File f, File rootDir, String prefix, boolean developmentVersion) {
        this.developmentVersion = developmentVersion;
        this.rootDir = rootDir;
        this.valid = true;
        String filename = f.getName();
        String fileType = FileUtil.getFileType((String)filename);
        if (fileType.equals(".team")) {
            try {
                FileInputStream in = new FileInputStream(f);
                this.load(in);
            }
            catch (IOException e) {
                Logger.logError((String)("Warning:  Could not load team: " + f));
            }
            if (filename.indexOf(" ") >= 0) {
                this.setName(prefix + FileUtil.getClassName((String)filename.substring(0, filename.indexOf(" "))));
            } else {
                this.setName(prefix + FileUtil.getClassName((String)filename));
            }
            this.setFileLastModified(f.lastModified());
            this.setFileLength(f.length());
            this.setFileType(".team");
            try {
                this.setFilePath(f.getCanonicalPath());
            }
            catch (IOException e) {
                Logger.logError((String)("Warning:  Unable to determine canonical path for " + f.getPath()));
                this.setFilePath(f.getPath());
            }
        } else {
            throw new RuntimeException("TeamFileSpecification can only be constructed from a .team file");
        }
        this.setPropertiesFileName(f.getPath());
        this.setFileName(f.getName());
        byte[] mb = this.getMembers().getBytes();
        long uid1 = 0L;
        for (byte element : mb) {
            uid1 += (long)element;
        }
        long uid2 = mb.length;
        this.uid = uid1 + "" + uid2;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String getUid() {
        return this.uid;
    }

    public TeamFileSpecification() {
    }

    public void load(FileInputStream in) throws IOException {
        super.load(in);
        this.authorEmail = this.props.getProperty(TEAM_AUTHOR_EMAIL);
        this.authorName = this.props.getProperty(TEAM_AUTHOR_NAME);
        this.authorWebsite = this.props.getProperty(TEAM_AUTHOR_WEBSITE);
        this.description = this.props.getProperty(TEAM_DESCRIPTION);
        this.version = this.props.getProperty(TEAM_VERSION);
        if (this.version != null && this.version.length() == 0) {
            this.version = null;
        }
        this.members = this.props.getProperty(TEAM_MEMBERS);
        try {
            String team_webpage = this.props.getProperty(TEAM_WEBPAGE);
            if (team_webpage != null) {
                this.webpage = new URL(team_webpage);
            }
        }
        catch (MalformedURLException e) {
            this.webpage = null;
        }
        this.teamJavaSourceIncluded = Boolean.valueOf(this.props.getProperty(TEAM_JAVA_SOURCE_INCLUDED, "false"));
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTeamDescription(String teamDescription) {
        this.description = teamDescription;
        this.props.setProperty(TEAM_DESCRIPTION, teamDescription);
    }

    public void setTeamAuthorName(String teamAuthorName) {
        this.authorName = teamAuthorName;
        this.props.setProperty(TEAM_AUTHOR_NAME, teamAuthorName);
    }

    public void setTeamAuthorEmail(String teamAuthorEmail) {
        this.authorEmail = teamAuthorEmail;
        this.props.setProperty(TEAM_AUTHOR_EMAIL, teamAuthorEmail);
    }

    public void setTeamAuthorWebsite(String teamAuthorWebsite) {
        this.authorWebsite = teamAuthorWebsite;
        this.props.setProperty(TEAM_AUTHOR_WEBSITE, teamAuthorWebsite);
    }

    public void setTeamVersion(String teamVersion) {
        this.version = teamVersion;
        if (this.version != null && this.version.length() == 0) {
            this.version = null;
        }
        if (this.version != null) {
            this.props.setProperty(TEAM_VERSION, this.version);
        } else {
            this.props.remove(TEAM_VERSION);
        }
    }

    public void setTeamWebpage(URL teamWebpage) {
        this.webpage = teamWebpage;
        if (teamWebpage != null) {
            this.props.setProperty(TEAM_WEBPAGE, teamWebpage.toString());
        } else {
            this.props.remove(TEAM_WEBPAGE);
        }
    }

    public String getMembers() {
        return this.members;
    }

    public void setMembers(String members) {
        this.members = members;
        this.props.setProperty(TEAM_MEMBERS, members);
    }

    public void addMember(RobotFileSpecification robotFileSpecification) {
        this.members = this.members == null || this.members.length() == 0 ? robotFileSpecification.getFullClassNameWithVersion() : this.members + "," + robotFileSpecification.getFullClassNameWithVersion();
        this.props.setProperty(TEAM_MEMBERS, this.members);
    }

    public boolean getTeamJavaSourceIncluded() {
        return this.teamJavaSourceIncluded;
    }

    public void setTeamJavaSourceIncluded(boolean teamJavaSourceIncluded) {
        this.teamJavaSourceIncluded = teamJavaSourceIncluded;
        this.props.setProperty(TEAM_JAVA_SOURCE_INCLUDED, "" + teamJavaSourceIncluded);
    }
}

