/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.repository;

import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import net.sf.robocode.host.IHostManager;
import net.sf.robocode.io.FileUtil;
import net.sf.robocode.io.Logger;
import net.sf.robocode.repository.IRobotFileSpecification;
import net.sf.robocode.repository.IRobotFileSpecificationExt;
import net.sf.robocode.repository.NamedFileSpecification;
import net.sf.robocode.repository.RepositoryManager;
import robocode.Droid;
import robocode.Robot;
import robocode.robotinterfaces.IAdvancedRobot;
import robocode.robotinterfaces.IBasicRobot;
import robocode.robotinterfaces.IInteractiveRobot;
import robocode.robotinterfaces.IJuniorRobot;
import robocode.robotinterfaces.IPaintRobot;
import robocode.robotinterfaces.ITeamRobot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RobotFileSpecification
extends NamedFileSpecification
implements IRobotFileSpecificationExt {
    private static final String ROBOT_DESCRIPTION = "robot.description";
    private static final String ROBOT_AUTHOR_NAME = "robot.author.name";
    private static final String ROBOT_AUTHOR_EMAIL = "robot.author.email";
    private static final String ROBOT_AUTHOR_WEBSITE = "robot.author.website";
    private static final String ROBOT_JAVA_SOURCE_INCLUDED = "robot.java.source.included";
    private static final String ROBOT_VERSION = "robot.version";
    private static final String ROBOT_CLASSNAME = "robot.classname";
    private static final String ROBOT_WEBPAGE = "robot.webpage";
    private String uid = "";
    protected boolean robotJavaSourceIncluded;
    private boolean isJuniorRobot;
    private boolean isStandardRobot;
    private boolean isInteractiveRobot;
    private boolean isPaintRobot;
    private boolean isAdvancedRobot;
    private boolean isTeamRobot;
    private boolean isDroid;

    protected RobotFileSpecification(File f, File rootDir, String prefix, boolean developmentVersion) {
        this.valid = true;
        String filename = f.getName();
        String filepath = f.getPath();
        String fileType = FileUtil.getFileType((String)filename);
        this.rootDir = rootDir;
        this.developmentVersion = developmentVersion;
        if (prefix.length() == 0 && fileType.equals(".jar")) {
            throw new RuntimeException("Robot Specification can only be constructed from a .class file");
        }
        if (fileType.equals(".team")) {
            throw new RuntimeException("Robot Specification can only be constructed from a .class file");
        }
        if (fileType.equals(".java")) {
            this.loadProperties(filepath);
            this.setName(prefix + FileUtil.getClassName((String)filename));
        } else if (fileType.equals(".class")) {
            String jfn;
            File jf;
            this.loadProperties(filepath);
            this.setName(prefix + FileUtil.getClassName((String)filename));
            if (this.isDevelopmentVersion() && (jf = new File(jfn = filepath.substring(0, filepath.lastIndexOf(".")) + ".java")).exists()) {
                this.setRobotJavaSourceIncluded(true);
            }
        } else if (fileType.equals(".properties")) {
            this.loadProperties(filepath);
            this.setName(prefix + FileUtil.getClassName((String)filename));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties(String filepath) {
        File classFile;
        String propertiesFileName = filepath.substring(0, filepath.lastIndexOf(".")) + ".properties";
        File propertiesFile = new File(propertiesFileName);
        FileInputStream in = null;
        try {
            if (propertiesFile.exists()) {
                in = new FileInputStream(propertiesFile);
                this.load(in);
                in.close();
                if (propertiesFile.length() == 0L) {
                    this.setRobotVersion("?");
                    if (!this.developmentVersion) {
                        this.valid = false;
                    }
                }
            } else if (!this.developmentVersion) {
                this.valid = false;
            }
        }
        catch (IOException e) {
            Logger.logError((String)("Warning:  Could not load properties file: " + propertiesFileName));
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignored) {}
            }
        }
        this.setPropertiesFileName(propertiesFileName);
        String htmlfn = filepath.substring(0, filepath.lastIndexOf(".")) + ".html";
        File htmlFile = new File(htmlfn);
        if (htmlFile.exists() && (this.getWebpage() == null || this.getWebpage().toString().length() == 0)) {
            try {
                this.setRobotWebpage(htmlFile.toURI().toURL());
            }
            catch (MalformedURLException e) {
                this.setRobotWebpage(null);
            }
        }
        if ((classFile = new File(filepath.substring(0, filepath.lastIndexOf(".")) + ".class")).exists()) {
            this.setFileLastModified(classFile.lastModified());
            this.setFileLength(classFile.length());
            this.setFileType(".class");
            try {
                this.setFilePath(classFile.getCanonicalPath());
            }
            catch (IOException e) {
                Logger.logError((String)("Warning:  Unable to determine canonical path for " + classFile.getPath()));
                this.setFilePath(classFile.getPath());
            }
            this.setFileName(classFile.getName());
        }
    }

    @Override
    public void load(FileInputStream in) throws IOException {
        super.load(in);
        this.authorEmail = this.props.getProperty(ROBOT_AUTHOR_EMAIL);
        this.authorName = this.props.getProperty(ROBOT_AUTHOR_NAME);
        this.authorWebsite = this.props.getProperty(ROBOT_AUTHOR_WEBSITE);
        this.description = this.props.getProperty(ROBOT_DESCRIPTION);
        this.version = this.props.getProperty(ROBOT_VERSION);
        if (this.version != null && this.version.length() == 0) {
            this.version = null;
        }
        this.name = this.props.getProperty(ROBOT_CLASSNAME);
        String w = this.props.getProperty(ROBOT_WEBPAGE);
        if (w == null) {
            this.webpage = null;
        } else if (w.length() == 0) {
            this.webpage = null;
        } else {
            try {
                this.webpage = new URL(w);
            }
            catch (MalformedURLException e) {
                try {
                    this.webpage = new URL("http://" + w);
                }
                catch (MalformedURLException e2) {
                    this.webpage = null;
                }
            }
        }
        this.robotJavaSourceIncluded = Boolean.valueOf(this.props.getProperty(ROBOT_JAVA_SOURCE_INCLUDED, "false"));
    }

    public void setName(String name) {
        this.name = name;
        this.props.setProperty(ROBOT_CLASSNAME, name);
    }

    @Override
    public void setRobotDescription(String robotDescription) {
        this.description = robotDescription;
        this.props.setProperty(ROBOT_DESCRIPTION, robotDescription);
    }

    @Override
    public void setRobotAuthorName(String robotAuthorName) {
        this.authorName = robotAuthorName;
        this.props.setProperty(ROBOT_AUTHOR_NAME, robotAuthorName);
    }

    public void setRobotAuthorEmail(String robotAuthorEmail) {
        this.authorEmail = robotAuthorEmail;
        this.props.setProperty(ROBOT_AUTHOR_EMAIL, robotAuthorEmail);
    }

    public void setRobotAuthorWebsite(String robotAuthorWebsite) {
        this.authorWebsite = robotAuthorWebsite;
        this.props.setProperty(ROBOT_AUTHOR_WEBSITE, robotAuthorWebsite);
    }

    public boolean getRobotJavaSourceIncluded() {
        return this.robotJavaSourceIncluded;
    }

    @Override
    public void setRobotJavaSourceIncluded(boolean robotJavaSourceIncluded) {
        this.robotJavaSourceIncluded = robotJavaSourceIncluded;
        this.props.setProperty(ROBOT_JAVA_SOURCE_INCLUDED, "" + robotJavaSourceIncluded);
    }

    @Override
    public void setRobotVersion(String robotVersion) {
        this.version = robotVersion;
        if (this.version != null && this.version.length() == 0) {
            this.version = null;
        }
        if (this.version != null) {
            this.props.setProperty(ROBOT_VERSION, this.version);
        } else {
            this.props.remove(ROBOT_VERSION);
        }
    }

    public URL getRobotClassPath() {
        try {
            return this.rootDir.getCanonicalFile().toURL();
        }
        catch (MalformedURLException e) {
            throw new Error(e);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public String getRootPackageDirectory() {
        int dotIndex = this.name.indexOf(".");
        String rootPackage = dotIndex > 0 ? this.name.substring(0, dotIndex) : null;
        return this.rootDir.toString() + File.separator + rootPackage;
    }

    public String getRobotPackageDirectory() {
        return this.rootDir.toString() + File.separator + this.getFullPackage();
    }

    @Override
    public void setRobotWebpage(URL robotWebpage) {
        this.webpage = robotWebpage;
        if (robotWebpage == null) {
            this.props.remove(ROBOT_WEBPAGE);
        } else {
            this.props.setProperty(ROBOT_WEBPAGE, this.webpage.toString());
        }
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public void setUid(String uid) {
        this.uid = uid;
    }

    public boolean isDroid() {
        return this.isDroid;
    }

    public boolean isTeamRobot() {
        return this.isTeamRobot;
    }

    public boolean isAdvancedRobot() {
        return this.isAdvancedRobot;
    }

    public boolean isStandardRobot() {
        return this.isStandardRobot;
    }

    public boolean isInteractiveRobot() {
        return this.isInteractiveRobot;
    }

    public boolean isPaintRobot() {
        return this.isPaintRobot;
    }

    public boolean isJuniorRobot() {
        return this.isJuniorRobot;
    }

    public boolean update(IHostManager hostManager) {
        try {
            Class robotClass = hostManager.loadRobotClass((IRobotFileSpecification)this);
            if (Modifier.isAbstract(robotClass.getModifiers())) {
                return false;
            }
            this.checkInterfaces(robotClass);
            return this.isJuniorRobot || this.isStandardRobot || this.isAdvancedRobot;
        }
        catch (Throwable t) {
            Logger.logError((String)(this.getName() + ": Got an error with this class: " + t.toString()));
            return false;
        }
    }

    private void checkInterfaces(Class<?> robotClass) {
        if (Droid.class.isAssignableFrom(robotClass)) {
            this.isDroid = true;
        }
        if (ITeamRobot.class.isAssignableFrom(robotClass)) {
            this.isTeamRobot = true;
        }
        if (IAdvancedRobot.class.isAssignableFrom(robotClass)) {
            this.isAdvancedRobot = true;
        }
        if (IInteractiveRobot.class.isAssignableFrom(robotClass) && (this.checkMethodOverride(robotClass, Robot.class, "getInteractiveEventListener", new Class[0]) || this.checkMethodOverride(robotClass, Robot.class, "onKeyPressed", KeyEvent.class) || this.checkMethodOverride(robotClass, Robot.class, "onKeyReleased", KeyEvent.class) || this.checkMethodOverride(robotClass, Robot.class, "onKeyTyped", KeyEvent.class) || this.checkMethodOverride(robotClass, Robot.class, "onMouseClicked", MouseEvent.class) || this.checkMethodOverride(robotClass, Robot.class, "onMouseEntered", MouseEvent.class) || this.checkMethodOverride(robotClass, Robot.class, "onMouseExited", MouseEvent.class) || this.checkMethodOverride(robotClass, Robot.class, "onMousePressed", MouseEvent.class) || this.checkMethodOverride(robotClass, Robot.class, "onMouseReleased", MouseEvent.class) || this.checkMethodOverride(robotClass, Robot.class, "onMouseMoved", MouseEvent.class) || this.checkMethodOverride(robotClass, Robot.class, "onMouseDragged", MouseEvent.class) || this.checkMethodOverride(robotClass, Robot.class, "onMouseWheelMoved", MouseWheelEvent.class))) {
            this.isInteractiveRobot = true;
        }
        if (IPaintRobot.class.isAssignableFrom(robotClass) && (this.checkMethodOverride(robotClass, Robot.class, "getPaintEventListener", new Class[0]) || this.checkMethodOverride(robotClass, Robot.class, "onPaint", Graphics2D.class))) {
            this.isPaintRobot = true;
        }
        if (Robot.class.isAssignableFrom(robotClass) && !this.isAdvancedRobot) {
            this.isStandardRobot = true;
        }
        if (IJuniorRobot.class.isAssignableFrom(robotClass)) {
            this.isJuniorRobot = true;
            if (this.isAdvancedRobot) {
                throw new AccessControlException(this.getName() + ": Junior robot should not implement IAdvancedRobot interface.");
            }
        }
        if (IBasicRobot.class.isAssignableFrom(robotClass) && !this.isAdvancedRobot && !this.isJuniorRobot) {
            this.isStandardRobot = true;
        }
    }

    private boolean checkMethodOverride(Class<?> robotClass, Class<?> knownBase, String name, Class<?> ... parameterTypes) {
        if (knownBase.isAssignableFrom(robotClass)) {
            Method getInteractiveEventListener;
            try {
                getInteractiveEventListener = robotClass.getMethod(name, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                return false;
            }
            if (getInteractiveEventListener.getDeclaringClass().equals(knownBase)) {
                return false;
            }
        }
        return true;
    }

    public boolean verifyRobotName() {
        return RepositoryManager.verifyRobotNameStatic(this.getName(), this.getShortClassName());
    }
}

