/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.repository;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import net.sf.robocode.repository.FileSpecification;
import net.sf.robocode.repository.INamedFileSpecification;
import net.sf.robocode.repository.NamedFileSpecification;
import net.sf.robocode.repository.RobotFileSpecification;
import net.sf.robocode.repository.TeamFileSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Repository {
    private final List<NamedFileSpecification> fileSpecifications = Collections.synchronizedList(new ArrayList());
    private final Hashtable<String, NamedFileSpecification> fileSpecificationsDict = new Hashtable();

    Repository() {
    }

    public void add(NamedFileSpecification fileSpecification) {
        this.fileSpecifications.add(fileSpecification);
        String name = fileSpecification.getFullClassNameWithVersion();
        String unname = fileSpecification.getUniqueFullClassNameWithVersion();
        String rootDir = fileSpecification.getRootDir().toString();
        this.fileSpecificationsDict.put(name, fileSpecification);
        this.fileSpecificationsDict.put(rootDir + name, fileSpecification);
        if (!name.equals(unname)) {
            this.fileSpecificationsDict.put(unname, fileSpecification);
            this.fileSpecificationsDict.put(rootDir + unname, fileSpecification);
        }
    }

    public FileSpecification get(String fullClassNameWithVersion) {
        return this.fileSpecificationsDict.get(fullClassNameWithVersion);
    }

    public List<INamedFileSpecification> getRobotSpecificationsList(boolean onlyWithSource, boolean onlyWithPackage, boolean onlyRobots, boolean onlyDevelopment, boolean onlyNotDevelopment, boolean ignoreTeamRobots) {
        List<INamedFileSpecification> result = Collections.synchronizedList(new ArrayList());
        for (NamedFileSpecification spec : this.fileSpecifications) {
            String version;
            String fullPackage;
            if (!spec.isValid() || spec.isDuplicate() || !(spec instanceof RobotFileSpecification) && onlyRobots || onlyWithPackage && spec.getFullPackage() == null || onlyNotDevelopment && spec.isDevelopmentVersion()) continue;
            if (spec instanceof RobotFileSpecification) {
                RobotFileSpecification robotSpec = (RobotFileSpecification)spec;
                if (onlyWithSource && !robotSpec.getRobotJavaSourceIncluded() || ignoreTeamRobots && robotSpec.isTeamRobot()) {
                    continue;
                }
            } else if (spec instanceof TeamFileSpecification) {
                TeamFileSpecification teamSpec = (TeamFileSpecification)spec;
                if (onlyWithSource && !teamSpec.getTeamJavaSourceIncluded()) continue;
            }
            if (onlyDevelopment && (!spec.isDevelopmentVersion() || (fullPackage = spec.getFullPackage()) != null && (fullPackage.equals("sample") || fullPackage.equals("sampleteam") || fullPackage.equals("sampleex"))) || (version = spec.getVersion()) != null && (version.indexOf(",") >= 0 || version.indexOf(" ") >= 0 || version.indexOf("*") >= 0 || version.indexOf("(") >= 0 || version.indexOf(")") >= 0 || version.indexOf("{") >= 0 || version.indexOf("}") >= 0)) continue;
            result.add(spec);
        }
        return result;
    }

    public void sortRobotSpecifications() {
        Collections.sort(this.fileSpecifications);
    }
}

