/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.repository;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import net.sf.robocode.repository.FileSpecification;
import net.sf.robocode.repository.INamedFileSpecification;
import net.sf.robocode.repository.JarFileSpecification;
import net.sf.robocode.repository.NamedFileSpecification;
import net.sf.robocode.repository.RobotFileSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileSpecificationDatabase
implements Serializable {
    private Map<String, FileSpecification> hash = new HashMap<String, FileSpecification>();

    FileSpecificationDatabase() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File f) throws IOException, ClassNotFoundException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            ObjectInputStream in = new ObjectInputStream(fis);
            Object obj = in.readObject();
            if (obj instanceof Hashtable) {
                Hashtable hashtable = (Hashtable)obj;
                this.hash = new HashMap<String, FileSpecification>(hashtable);
            } else {
                this.hash = (HashMap)obj;
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    public void store(File f) throws IOException {
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(f));
        out.writeObject(this.hash);
        out.close();
    }

    public boolean contains(String fullClassName, String version, boolean isDevelopmentVersion) {
        for (FileSpecification fileSpecification : this.hash.values()) {
            NamedFileSpecification namedFileSpecification;
            if (!(fileSpecification instanceof INamedFileSpecification) || (namedFileSpecification = (NamedFileSpecification)fileSpecification).isDuplicate() || namedFileSpecification.isDevelopmentVersion() != isDevelopmentVersion || !fullClassName.equals(namedFileSpecification.getFullClassName())) continue;
            if (version == null && namedFileSpecification.getVersion() == null) {
                return true;
            }
            if (version == null || namedFileSpecification.getVersion() == null || !version.equals(namedFileSpecification.getVersion())) continue;
            return true;
        }
        return false;
    }

    public FileSpecification get(String fullClassName, String version, boolean isDevelopmentVersion) {
        for (FileSpecification fileSpecification : this.hash.values()) {
            if (!(fileSpecification instanceof INamedFileSpecification)) continue;
            INamedFileSpecification namedFileSpecification = (INamedFileSpecification)fileSpecification;
            if (fileSpecification.isDuplicate() || fileSpecification.isDevelopmentVersion() != isDevelopmentVersion || !fullClassName.equals(namedFileSpecification.getFullClassName())) continue;
            if (version == null && fileSpecification.getVersion() == null) {
                return fileSpecification;
            }
            if (version == null || fileSpecification.getVersion() == null || !version.equals(fileSpecification.getVersion())) continue;
            return fileSpecification;
        }
        return null;
    }

    public List<FileSpecification> getFileSpecifications() {
        ArrayList<FileSpecification> v = new ArrayList<FileSpecification>();
        for (String key : this.hash.keySet()) {
            v.add(this.hash.get(key));
        }
        return v;
    }

    public List<JarFileSpecification> getJarSpecifications() {
        ArrayList<JarFileSpecification> v = new ArrayList<JarFileSpecification>();
        for (String key : this.hash.keySet()) {
            FileSpecification spec = this.hash.get(key);
            if (!(spec instanceof JarFileSpecification)) continue;
            v.add((JarFileSpecification)spec);
        }
        return v;
    }

    public FileSpecification get(String key) {
        FileSpecification o = this.hash.get(key);
        if (o == null) {
            return null;
        }
        if (!(o instanceof FileSpecification)) {
            return null;
        }
        return o;
    }

    public void remove(String key) {
        FileSpecification removedS = this.hash.get(key);
        if (removedS == null) {
            return;
        }
        this.hash.remove(key);
        if (!(removedS instanceof RobotFileSpecification)) {
            return;
        }
        RobotFileSpecification removedSpecification = (RobotFileSpecification)removedS;
        if (removedSpecification.isDuplicate()) {
            return;
        }
        if (removedSpecification.isDevelopmentVersion()) {
            return;
        }
        RobotFileSpecification unduplicatedSpec = null;
        String fullClassName = removedSpecification.getFullClassName();
        String version = removedSpecification.getVersion();
        for (FileSpecification fileSpecification : this.hash.values()) {
            RobotFileSpecification spec;
            if (!(fileSpecification instanceof RobotFileSpecification) || (spec = (RobotFileSpecification)fileSpecification).isDevelopmentVersion() || !fullClassName.equals(spec.getFullClassName()) || (version != null || spec.getVersion() != null) && (version == null || spec.getVersion() == null || !version.equals(spec.getVersion()))) continue;
            if (unduplicatedSpec == null) {
                unduplicatedSpec = spec;
                unduplicatedSpec.setDuplicate(false);
                continue;
            }
            if (spec.getFileLastModified() >= unduplicatedSpec.getFileLastModified()) continue;
            unduplicatedSpec.setDuplicate(true);
            spec.setDuplicate(false);
            unduplicatedSpec = spec;
        }
    }

    public void put(String key, FileSpecification spec) {
        this.hash.put(key, spec);
    }
}

