/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.repository;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.UUID;
import net.sf.robocode.io.FileUtil;
import net.sf.robocode.repository.ClassSpecification;
import net.sf.robocode.repository.IRepositoryManager;
import net.sf.robocode.repository.JarFileSpecification;
import net.sf.robocode.repository.RobotFileSpecification;
import net.sf.robocode.repository.TeamFileSpecification;
import net.sf.robocode.security.HiddenAccess;
import robocode.control.RobotSpecification;

abstract class FileSpecification
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    protected final Properties props = new Properties();
    private static final String ROBOCODE_VERSION = "robocode.version";
    private static final String LIBRARY_DESCRIPTION = "library.description";
    private static final String UUID = "uuid";
    protected String uuid;
    protected String name;
    protected String description;
    protected String authorName;
    protected String authorEmail;
    protected String authorWebsite;
    protected String version;
    protected String robocodeVersion;
    protected boolean developmentVersion;
    protected boolean valid;
    protected URL webpage;
    protected String libraryDescription;
    protected File rootDir;
    private File packageFile;
    private String filePath;
    private String fileName;
    private String thisFileName;
    private String fileType;
    private long fileLastModified;
    private long fileLength;
    private boolean duplicate;

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected FileSpecification() {
    }

    public abstract String getUid();

    public static FileSpecification createSpecification(IRepositoryManager repositoryManager, File f, File rootDir, String prefix, boolean developmentVersion) {
        FileSpecification newSpec;
        String filename = f.getName();
        String fileType = FileUtil.getFileType((String)filename);
        if (fileType.equals(".team")) {
            newSpec = new TeamFileSpecification(f, rootDir, prefix, developmentVersion);
        } else if (fileType.equals(".jar") || fileType.equals(".zip")) {
            newSpec = new JarFileSpecification(f, rootDir, developmentVersion);
        } else {
            newSpec = new RobotFileSpecification(f, rootDir, prefix, developmentVersion);
            if (!developmentVersion && !newSpec.isValid()) {
                newSpec = new ClassSpecification((RobotFileSpecification)newSpec);
            }
        }
        newSpec.developmentVersion = developmentVersion;
        newSpec.rootDir = rootDir;
        if (repositoryManager != null) {
            newSpec.storeJarFile(repositoryManager.getRobotsDirectory(), repositoryManager.getRobotCache());
        }
        return newSpec;
    }

    private void storeJarFile(File robotDir, File robotCacheDir) {
        File src = null;
        if (this.rootDir.getName().indexOf(".jar_") == this.rootDir.getName().length() - 5 || this.rootDir.getName().indexOf(".zip_") == this.rootDir.getName().length() - 5) {
            if (this.rootDir.getParentFile().equals(robotCacheDir)) {
                src = new File(robotDir, this.rootDir.getName().substring(0, this.rootDir.getName().length() - 1));
            } else if (this.rootDir.getParentFile().getParentFile().equals(robotCacheDir)) {
                src = new File(this.rootDir.getParentFile(), this.rootDir.getName().substring(0, this.rootDir.getName().length() - 1));
            }
        }
        if (src != null && !src.exists()) {
            src = null;
        }
        this.packageFile = src;
    }

    public File getJarFile() {
        return this.packageFile;
    }

    public String toString() {
        return this.getFileName() + ": length " + this.getFileLength() + " modified " + this.getFileLastModified();
    }

    public boolean isDevelopmentVersion() {
        return this.developmentVersion;
    }

    public boolean isSameFile(String filePath, long fileLength, long fileLastModified) {
        return filePath.equals(this.filePath) && fileLength == this.fileLength && fileLastModified == this.fileLastModified;
    }

    public boolean isSameFile(FileSpecification other) {
        return other != null && other.getFileLength() == this.getFileLength() && other.getFileLastModified() == this.getFileLastModified();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof FileSpecification) {
            FileSpecification other = (FileSpecification)o;
            if (!other.getName().equals(this.getName())) {
                return false;
            }
            if (this.getVersion() == null && other.getVersion() != null) {
                return false;
            }
            if (other.getVersion() == null && this.getVersion() != null) {
                return false;
            }
            if (other.getVersion() != null && this.getVersion() != null && !other.getVersion().equals(this.getVersion())) {
                return false;
            }
            return other.getFileLength() == this.getFileLength() && other.getFileLastModified() == this.getFileLastModified() && other.getFileType().equals(this.getFileType());
        }
        return false;
    }

    public String getUUID() {
        return this.uuid;
    }

    public void setUUID() {
        this.uuid = java.util.UUID.randomUUID().toString();
        this.props.setProperty(UUID, this.uuid);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getAuthorName() {
        return this.authorName;
    }

    public String getAuthorEmail() {
        return this.authorEmail;
    }

    public String getAuthorWebsite() {
        return this.authorWebsite;
    }

    public String getVersion() {
        return this.version;
    }

    public String getRobocodeVersion() {
        return this.robocodeVersion;
    }

    public void setRobocodeVersion(String robocodeVersion) {
        this.robocodeVersion = robocodeVersion;
        this.props.setProperty(ROBOCODE_VERSION, robocodeVersion);
    }

    public String getLibraryDescription() {
        return this.libraryDescription;
    }

    public void setLibraryDescription(String libraryDescription) {
        this.libraryDescription = libraryDescription;
        this.props.setProperty(LIBRARY_DESCRIPTION, libraryDescription);
    }

    public String getPropertiesFileName() {
        return this.thisFileName;
    }

    public void setPropertiesFileName(String thisFileName) {
        this.thisFileName = thisFileName;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public URL getWebpage() {
        return this.webpage;
    }

    public long getFileLastModified() {
        return this.fileLastModified;
    }

    public void setFileLastModified(long fileLastModified) {
        this.fileLastModified = fileLastModified;
    }

    public long getFileLength() {
        return this.fileLength;
    }

    public void setFileLength(long fileLength) {
        this.fileLength = fileLength;
    }

    public void store(OutputStream out, String desc) throws IOException {
        this.setUUID();
        this.props.store(out, desc);
    }

    protected void load(FileInputStream in) throws IOException {
        this.props.load(in);
        this.uuid = this.props.getProperty(UUID);
        this.robocodeVersion = this.props.getProperty(ROBOCODE_VERSION);
        this.libraryDescription = this.props.getProperty(LIBRARY_DESCRIPTION);
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean value) {
        this.valid = value;
    }

    public boolean isDuplicate() {
        return this.duplicate;
    }

    public void setDuplicate(boolean isDuplicate) {
        this.duplicate = isDuplicate;
    }

    public boolean exists() {
        return this.getFilePath() != null && new File(this.getFilePath()).exists();
    }

    public File getRootDir() {
        return this.rootDir;
    }

    public static int compare(String p1, String c1, String v1, String p2, String c2, String v2) {
        int pc;
        if (p1 == null && p2 != null) {
            return 1;
        }
        if (p2 == null && p1 != null) {
            return -1;
        }
        if (p1 != null && (pc = p1.compareToIgnoreCase(p2)) != 0) {
            return pc;
        }
        int cc = c1.compareToIgnoreCase(c2);
        if (cc != 0) {
            return cc;
        }
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v1 == null) {
            return 1;
        }
        if (v2 == null) {
            return -1;
        }
        if (v1.equals(v2)) {
            return 0;
        }
        if (v1.indexOf(".") < 0 || v2.indexOf(".") < 0) {
            return v1.compareToIgnoreCase(v2);
        }
        StringTokenizer s1 = new StringTokenizer(v1, ".");
        StringTokenizer s2 = new StringTokenizer(v2, ".");
        while (s1.hasMoreTokens() && s2.hasMoreTokens()) {
            String tok1 = s1.nextToken();
            String tok2 = s2.nextToken();
            try {
                int i2;
                int i1 = Integer.parseInt(tok1);
                if (i1 == (i2 = Integer.parseInt(tok2))) continue;
                return i1 - i2;
            }
            catch (NumberFormatException e) {
                int tc = tok1.compareToIgnoreCase(tok2);
                if (tc == 0) continue;
                return tc;
            }
        }
        if (s1.hasMoreTokens()) {
            return 1;
        }
        if (s2.hasMoreTokens()) {
            return -1;
        }
        return 0;
    }

    public RobotSpecification createRobotSpecification() {
        return HiddenAccess.createSpecification((Object)this, (String)this.getName(), (String)this.getAuthorName(), (String)(this.getWebpage() != null ? this.getWebpage().toString() : null), (String)this.getVersion(), (String)this.getRobocodeVersion(), (String)(this.getJarFile() != null ? this.getJarFile().toString() : null), (String)this.getName(), (String)this.getDescription());
    }
}

