/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.host.security;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.cert.Certificate;
import java.util.HashSet;
import java.util.Set;
import net.sf.robocode.core.Container;
import net.sf.robocode.host.IHostedThread;
import net.sf.robocode.host.IRobotClassLoader;
import net.sf.robocode.host.security.ClassAnalyzer;
import net.sf.robocode.io.FileUtil;
import net.sf.robocode.io.Logger;
import net.sf.robocode.io.URLJarCollector;
import robocode.robotinterfaces.IBasicRobot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RobotClassLoader
extends URLClassLoader
implements IRobotClassLoader {
    private static final boolean isSecutityOn = !System.getProperty("NOSECURITY", "false").equals("true");
    private Field classesField = null;
    protected Class<?> robotClass;
    protected final String fullClassName;
    private PermissionCollection emptyPermissions;
    private IHostedThread robotProxy;
    private CodeSource codeSource;
    protected URL robotClassPath;
    private Set<String> referencedClasses = new HashSet<String>();
    public static final String untrustedURL = "http://robocode.sf.net/untrusted";
    private ClassLoader parent;

    public RobotClassLoader(URL robotClassPath, String robotFullClassName) {
        super(new URL[]{robotClassPath}, Container.systemLoader);
        this.prepareForCleanup();
        this.fullClassName = robotFullClassName;
        this.robotClassPath = robotClassPath;
        this.emptyPermissions = new Permissions();
        this.parent = this.getParent();
        try {
            this.codeSource = new CodeSource(new URL(untrustedURL), (Certificate[])null);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public void setRobotProxy(Object robotProxy) {
        this.robotProxy = (IHostedThread)robotProxy;
    }

    @Override
    public synchronized void addURL(URL url) {
        super.addURL(url);
    }

    @Override
    public synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> result;
        if (name.startsWith("java.lang")) {
            return super.loadClass(name, resolve);
        }
        if (isSecutityOn) {
            this.testPackages(name);
        }
        if (!name.startsWith("robocode") && (result = this.loadRobotClassLocaly(name, resolve)) != null) {
            return result;
        }
        return this.parent.loadClass(name);
    }

    private void testPackages(String name) throws ClassNotFoundException {
        if (name.startsWith("net.sf.robocode")) {
            String message = "Robots are not allowed to reference Robocode engine in package: net.sf.robocode";
            this.punishSecurityViolation("Robots are not allowed to reference Robocode engine in package: net.sf.robocode");
            throw new ClassNotFoundException("Robots are not allowed to reference Robocode engine in package: net.sf.robocode");
        }
        if (name.startsWith("robocode.control")) {
            String message = "Robots are not allowed to reference Robocode engine in package: robocode.control";
            this.punishSecurityViolation("Robots are not allowed to reference Robocode engine in package: robocode.control");
            throw new ClassNotFoundException("Robots are not allowed to reference Robocode engine in package: robocode.control");
        }
        if (isSecutityOn && name.startsWith("javax.swing")) {
            String message = "Robots are not allowed to reference Robocode engine in package: javax.swing";
            this.punishSecurityViolation("Robots are not allowed to reference Robocode engine in package: javax.swing");
            throw new ClassNotFoundException("Robots are not allowed to reference Robocode engine in package: javax.swing");
        }
    }

    private Class<?> loadRobotClassLocaly(String name, boolean resolve) throws ClassNotFoundException {
        ByteBuffer resource;
        Class<?> result = this.findLoadedClass(name);
        if (result == null && (resource = this.findLocalResource(name)) != null) {
            result = this.defineClass(name, resource, this.codeSource);
            if (resolve) {
                this.resolveClass(result);
            }
            ClassAnalyzer.getReferencedClasses(resource, this.referencedClasses);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer findLocalResource(String name) {
        String path = name.replace('.', '/').concat(".class");
        URL url = this.findResource(path);
        ByteBuffer result = null;
        InputStream is = null;
        if (url != null) {
            try {
                URLConnection connection = URLJarCollector.openConnection((URL)url);
                is = connection.getInputStream();
                result = ByteBuffer.allocate(8192);
                boolean done = false;
                while (true) {
                    int res;
                    if ((res = is.read(result.array(), result.position(), result.remaining())) == -1) {
                        done = true;
                    } else {
                        result.position(result.position() + res);
                        if (result.remaining() != 0) continue;
                    }
                    result.flip();
                    if (!done) {
                        result = ByteBuffer.allocate(result.capacity() * 2).put(result);
                    }
                    if (done) break;
                }
            }
            catch (IOException e) {
                ByteBuffer byteBuffer;
                try {
                    Logger.logError((Throwable)e);
                    byteBuffer = null;
                }
                catch (Throwable throwable) {
                    FileUtil.cleanupStream(is);
                    throw throwable;
                }
                FileUtil.cleanupStream((Object)is);
                return byteBuffer;
            }
            FileUtil.cleanupStream((Object)is);
        }
        return result;
    }

    private void punishSecurityViolation(String message) {
        if (this.robotProxy != null) {
            this.robotProxy.punishSecurityViolation(message);
        }
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codesource) {
        if (isSecutityOn) {
            return this.emptyPermissions;
        }
        return super.getPermissions(codesource);
    }

    public String[] getReferencedClasses() {
        return this.referencedClasses.toArray(new String[this.referencedClasses.size()]);
    }

    public synchronized Class<?> loadRobotMainClass(boolean resolve) throws ClassNotFoundException {
        try {
            if (this.robotClass == null) {
                this.robotClass = this.loadClass(this.fullClassName, false);
                if (!IBasicRobot.class.isAssignableFrom(this.robotClass)) {
                    return null;
                }
                if (resolve) {
                    HashSet<String> clone;
                    this.robotClass = this.loadClass(this.fullClassName, true);
                    this.robotClass.getMethods();
                    do {
                        clone = new HashSet<String>(this.referencedClasses);
                        for (String reference : clone) {
                            this.testPackages(reference);
                            if (reference.startsWith("java.") || reference.startsWith("robocode.")) continue;
                            this.loadClass(reference, true);
                        }
                    } while (this.referencedClasses.size() != clone.size());
                }
            }
        }
        catch (Throwable e) {
            this.robotClass = null;
            throw new ClassNotFoundException(e.getMessage(), e);
        }
        return this.robotClass;
    }

    public IBasicRobot createRobotInstance() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.loadRobotMainClass(true);
        return (IBasicRobot)this.robotClass.newInstance();
    }

    public void cleanup() {
        this.referencedClasses = null;
        if (this.classesField != null) {
            try {
                this.classesField.set(this, null);
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    private void prepareForCleanup() {
        Field[] fields;
        for (Field field : fields = ClassLoader.class.getDeclaredFields()) {
            if (!field.getName().equals("classes")) continue;
            this.classesField = field;
            break;
        }
        if (this.classesField == null) {
            Logger.logError((String)("RobotClassLoader: Failed to find classes field in: " + this));
        }
    }
}

