/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.host.security;

import java.security.AccessControlException;
import net.sf.robocode.host.IHostedThread;
import net.sf.robocode.host.IThreadManager;

public class RobocodeSecurityManager
extends SecurityManager {
    public static final boolean isSecutityOn = !System.getProperty("NOSECURITY", "false").equals("true");
    private final IThreadManager threadManager;

    public RobocodeSecurityManager(IThreadManager threadManager) {
        this.threadManager = threadManager;
        for (ThreadGroup tg = Thread.currentThread().getThreadGroup(); tg != null; tg = tg.getParent()) {
            threadManager.addSafeThreadGroup(tg);
        }
        this.isSafeThread(Thread.currentThread());
        if (isSecutityOn) {
            System.setSecurityManager(this);
        }
    }

    public void checkAccess(ThreadGroup g) {
        if (!isSecutityOn) {
            return;
        }
        Thread c = Thread.currentThread();
        if (this.isSafeThread(c)) {
            return;
        }
        super.checkAccess(g);
        ThreadGroup cg = c.getThreadGroup();
        if (cg == null) {
            return;
        }
        IHostedThread robotProxy = this.threadManager.getLoadedOrLoadingRobotProxy(c);
        if (robotProxy != null) {
            if (cg.activeCount() > 5) {
                String message = "Preventing " + c.getName() + " from access to thread group " + g.getName() + ". You may only create 5 threads.";
                robotProxy.punishSecurityViolation(message);
                throw new AccessControlException(message);
            }
            return;
        }
        throw new AccessControlException("Preventing thread " + c.getName() + " with unknown thread group " + g.getName() + " from access");
    }

    private boolean isSafeThread(Thread c) {
        return this.threadManager.isSafeThread(c);
    }
}

