/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.host.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.sf.robocode.host.IHostedThread;
import net.sf.robocode.host.io.RobotFileOutputStream;
import net.sf.robocode.io.FileUtil;

public class RobotFileSystemManager {
    private final IHostedThread robotProxy;
    private long quotaUsed;
    private boolean quotaMessagePrinted;
    private final List<RobotFileOutputStream> streams = new ArrayList<RobotFileOutputStream>();
    private final long maxQuota;
    private final String writableRootDirectory;
    private final String readableRootDirectory;
    private final String rootFile;
    private final String dataDir;

    public RobotFileSystemManager(IHostedThread robotProxy, long maxQuota, String writableRootDirectory, String readableRootDirectory, String rootFile) {
        this.robotProxy = robotProxy;
        this.maxQuota = maxQuota;
        this.writableRootDirectory = writableRootDirectory;
        this.readableRootDirectory = readableRootDirectory;
        this.rootFile = rootFile;
        this.dataDir = robotProxy.getStatics().getFullClassName().replace('.', '/') + ".data/";
    }

    public void initialize() {
        this.initializeQuota();
        this.updateDataFiles();
    }

    public void addStream(RobotFileOutputStream s) throws IOException {
        if (s == null) {
            throw new SecurityException("You may not add a null stream.");
        }
        if (!this.streams.contains(s)) {
            if (this.streams.size() < 5) {
                this.streams.add(s);
            } else {
                throw new SecurityException("You may only have 5 streams open at a time.\n Make sure you call close() on your streams when you are finished with them.");
            }
        }
    }

    public synchronized void adjustQuota(long len) {
        this.quotaUsed += len;
    }

    public void checkQuota() throws IOException {
        this.checkQuota(0L);
    }

    public void checkQuota(long numBytes) throws IOException {
        if (numBytes < 0L) {
            throw new IllegalArgumentException("checkQuota on negative numBytes!");
        }
        if (this.quotaUsed + numBytes > this.maxQuota) {
            String msg = "You have reached your filesystem quota of: " + this.maxQuota + " bytes.";
            if (!this.quotaMessagePrinted) {
                this.robotProxy.println("SYSTEM: " + msg);
                this.quotaMessagePrinted = true;
            }
            throw new SecurityException(msg);
        }
        this.adjustQuota(numBytes);
    }

    public long getMaxQuota() {
        return this.maxQuota;
    }

    public long getQuotaUsed() {
        return this.quotaUsed;
    }

    public File getReadableDirectory() {
        try {
            String dir = this.readableRootDirectory;
            return dir == null ? null : new File(dir).getCanonicalFile();
        }
        catch (IOException e) {
            return null;
        }
    }

    public File getWritableDirectory() {
        try {
            String dir = this.writableRootDirectory;
            return dir == null ? null : new File(this.writableRootDirectory, this.robotProxy.getStatics().getShortClassName() + ".data").getCanonicalFile();
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public File getDataFile(String filename) {
        File parent = this.getWritableDirectory();
        File file = new File(parent, filename);
        if (!file.exists()) {
            if (!parent.exists() && !parent.mkdirs()) {
                return file;
            }
            InputStream is = null;
            FileOutputStream os = null;
            try {
                URL unUrl = new URL(this.rootFile + this.dataDir + filename);
                URLConnection connection = unUrl.openConnection();
                connection.setUseCaches(false);
                is = connection.getInputStream();
                os = new FileOutputStream(file);
                this.copyStream(is, os);
            }
            catch (IOException ignore) {
                FileUtil.cleanupStream(is);
                FileUtil.cleanupStream(os);
                catch (Throwable throwable) {
                    FileUtil.cleanupStream(is);
                    FileUtil.cleanupStream(os);
                    throw throwable;
                }
            }
            FileUtil.cleanupStream((Object)is);
            FileUtil.cleanupStream((Object)os);
        }
        return file;
    }

    private void initializeQuota() {
        this.quotaUsed = 0L;
        this.quotaMessagePrinted = false;
        File dataDirectory = this.getWritableDirectory();
        if (dataDirectory != null && dataDirectory.exists()) {
            File[] dataFiles;
            for (File file : dataFiles = dataDirectory.listFiles()) {
                this.quotaUsed += file.length();
            }
        }
    }

    public boolean isReadable(String fileName) {
        File attemptedFile;
        File allowedDirectory = this.getReadableDirectory();
        if (allowedDirectory == null) {
            return false;
        }
        try {
            attemptedFile = new File(fileName).getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        if (attemptedFile.equals(allowedDirectory)) {
            return true;
        }
        if (attemptedFile.getParent().indexOf(allowedDirectory.toString()) == 0) {
            String fs = attemptedFile.toString();
            int dataIndex = fs.indexOf(".data", allowedDirectory.toString().length());
            if (dataIndex >= 0) {
                if (this.isWritable(fileName) || attemptedFile.equals(this.getWritableDirectory())) {
                    return true;
                }
                throw new AccessControlException("Preventing " + Thread.currentThread().getName() + " from access to: " + fileName + ": You may not read another robot's data directory.");
            }
            return true;
        }
        return false;
    }

    public boolean isWritable(String fileName) {
        File attemptedFile;
        File allowedDirectory = this.getWritableDirectory();
        if (allowedDirectory == null) {
            return false;
        }
        try {
            attemptedFile = new File(fileName).getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        return attemptedFile.equals(allowedDirectory) || attemptedFile.getParentFile().equals(allowedDirectory);
    }

    public void removeStream(RobotFileOutputStream s) {
        if (s == null) {
            throw new SecurityException("You may not remove a null stream.");
        }
        if (this.streams.contains(s)) {
            this.streams.remove(s);
        }
    }

    private void updateDataFiles() {
        try {
            if (this.rootFile.startsWith("jar:")) {
                this.updateDataFilesFromJar();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDataFilesFromJar() throws IOException {
        URL url = new URL(this.rootFile);
        JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
        jarConnection.setUseCaches(false);
        JarFile jarFile = jarConnection.getJarFile();
        Enumeration<JarEntry> entries = jarFile.entries();
        File parent = this.getWritableDirectory();
        parent.mkdirs();
        InputStream is = null;
        FileOutputStream os = null;
        while (entries.hasMoreElements()) {
            JarEntry jarEntry = entries.nextElement();
            String filename = jarEntry.getName();
            if (!filename.startsWith(this.dataDir) || (filename = filename.substring(this.dataDir.length())).length() == 0) continue;
            is = null;
            os = null;
            try {
                is = jarFile.getInputStream(jarEntry);
                os = new FileOutputStream(new File(parent, filename));
                this.copyStream(is, os);
            }
            catch (Throwable throwable) {
                FileUtil.cleanupStream((Object)is);
                FileUtil.cleanupStream(os);
                throw throwable;
            }
            FileUtil.cleanupStream((Object)is);
            FileUtil.cleanupStream((Object)os);
        }
    }

    private void copyStream(InputStream is, OutputStream os) throws IOException {
        int len;
        BufferedInputStream bis = new BufferedInputStream(is);
        BufferedOutputStream bos = new BufferedOutputStream(os);
        byte[] buf = new byte[8192];
        while ((len = bis.read(buf)) > 0) {
            bos.write(buf, 0, len);
        }
        bos.flush();
    }
}

