/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.host.security;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.cert.Certificate;
import java.util.HashSet;
import java.util.Set;
import net.sf.robocode.core.Container;
import net.sf.robocode.host.IHostedThread;
import net.sf.robocode.host.security.ClassAnalyzer;
import net.sf.robocode.io.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RobotClassLoader
extends URLClassLoader {
    private static final boolean isSecutityOn = !System.getProperty("NOSECURITY", "false").equals("true");
    private Field classesField = null;
    private Class<?> robotClass;
    private final String fullClassName;
    private PermissionCollection emptyPermissions;
    private IHostedThread robotProxy;
    private CodeSource codeSource;
    private Set<String> referencedClasses = new HashSet<String>();
    public static final String untrustedURL = "http://robocode.sf.net/untrusted";

    public RobotClassLoader(URL robotClassPath, String robotFullClassName) {
        this(robotClassPath, robotFullClassName, null);
    }

    public RobotClassLoader(URL robotClassPath, String robotFullClassName, IHostedThread robotProxy) {
        super(new URL[]{robotClassPath}, Container.systemLoader);
        this.prepareForCleanup();
        this.fullClassName = robotFullClassName;
        this.emptyPermissions = new Permissions();
        this.robotProxy = robotProxy;
        try {
            this.codeSource = new CodeSource(new URL(untrustedURL), (Certificate[])null);
        }
        catch (MalformedURLException ignored) {
            // empty catch block
        }
    }

    @Override
    public synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (name.startsWith("java.lang")) {
            return super.loadClass(name, resolve);
        }
        if (isSecutityOn) {
            Class<?> result;
            if (name.startsWith("net.sf.robocode")) {
                String message = "Robots are not allowed to reference robocode engine in net.sf.robocode package";
                this.notifyRobot("Robots are not allowed to reference robocode engine in net.sf.robocode package");
                throw new ClassNotFoundException("Robots are not allowed to reference robocode engine in net.sf.robocode package");
            }
            if (name.startsWith("robocode.control")) {
                String message = "Robots are not allowed to reference robocode engine in robocode.control package";
                this.notifyRobot("Robots are not allowed to reference robocode engine in robocode.control package");
                throw new ClassNotFoundException("Robots are not allowed to reference robocode engine in robocode.control package");
            }
            if (name.startsWith("javax.swing")) {
                String message = "Robots are not allowed to reference javax.swing package";
                this.notifyRobot("Robots are not allowed to reference javax.swing package");
                throw new ClassNotFoundException("Robots are not allowed to reference javax.swing package");
            }
            if (!name.startsWith("robocode") && (result = this.loadRobotClassLocaly(name, resolve)) != null) {
                return result;
            }
        }
        return super.loadClass(name, resolve);
    }

    private Class<?> loadRobotClassLocaly(String name, boolean resolve) throws ClassNotFoundException {
        ByteBuffer resource;
        Class<?> result = this.findLoadedClass(name);
        if (result == null && (resource = this.findLocalResource(name)) != null) {
            result = this.defineClass(name, resource, this.codeSource);
            if (resolve) {
                this.resolveClass(result);
            }
            ClassAnalyzer.getReferencedClasses(resource, this.referencedClasses);
        }
        return result;
    }

    private ByteBuffer findLocalResource(String name) {
        String path = name.replace('.', File.separatorChar).concat(".class");
        URL url = this.findResource(path);
        ByteBuffer result = null;
        if (url != null) {
            try {
                InputStream is = url.openStream();
                result = ByteBuffer.allocate(8192);
                boolean done = false;
                while (true) {
                    int res;
                    if ((res = is.read(result.array(), result.position(), result.remaining())) == -1) {
                        done = true;
                    } else {
                        result.position(result.position() + res);
                        if (result.remaining() != 0) continue;
                    }
                    result.flip();
                    if (!done) {
                        result = ByteBuffer.allocate(result.capacity() * 2).put(result);
                    }
                    if (done) break;
                }
            }
            catch (IOException e) {
                Logger.logError((Throwable)e);
                return null;
            }
        }
        return result;
    }

    private void notifyRobot(String s) {
        if (this.robotProxy != null) {
            this.robotProxy.println(s);
            this.robotProxy.disable();
        }
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codesource) {
        if (isSecutityOn) {
            return this.emptyPermissions;
        }
        return super.getPermissions(codesource);
    }

    public String getUid() {
        return null;
    }

    public Set<String> getReferencedClasses() {
        return this.referencedClasses;
    }

    public synchronized Class<?> loadRobotMainClass() throws ClassNotFoundException {
        try {
            if (this.robotClass == null) {
                HashSet<String> clone;
                this.robotClass = this.loadClass(this.fullClassName, true);
                do {
                    clone = new HashSet<String>(this.referencedClasses);
                    for (String reference : clone) {
                        this.loadClass(reference, true);
                    }
                } while (this.referencedClasses.size() != clone.size());
            }
        }
        catch (Throwable e) {
            this.robotClass = null;
            throw new ClassNotFoundException(e.getMessage() + "\nRobots are not allowed to reference robocode engine in robocode.control or net.sf.robocode packages", e);
        }
        return this.robotClass;
    }

    public void cleanup() {
        if (this.classesField != null) {
            try {
                this.classesField.set(this, null);
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    private void prepareForCleanup() {
        Field[] fields;
        for (Field field : fields = ClassLoader.class.getDeclaredFields()) {
            if (!field.getName().equals("classes")) continue;
            this.classesField = field;
            break;
        }
        if (this.classesField == null) {
            Logger.logError((String)("RobotClassLoader: Failed to find classes field in: " + this));
        }
    }
}

