/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.host.security;

import java.awt.AWTPermission;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.net.MalformedURLException;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.PropertyPermission;
import java.util.Set;
import java.util.StringTokenizer;
import net.sf.robocode.core.Container;
import net.sf.robocode.host.IHostedThread;
import net.sf.robocode.host.IThreadManager;
import net.sf.robocode.host.io.RobotFileSystemManager;
import net.sf.robocode.host.security.RobocodePermission;
import net.sf.robocode.io.Logger;
import net.sf.robocode.repository.IRepositoryManager;

public class RobocodeSecurityPolicy
extends Policy {
    private static final boolean isSecutityOn = !System.getProperty("NOSECURITY", "false").equals("true");
    private static final boolean isFileReadSecutityOff = System.getProperty("OVERRIDEFILEREADSECURITY", "false").equals("true");
    private static final boolean isExperimental = System.getProperty("EXPERIMENTAL", "false").equals("true");
    private final Set<String> allowedPackages = new HashSet<String>();
    private final Policy parentPolicy = Policy.getPolicy();
    private final PermissionCollection allPermissions = new Permissions();
    private Set<String> untrustedCodeUrls;
    private final IThreadManager threadManager;

    public RobocodeSecurityPolicy(IThreadManager threadManager) {
        this.allPermissions.add(new AllPermission());
        this.threadManager = threadManager;
        this.allowedPackages.add("robocode.util");
        this.allowedPackages.add("robocode.robotinterfaces");
        this.allowedPackages.add("robocode.robotpaint");
        this.allowedPackages.add("robocode.robocodeGL");
        if (isExperimental) {
            this.allowedPackages.add("robocode.robotinterfaces.peer");
        }
        this.initUrls();
        if (isSecutityOn) {
            Policy.setPolicy(this);
        }
    }

    public PermissionCollection getPermissions(ProtectionDomain domain) {
        return this.getPermissions(domain.getCodeSource());
    }

    public PermissionCollection getPermissions(final CodeSource codeSource) {
        if (!isSecutityOn) {
            return this.allPermissions;
        }
        String source = codeSource.getLocation().toString();
        if (this.untrustedCodeUrls.contains(source)) {
            return new Permissions();
        }
        return AccessController.doPrivileged(new PrivilegedAction<PermissionCollection>(){

            @Override
            public PermissionCollection run() {
                return RobocodeSecurityPolicy.this.parentPolicy.getPermissions(codeSource);
            }
        });
    }

    public boolean implies(ProtectionDomain domain, final Permission permission) {
        if (!isSecutityOn) {
            return true;
        }
        String source = domain.getCodeSource().getLocation().toString();
        if (!this.untrustedCodeUrls.contains(source)) {
            return true;
        }
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return RobocodeSecurityPolicy.this.impliesRobot(permission);
            }
        });
    }

    private boolean impliesRobot(Permission perm) {
        String actions = perm.getActions();
        String name = perm.getName();
        if (perm instanceof FilePermission && actions.equals("read") && isFileReadSecutityOff) {
            return true;
        }
        if (perm instanceof PropertyPermission && actions.equals("read")) {
            return true;
        }
        if (perm instanceof RobocodePermission && (name.equals("System.out") || name.equals("System.err") || name.equals("System.in"))) {
            return true;
        }
        Thread c = Thread.currentThread();
        IHostedThread robotProxy = this.threadManager.getLoadedOrLoadingRobotProxy(c);
        if (robotProxy == null) {
            Logger.logError((String)("Preventing unknown thread " + Thread.currentThread().getName() + " from access: " + perm));
            return false;
        }
        if (perm instanceof AWTPermission) {
            String message = "Preventing " + robotProxy.getStatics().getName() + " from access to AWT: " + perm;
            Logger.logError((String)message);
            robotProxy.disable();
            throw new ThreadDeath();
        }
        if (perm instanceof FilePermission) {
            FilePermission filePermission = (FilePermission)perm;
            RobotFileSystemManager fileSystemManager = robotProxy.getRobotFileSystemManager();
            if (filePermission.getActions().equals("read")) {
                return this.impliesRobotFileRead(robotProxy, fileSystemManager, filePermission);
            }
            if (filePermission.getActions().equals("write")) {
                return this.impliesRobotFileWrite(robotProxy, fileSystemManager, filePermission);
            }
            if (filePermission.getActions().equals("delete")) {
                return this.impliesRobotFileDelete(robotProxy, fileSystemManager, filePermission);
            }
        }
        if (perm instanceof RuntimePermission && name.startsWith("accessClassInPackage.")) {
            return this.impliesRobotPackageAccess(robotProxy, name.substring(21));
        }
        Logger.logError((String)("Preventing " + robotProxy.getStatics().getName() + " from access: " + perm));
        robotProxy.disable();
        return false;
    }

    private boolean impliesRobotPackageAccess(IHostedThread robotProxy, String packageName) {
        if (packageName.startsWith("robocode.control") || packageName.startsWith("net.sf.robocode")) {
            if (this.allowedPackages.contains(packageName)) {
                return true;
            }
            Logger.logError((String)("Preventing " + Thread.currentThread().getName() + " from access to the internal Robocode pakage: " + packageName));
            robotProxy.disable();
            return false;
        }
        return true;
    }

    private boolean impliesRobotFileDelete(IHostedThread robotProxy, RobotFileSystemManager fileSystemManager, FilePermission filePermission) {
        if (fileSystemManager.getWritableDirectory() == null) {
            robotProxy.disable();
            robotProxy.println("Preventing " + robotProxy.getStatics().getName() + " from access: " + filePermission + ": Robots that are not in a package may not delete any files.");
            return false;
        }
        if (fileSystemManager.isWritable(filePermission.getName())) {
            return true;
        }
        if (fileSystemManager.getWritableDirectory().toString().equals(filePermission.getName())) {
            return true;
        }
        robotProxy.disable();
        robotProxy.println("Preventing " + robotProxy.getStatics().getName() + " from access: " + filePermission + ": You may only delete files in your own data directory. ");
        return false;
    }

    private boolean impliesRobotFileWrite(IHostedThread robotProxy, RobotFileSystemManager fileSystemManager, FilePermission filePermission) {
        if (!this.threadManager.checkRobotFileStream()) {
            robotProxy.disable();
            robotProxy.println("Preventing " + robotProxy.getStatics().getName() + " from access: " + filePermission + ": You must use a RobocodeOutputStream.");
            return false;
        }
        if (fileSystemManager.getWritableDirectory() == null) {
            robotProxy.disable();
            robotProxy.println("Preventing " + robotProxy.getStatics().getName() + " from access: " + filePermission + ": Robots that are not in a package may not write any files.");
            return false;
        }
        if (fileSystemManager.isWritable(filePermission.getName())) {
            return true;
        }
        if (fileSystemManager.getWritableDirectory().toString().equals(filePermission.getName())) {
            return true;
        }
        robotProxy.disable();
        robotProxy.println("I would allow access to: " + fileSystemManager.getWritableDirectory());
        robotProxy.println("Preventing " + robotProxy.getStatics().getName() + " from access: " + filePermission + ": You may only write files in your own data directory. ");
        return false;
    }

    private boolean impliesRobotFileRead(IHostedThread robotProxy, RobotFileSystemManager fileSystemManager, FilePermission filePermission) {
        if (fileSystemManager.getReadableDirectory() == null) {
            robotProxy.disable();
            robotProxy.println("Preventing " + robotProxy.getStatics().getName() + " from access: " + filePermission + ": Robots that are not in a package may not read any files.");
            return false;
        }
        if (fileSystemManager.isReadable(filePermission.getName())) {
            return true;
        }
        robotProxy.disable();
        robotProxy.println("Preventing " + robotProxy.getStatics().getName() + " from access: " + filePermission + ": You may only read files in your own root package directory. ");
        return false;
    }

    public void refresh() {
        this.initUrls();
        this.parentPolicy.refresh();
    }

    private void initUrls() {
        this.untrustedCodeUrls = new HashSet<String>();
        this.untrustedCodeUrls.add("http://robocode.sf.net/untrusted");
        String classPath = System.getProperty("robocode.class.path");
        StringTokenizer tokenizer = new StringTokenizer(classPath, File.pathSeparator);
        try {
            ArrayList<String> robots = new ArrayList<String>();
            IRepositoryManager repositoryManager = (IRepositoryManager)Container.getComponent(IRepositoryManager.class);
            if (repositoryManager != null) {
                robots.add(repositoryManager.getRobotsDirectory().toURL().toString());
                for (File devel : repositoryManager.getDevelDirectories()) {
                    robots.add(devel.toURL().toString());
                }
            }
            while (tokenizer.hasMoreTokens()) {
                String u = new File(tokenizer.nextToken()).getCanonicalFile().toURL().toString();
                if (!robots.contains(u) || this.untrustedCodeUrls.contains(u)) continue;
                this.untrustedCodeUrls.add(u);
            }
        }
        catch (MalformedURLException e) {
            Logger.logError((Throwable)e);
        }
        catch (IOException e) {
            Logger.logError((Throwable)e);
        }
    }
}

