/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.host.io;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import net.sf.robocode.host.io.BufferedPipedOutputStream;

public class RobotOutputStream
extends PrintStream {
    private static final int MAX = 100;
    private int count = 0;
    private boolean messaged = false;
    private final StringBuilder text;
    private final Object syncRoot = new Object();

    public RobotOutputStream() {
        super(new BufferedPipedOutputStream(128, true));
        this.text = new StringBuilder(8192);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readAndReset() {
        Object object = this.syncRoot;
        synchronized (object) {
            this.count = 0;
            if (this.text.length() > 0) {
                String result = this.text.toString();
                this.text.setLength(0);
                return result;
            }
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isOkToPrint() {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.count++ > 100) {
                if (!this.messaged) {
                    this.text.append("\n");
                    this.text.append("SYSTEM: This robot is printing too much between actions.  Output stopped until next action.");
                    this.text.append("\n");
                    this.messaged = true;
                }
                return false;
            }
            this.messaged = false;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(char[] s) {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.isOkToPrint()) {
                this.text.append(s);
                if (s != null) {
                    this.count += s.length / 1000;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(char c) {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.isOkToPrint()) {
                this.text.append(c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(double d) {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.isOkToPrint()) {
                this.text.append(d);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(float f) {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.isOkToPrint()) {
                this.text.append(f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(int i) {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.isOkToPrint()) {
                this.text.append(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(long l) {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.isOkToPrint()) {
                this.text.append(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Object obj) {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.isOkToPrint()) {
                if (obj != null) {
                    String s = obj.toString();
                    this.text.append(s);
                    this.count += s.length() / 1000;
                } else {
                    this.text.append((Object)null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(String s) {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.isOkToPrint()) {
                this.text.append(s);
                if (s != null) {
                    this.count += s.length() / 1000;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(boolean b) {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.isOkToPrint()) {
                this.text.append(b);
            }
        }
    }

    public void println() {
        this.print('\n');
    }

    public void println(char[] x) {
        this.print(x);
        this.print('\n');
    }

    public void println(char x) {
        this.print(x);
        this.print('\n');
    }

    public void println(double x) {
        this.print(x);
        this.print('\n');
    }

    public void println(float x) {
        this.print(x);
        this.print('\n');
    }

    public void println(int x) {
        this.print(x);
        this.print('\n');
    }

    public void println(long x) {
        this.print(x);
        this.print('\n');
    }

    public void println(Object x) {
        this.print(x);
        this.print('\n');
    }

    public void println(String x) {
        this.print(x);
        this.print('\n');
    }

    public void println(boolean x) {
        this.print(x);
        this.print('\n');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] buf) {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.isOkToPrint()) {
                this.text.append(Arrays.toString(buf));
                if (buf != null) {
                    this.count += buf.length / 1000;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int b) {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.isOkToPrint()) {
                this.text.append(b);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(Throwable t) {
        if (t != null) {
            Object object = this.syncRoot;
            synchronized (object) {
                if (this.isOkToPrint()) {
                    StringWriter sw = new StringWriter();
                    PrintWriter writer = new PrintWriter(sw);
                    t.printStackTrace(writer);
                    writer.flush();
                    this.text.append(sw.toString());
                }
            }
        }
    }
}

