/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.host.io;

import java.io.File;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.List;
import net.sf.robocode.host.IHostedThread;
import net.sf.robocode.host.io.RobotFileOutputStream;

public class RobotFileSystemManager {
    private final IHostedThread robotProxy;
    private long quotaUsed = 0L;
    private boolean quotaMessagePrinted = false;
    private final List<RobotFileOutputStream> streams = new ArrayList<RobotFileOutputStream>();
    private long maxQuota = 0L;
    private final String writableRootDirectory;
    private final String readableRootDirectory;

    public RobotFileSystemManager(IHostedThread robotProxy, long maxQuota, String writableRootDirectory, String readableRootDirectory) {
        this.robotProxy = robotProxy;
        this.maxQuota = maxQuota;
        this.writableRootDirectory = writableRootDirectory;
        this.readableRootDirectory = readableRootDirectory;
    }

    public void addStream(RobotFileOutputStream s) throws IOException {
        if (s == null) {
            throw new SecurityException("You may not add a null stream.");
        }
        if (!this.streams.contains(s)) {
            if (this.streams.size() < 5) {
                this.streams.add(s);
            } else {
                throw new IOException("You may only have 5 streams open at a time.\n Make sure you call close() on your streams when you are finished with them.");
            }
        }
    }

    public synchronized void adjustQuota(long len) {
        this.quotaUsed += len;
    }

    public void checkQuota() throws IOException {
        this.checkQuota(0L);
    }

    public void checkQuota(long numBytes) throws IOException {
        if (numBytes < 0L) {
            throw new IndexOutOfBoundsException("checkQuota on negative numBytes!");
        }
        if (this.quotaUsed + numBytes <= this.maxQuota) {
            this.adjustQuota(numBytes);
            return;
        }
        if (!this.quotaMessagePrinted) {
            this.robotProxy.println("SYSTEM: You have reached your filesystem quota of: " + this.maxQuota + " bytes.");
            this.quotaMessagePrinted = true;
        }
        throw new IOException("You have reached your filesystem quota of: " + this.maxQuota + " bytes.");
    }

    public long getMaxQuota() {
        return this.maxQuota;
    }

    public long getQuotaUsed() {
        return this.quotaUsed;
    }

    public File getReadableDirectory() {
        try {
            String dir = this.readableRootDirectory;
            return dir == null ? null : new File(dir).getCanonicalFile();
        }
        catch (IOException e) {
            return null;
        }
    }

    public File getWritableDirectory() {
        try {
            String dir = this.writableRootDirectory;
            return dir == null ? null : new File(this.writableRootDirectory, this.robotProxy.getStatics().getShortClassName() + ".data").getCanonicalFile();
        }
        catch (IOException e) {
            return null;
        }
    }

    public void initializeQuota() {
        File dataDirectory = this.getWritableDirectory();
        if (dataDirectory == null) {
            this.quotaUsed = this.maxQuota;
            return;
        }
        if (!dataDirectory.exists()) {
            this.quotaUsed = 0L;
            return;
        }
        this.quotaMessagePrinted = false;
        File[] dataFiles = dataDirectory.listFiles();
        this.quotaUsed = 0L;
        for (File file : dataFiles) {
            this.quotaUsed += file.length();
        }
    }

    public boolean isReadable(String fileName) {
        File attemptedFile;
        File allowedDirectory = this.getReadableDirectory();
        if (allowedDirectory == null) {
            return false;
        }
        try {
            attemptedFile = new File(fileName).getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        if (attemptedFile.equals(allowedDirectory)) {
            return true;
        }
        if (attemptedFile.getParent().indexOf(allowedDirectory.toString()) == 0) {
            String fs = attemptedFile.toString();
            int dataIndex = fs.indexOf(".data", allowedDirectory.toString().length());
            if (dataIndex >= 0) {
                if (this.isWritable(fileName) || attemptedFile.equals(this.getWritableDirectory())) {
                    return true;
                }
                throw new AccessControlException("Preventing " + Thread.currentThread().getName() + " from access to: " + fileName + ": You may not read another robot's data directory.");
            }
            return true;
        }
        return false;
    }

    public boolean isWritable(String fileName) {
        File attemptedFile;
        File allowedDirectory = this.getWritableDirectory();
        if (allowedDirectory == null) {
            return false;
        }
        try {
            attemptedFile = new File(fileName).getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        return attemptedFile.equals(allowedDirectory) || attemptedFile.getParentFile().equals(allowedDirectory);
    }

    public void removeStream(RobotFileOutputStream s) {
        if (s == null) {
            throw new SecurityException("You may not remove a null stream.");
        }
        if (this.streams.contains(s)) {
            this.streams.remove(s);
        }
    }
}

