/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.host.events;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.sf.robocode.host.events.EventQueue;
import net.sf.robocode.host.events.IEventManager;
import net.sf.robocode.host.proxies.BasicRobotProxy;
import net.sf.robocode.peer.IRobotStatics;
import net.sf.robocode.security.HiddenAccess;
import robocode.BattleEndedEvent;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.Condition;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.Event;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.KeyPressedEvent;
import robocode.KeyReleasedEvent;
import robocode.KeyTypedEvent;
import robocode.MessageEvent;
import robocode.MouseClickedEvent;
import robocode.MouseDraggedEvent;
import robocode.MouseEnteredEvent;
import robocode.MouseExitedEvent;
import robocode.MouseMovedEvent;
import robocode.MousePressedEvent;
import robocode.MouseReleasedEvent;
import robocode.MouseWheelMovedEvent;
import robocode.PaintEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.StatusEvent;
import robocode.WinEvent;
import robocode.exception.EventInterruptedException;
import robocode.robotinterfaces.IBasicRobot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventManager
implements IEventManager {
    private BasicRobotProxy robotProxy;
    private static final int MAX_PRIORITY = 100;
    public static final int MAX_EVENT_STACK = 2;
    private int currentTopEventPriority;
    private Event currentTopEvent;
    private final List<Condition> customEvents = new CopyOnWriteArrayList<Condition>();
    private final EventQueue eventQueue;
    private final boolean[] interruptible = new boolean[101];
    private Dictionary<String, Event> namedEvents;
    private ScannedRobotEvent dummyScannedRobotEvent;
    public static final int MAX_QUEUE_SIZE = 256;
    private IBasicRobot robot;

    public EventManager(BasicRobotProxy robotProxy) {
        this.registerNamedEvents();
        this.robotProxy = robotProxy;
        this.eventQueue = new EventQueue();
        this.reset();
    }

    public void add(Event e) {
        if (!HiddenAccess.isCriticalEvent((Event)e)) {
            HiddenAccess.setEventPriority((Event)e, (int)this.getEventPriority(e.getClass().getName()));
            HiddenAccess.setEventTime((Event)e, (long)this.getTime());
        }
        this.addImpl(e);
    }

    private void addImpl(Event e) {
        if (this.eventQueue != null) {
            if (this.eventQueue.size() > 256) {
                System.out.println("Not adding to " + this.robotProxy.getStatics().getName() + "'s queue, exceeded " + 256 + " events in queue.");
                return;
            }
            this.eventQueue.add(e);
        }
    }

    @Override
    public void addCustomEvent(Condition condition) {
        this.customEvents.add(condition);
    }

    @Override
    public void clearAllEvents(boolean includingSystemEvents) {
        this.eventQueue.clear(includingSystemEvents);
    }

    public void cleanup() {
        this.reset();
        this.robot = null;
        this.robotProxy = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Event> getAllEvents() {
        List<Event> events = Collections.synchronizedList(new ArrayList());
        EventQueue eventQueue = this.eventQueue;
        synchronized (eventQueue) {
            for (Event e : this.eventQueue) {
                events.add(e);
            }
        }
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BulletHitBulletEvent> getBulletHitBulletEvents() {
        List<BulletHitBulletEvent> events = Collections.synchronizedList(new ArrayList());
        EventQueue eventQueue = this.eventQueue;
        synchronized (eventQueue) {
            for (Event e : this.eventQueue) {
                if (!(e instanceof BulletHitBulletEvent)) continue;
                events.add((BulletHitBulletEvent)e);
            }
        }
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BulletHitEvent> getBulletHitEvents() {
        List<BulletHitEvent> events = Collections.synchronizedList(new ArrayList());
        EventQueue eventQueue = this.eventQueue;
        synchronized (eventQueue) {
            for (Event e : this.eventQueue) {
                if (!(e instanceof BulletHitEvent)) continue;
                events.add((BulletHitEvent)e);
            }
        }
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BulletMissedEvent> getBulletMissedEvents() {
        List<BulletMissedEvent> events = Collections.synchronizedList(new ArrayList());
        EventQueue eventQueue = this.eventQueue;
        synchronized (eventQueue) {
            for (Event e : this.eventQueue) {
                if (!(e instanceof BulletMissedEvent)) continue;
                events.add((BulletMissedEvent)e);
            }
        }
        return events;
    }

    public int getCurrentTopEventPriority() {
        return this.currentTopEventPriority;
    }

    public Event getCurrentTopEvent() {
        return this.currentTopEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HitByBulletEvent> getHitByBulletEvents() {
        List<HitByBulletEvent> events = Collections.synchronizedList(new ArrayList());
        EventQueue eventQueue = this.eventQueue;
        synchronized (eventQueue) {
            for (Event e : this.eventQueue) {
                if (!(e instanceof HitByBulletEvent)) continue;
                events.add((HitByBulletEvent)e);
            }
        }
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HitRobotEvent> getHitRobotEvents() {
        List<HitRobotEvent> events = Collections.synchronizedList(new ArrayList());
        EventQueue eventQueue = this.eventQueue;
        synchronized (eventQueue) {
            for (Event e : this.eventQueue) {
                if (!(e instanceof HitRobotEvent)) continue;
                events.add((HitRobotEvent)e);
            }
        }
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HitWallEvent> getHitWallEvents() {
        List<HitWallEvent> events = Collections.synchronizedList(new ArrayList());
        EventQueue eventQueue = this.eventQueue;
        synchronized (eventQueue) {
            for (Event e : this.eventQueue) {
                if (!(e instanceof HitWallEvent)) continue;
                events.add((HitWallEvent)e);
            }
        }
        return events;
    }

    public boolean getInterruptible(int priority) {
        return this.interruptible[priority];
    }

    private IBasicRobot getRobot() {
        return this.robot;
    }

    public void setRobot(IBasicRobot r) {
        this.robot = r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RobotDeathEvent> getRobotDeathEvents() {
        List<RobotDeathEvent> events = Collections.synchronizedList(new ArrayList());
        EventQueue eventQueue = this.eventQueue;
        synchronized (eventQueue) {
            for (Event e : this.eventQueue) {
                if (!(e instanceof RobotDeathEvent)) continue;
                events.add((RobotDeathEvent)e);
            }
        }
        return events;
    }

    public int getScannedRobotEventPriority() {
        return this.dummyScannedRobotEvent.getPriority();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ScannedRobotEvent> getScannedRobotEvents() {
        List<ScannedRobotEvent> events = Collections.synchronizedList(new ArrayList());
        EventQueue eventQueue = this.eventQueue;
        synchronized (eventQueue) {
            for (Event e : this.eventQueue) {
                if (!(e instanceof ScannedRobotEvent)) continue;
                events.add((ScannedRobotEvent)e);
            }
        }
        return events;
    }

    public long getTime() {
        return this.robotProxy.getTimeImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvents() {
        this.eventQueue.clear(this.getTime() - 2L);
        for (Condition customEvent : this.customEvents) {
            boolean conditionSatisfied = false;
            this.robotProxy.setTestingCondition(true);
            try {
                conditionSatisfied = customEvent.test();
            }
            finally {
                this.robotProxy.setTestingCondition(false);
            }
            if (!conditionSatisfied) continue;
            CustomEvent event = new CustomEvent(customEvent);
            HiddenAccess.setEventTime((Event)event, (long)this.getTime());
            this.addImpl((Event)event);
        }
        this.eventQueue.sort();
        Event currentEvent = null;
        if (this.eventQueue.size() > 0) {
            currentEvent = (Event)this.eventQueue.get(0);
        }
        while (currentEvent != null && currentEvent.getPriority() >= this.currentTopEventPriority) {
            if (currentEvent.getPriority() == this.currentTopEventPriority) {
                if (this.currentTopEventPriority <= Integer.MIN_VALUE || !this.getInterruptible(this.currentTopEventPriority)) break;
                this.setInterruptible(this.currentTopEventPriority, false);
                throw new EventInterruptedException(currentEvent.getPriority());
            }
            int oldTopEventPriority = this.currentTopEventPriority;
            this.currentTopEventPriority = currentEvent.getPriority();
            this.currentTopEvent = currentEvent;
            this.eventQueue.remove(currentEvent);
            try {
                this.dispatch(currentEvent);
                this.setInterruptible(this.currentTopEventPriority, false);
            }
            catch (EventInterruptedException e) {
                this.currentTopEvent = null;
            }
            catch (RuntimeException e) {
                this.currentTopEventPriority = oldTopEventPriority;
                this.currentTopEvent = null;
                throw e;
            }
            catch (Error e) {
                this.currentTopEventPriority = oldTopEventPriority;
                this.currentTopEvent = null;
                throw e;
            }
            this.currentTopEventPriority = oldTopEventPriority;
            currentEvent = this.eventQueue.size() > 0 ? (Event)this.eventQueue.get(0) : null;
        }
    }

    private void dispatch(Event currentEvent) {
        IBasicRobot robot = this.getRobot();
        if (robot != null && currentEvent != null) {
            try {
                if (currentEvent.getTime() > this.getTime() - 2L || HiddenAccess.isCriticalEvent((Event)currentEvent)) {
                    HiddenAccess.dispatch((Event)currentEvent, (IBasicRobot)robot, (IRobotStatics)this.robotProxy.getStatics(), (Graphics2D)this.robotProxy.getGraphicsImpl());
                }
            }
            catch (Exception ex) {
                this.robotProxy.println("SYSTEM: Exception occurred on " + currentEvent.getClass().getName());
                ex.printStackTrace(this.robotProxy.getOut());
            }
        }
    }

    @Override
    public void removeCustomEvent(Condition condition) {
        this.customEvents.remove(condition);
    }

    public void resetCustomEvents() {
        this.customEvents.clear();
    }

    public synchronized void reset() {
        this.currentTopEventPriority = Integer.MIN_VALUE;
        this.clearAllEvents(true);
        this.customEvents.clear();
    }

    public void setInterruptible(int priority, boolean interruptable) {
        if (priority < 0 || priority > 99) {
            return;
        }
        this.interruptible[priority] = interruptable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MessageEvent> getMessageEvents() {
        List<MessageEvent> events = Collections.synchronizedList(new ArrayList());
        EventQueue eventQueue = this.eventQueue;
        synchronized (eventQueue) {
            for (Event e : this.eventQueue) {
                if (!(e instanceof MessageEvent)) continue;
                events.add((MessageEvent)e);
            }
        }
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StatusEvent> getStatusEvents() {
        List<StatusEvent> events = Collections.synchronizedList(new ArrayList());
        EventQueue eventQueue = this.eventQueue;
        synchronized (eventQueue) {
            for (Event e : this.eventQueue) {
                if (!(e instanceof StatusEvent)) continue;
                events.add((StatusEvent)e);
            }
        }
        return events;
    }

    @Override
    public int getEventPriority(String eventClass) {
        if (eventClass == null) {
            return -1;
        }
        Event event = this.namedEvents.get(eventClass);
        if (event == null) {
            return -1;
        }
        return event.getPriority();
    }

    @Override
    public void setEventPriority(String eventClass, int priority) {
        if (eventClass == null) {
            return;
        }
        Event event = this.namedEvents.get(eventClass);
        if (event == null) {
            this.robotProxy.println("SYSTEM: Unknown event class: " + eventClass);
            return;
        }
        if (HiddenAccess.isCriticalEvent((Event)event)) {
            System.out.println("SYSTEM: You may not change the priority of system event. setPriority ignored.");
        }
        HiddenAccess.setEventPriority((Event)event, (int)priority);
    }

    private void registerNamedEvents() {
        this.namedEvents = new Hashtable<String, Event>();
        this.dummyScannedRobotEvent = new ScannedRobotEvent(null, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.registerNamedEvent((Event)new BattleEndedEvent(false, null));
        this.registerNamedEvent((Event)new BulletHitBulletEvent(null, null));
        this.registerNamedEvent((Event)new BulletHitEvent(null, 0.0, null));
        this.registerNamedEvent((Event)new BulletMissedEvent(null));
        this.registerNamedEvent((Event)new DeathEvent());
        this.registerNamedEvent((Event)new HitByBulletEvent(0.0, null));
        this.registerNamedEvent((Event)new HitRobotEvent(null, 0.0, 0.0, false));
        this.registerNamedEvent((Event)new HitWallEvent(0.0));
        this.registerNamedEvent((Event)new KeyPressedEvent(null));
        this.registerNamedEvent((Event)new KeyReleasedEvent(null));
        this.registerNamedEvent((Event)new KeyTypedEvent(null));
        this.registerNamedEvent((Event)new MessageEvent(null, null));
        this.registerNamedEvent((Event)new MouseClickedEvent(null));
        this.registerNamedEvent((Event)new MouseDraggedEvent(null));
        this.registerNamedEvent((Event)new MouseEnteredEvent(null));
        this.registerNamedEvent((Event)new MouseExitedEvent(null));
        this.registerNamedEvent((Event)new MouseMovedEvent(null));
        this.registerNamedEvent((Event)new MousePressedEvent(null));
        this.registerNamedEvent((Event)new MouseReleasedEvent(null));
        this.registerNamedEvent((Event)new MouseWheelMovedEvent(null));
        this.registerNamedEvent((Event)new PaintEvent());
        this.registerNamedEvent((Event)new RobotDeathEvent(null));
        this.registerNamedEvent((Event)this.dummyScannedRobotEvent);
        this.registerNamedEvent((Event)new SkippedTurnEvent());
        this.registerNamedEvent((Event)new StatusEvent(null));
        this.registerNamedEvent((Event)new WinEvent());
        DummyCustomEvent custom = new DummyCustomEvent();
        this.namedEvents.put("robocode.CustomEvent", (Event)custom);
        this.namedEvents.put("CustomEvent", (Event)custom);
    }

    private void registerNamedEvent(Event e) {
        String name = e.getClass().getName();
        if (!HiddenAccess.isCriticalEvent((Event)e)) {
            HiddenAccess.setDefaultPriority((Event)e);
        }
        this.namedEvents.put(name, e);
        this.namedEvents.put(name.substring(9), e);
    }

    private static final class DummyCustomEvent
    extends CustomEvent {
        private static final long serialVersionUID = 1L;

        public DummyCustomEvent() {
            super(null);
        }
    }
}

