/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.host;

import java.io.PrintStream;
import java.security.AccessControlException;
import net.sf.robocode.host.IHostManager;
import net.sf.robocode.host.IThreadManager;
import net.sf.robocode.host.RobotStatics;
import net.sf.robocode.host.proxies.AdvancedRobotProxy;
import net.sf.robocode.host.proxies.BasicRobotProxy;
import net.sf.robocode.host.proxies.IHostingRobotProxy;
import net.sf.robocode.host.proxies.JuniorRobotProxy;
import net.sf.robocode.host.proxies.StandardRobotProxy;
import net.sf.robocode.host.proxies.TeamRobotProxy;
import net.sf.robocode.host.security.RobocodeSecurityManager;
import net.sf.robocode.host.security.RobocodeSecurityPolicy;
import net.sf.robocode.host.security.RobotClassLoader;
import net.sf.robocode.host.security.SecureInputStream;
import net.sf.robocode.host.security.SecurePrintStream;
import net.sf.robocode.io.Logger;
import net.sf.robocode.peer.IRobotPeer;
import net.sf.robocode.repository.IRobotFileSpecification;
import net.sf.robocode.repository.IRobotFileSpecificationExt;
import net.sf.robocode.security.HiddenAccess;
import net.sf.robocode.settings.ISettingsManager;
import robocode.control.RobotSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostManager
implements IHostManager {
    private final ISettingsManager properties;
    private IThreadManager threadManager;

    public HostManager(ISettingsManager properties, IThreadManager threadManager) {
        this.properties = properties;
        this.threadManager = threadManager;
    }

    private static void initStreams() {
        SecurePrintStream sysout = new SecurePrintStream(Logger.realOut, true);
        SecurePrintStream syserr = new SecurePrintStream(Logger.realErr, true);
        SecureInputStream sysin = new SecureInputStream(System.in);
        System.setOut(sysout);
        if (!System.getProperty("debug", "false").equals("true")) {
            System.setErr(syserr);
        }
        System.setIn(sysin);
    }

    public long getRobotFilesystemQuota() {
        return this.properties.getRobotFilesystemQuota();
    }

    public IThreadManager getThreadManager() {
        return this.threadManager;
    }

    public void resetThreadManager() {
        this.threadManager.reset();
    }

    public void addSafeThread(Thread safeThread) {
        this.threadManager.addSafeThread(safeThread);
    }

    public void removeSafeThread(Thread safeThread) {
        this.threadManager.removeSafeThread(safeThread);
    }

    public PrintStream getRobotOutputStream() {
        return this.threadManager.getRobotOutputStream();
    }

    public IHostingRobotProxy createRobotProxy(RobotSpecification robotSpecification, RobotStatics statics, IRobotPeer peer) {
        BasicRobotProxy robotProxy;
        IRobotFileSpecification specification = (IRobotFileSpecification)HiddenAccess.getFileSpecification((RobotSpecification)robotSpecification);
        if (specification.isTeamRobot()) {
            robotProxy = new TeamRobotProxy(specification, this, peer, statics);
        } else if (specification.isAdvancedRobot()) {
            robotProxy = new AdvancedRobotProxy(specification, this, peer, statics);
        } else if (specification.isStandardRobot()) {
            robotProxy = new StandardRobotProxy(specification, this, peer, statics);
        } else if (specification.isJuniorRobot()) {
            robotProxy = new JuniorRobotProxy(specification, this, peer, statics);
        } else {
            throw new AccessControlException("Unknown robot type");
        }
        return robotProxy;
    }

    public void cleanup() {
    }

    public Class<?> loadRobotClass(IRobotFileSpecification robotFileSpecification) throws ClassNotFoundException {
        RobotClassLoader classLoader = new RobotClassLoader(robotFileSpecification.getRobotClassPath(), robotFileSpecification.getFullClassName());
        Class<?> robotClass = classLoader.loadRobotMainClass();
        ((IRobotFileSpecificationExt)robotFileSpecification).setUid(classLoader.getUid());
        return robotClass;
    }

    public void initSecurity() {
        new RobocodeSecurityPolicy(this.threadManager);
        new RobocodeSecurityManager(this.threadManager);
    }

    static {
        HostManager.initStreams();
    }
}

