/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.repository;

import java.io.Serializable;

public class RobotType
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final transient RobotType INVALID = new RobotType(0);
    public static final transient RobotType JUNIOR = new RobotType(1);
    public static final transient RobotType STANDARD = new RobotType(2);
    public static final transient RobotType ADVANCED = new RobotType(4);
    public static final transient RobotType TEAM = new RobotType(8);
    public static final transient RobotType DROID = new RobotType(16);
    public static final transient RobotType INTERACTIVE = new RobotType(32);
    public static final transient RobotType PAINTING = new RobotType(64);
    private int code;

    public RobotType(int code) {
        this.code = code;
    }

    public RobotType(boolean isJuniorRobot, boolean isStandardRobot, boolean isInteractiveRobot, boolean isPaintRobot, boolean isAdvancedRobot, boolean isTeamRobot, boolean isDroid) {
        this.code = 0;
        if (isJuniorRobot) {
            this.code += JUNIOR.getCode();
        }
        if (isStandardRobot) {
            this.code += STANDARD.getCode();
        }
        if (isInteractiveRobot) {
            this.code += INTERACTIVE.getCode();
        }
        if (isPaintRobot) {
            this.code += PAINTING.getCode();
        }
        if (isAdvancedRobot) {
            this.code += ADVANCED.getCode();
        }
        if (isTeamRobot) {
            this.code += TEAM.getCode();
        }
        if (isDroid) {
            this.code += DROID.getCode();
        }
    }

    public int getCode() {
        return this.code;
    }

    public boolean isValid() {
        return this.isJuniorRobot() || this.isStandardRobot() || this.isAdvancedRobot();
    }

    public boolean isDroid() {
        return (this.code & RobotType.DROID.code) != 0;
    }

    public boolean isTeamRobot() {
        return (this.code & RobotType.TEAM.code) != 0;
    }

    public boolean isAdvancedRobot() {
        return (this.code & RobotType.ADVANCED.code) != 0;
    }

    public boolean isStandardRobot() {
        return (this.code & RobotType.STANDARD.code) != 0;
    }

    public boolean isInteractiveRobot() {
        return (this.code & RobotType.INTERACTIVE.code) != 0;
    }

    public boolean isPaintRobot() {
        return (this.code & RobotType.PAINTING.code) != 0;
    }

    public boolean isJuniorRobot() {
        return (this.code & RobotType.JUNIOR.code) != 0;
    }

    public boolean equals(Object obj) {
        return obj instanceof RobotType && ((RobotType)obj).code == this.code;
    }
}

