/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.host;

import java.util.List;
import net.sf.robocode.peer.IRobotStatics;
import net.sf.robocode.repository.IRobotRepositoryItem;
import net.sf.robocode.security.HiddenAccess;
import robocode.BattleRules;
import robocode.control.RobotSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RobotStatics
implements IRobotStatics {
    private final boolean isJuniorRobot;
    private final boolean isInteractiveRobot;
    private final boolean isPaintRobot;
    private final boolean isAdvancedRobot;
    private final boolean isTeamRobot;
    private final boolean isTeamLeader;
    private final boolean isDroid;
    private final String name;
    private final String shortName;
    private final String veryShortName;
    private final String fullClassName;
    private final String shortClassName;
    private final BattleRules battleRules;
    private final String[] teammates;
    private final String teamName;
    private final int index;
    private final int contestantIndex;

    public RobotStatics(RobotSpecification robotSpecification, int duplicate, boolean isLeader, BattleRules rules, String teamName, List<String> teamMembers, int index, int contestantIndex) {
        IRobotRepositoryItem specification = (IRobotRepositoryItem)HiddenAccess.getFileSpecification((RobotSpecification)robotSpecification);
        this.shortClassName = specification.getShortClassName();
        this.fullClassName = specification.getFullClassName();
        if (duplicate >= 0) {
            String countString = " (" + (duplicate + 1) + ')';
            this.name = specification.getFullClassNameWithVersion() + countString;
            this.shortName = specification.getUniqueShortClassNameWithVersion() + countString;
            this.veryShortName = specification.getUniqueVeryShortClassNameWithVersion() + countString;
        } else {
            this.name = specification.getFullClassNameWithVersion();
            this.shortName = specification.getUniqueShortClassNameWithVersion();
            this.veryShortName = specification.getUniqueVeryShortClassNameWithVersion();
        }
        this.isJuniorRobot = specification.isJuniorRobot();
        this.isInteractiveRobot = specification.isInteractiveRobot();
        this.isPaintRobot = specification.isPaintRobot();
        this.isAdvancedRobot = specification.isAdvancedRobot();
        this.isTeamRobot = specification.isTeamRobot();
        this.isDroid = specification.isDroid();
        this.isTeamLeader = isLeader;
        this.battleRules = rules;
        this.index = index;
        this.contestantIndex = contestantIndex;
        if (teamMembers != null) {
            this.teammates = new String[teamMembers.size() - 1];
            int i = 0;
            for (String mate : teamMembers) {
                if (this.name.equals(mate)) continue;
                this.teammates[i++] = mate;
            }
            this.teamName = teamName;
        } else {
            this.teammates = null;
            this.teamName = this.name;
        }
    }

    public boolean isJuniorRobot() {
        return this.isJuniorRobot;
    }

    public boolean isInteractiveRobot() {
        return this.isInteractiveRobot;
    }

    public boolean isPaintRobot() {
        return this.isPaintRobot;
    }

    public boolean isAdvancedRobot() {
        return this.isAdvancedRobot;
    }

    public boolean isTeamRobot() {
        return this.isTeamRobot;
    }

    public boolean isTeamLeader() {
        return this.isTeamLeader;
    }

    public boolean isDroid() {
        return this.isDroid;
    }

    public String getName() {
        return this.name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getVeryShortName() {
        return this.veryShortName;
    }

    public String getFullClassName() {
        return this.fullClassName;
    }

    public String getShortClassName() {
        return this.shortClassName;
    }

    public BattleRules getBattleRules() {
        return this.battleRules;
    }

    public String[] getTeammates() {
        return this.teammates == null ? null : (String[])this.teammates.clone();
    }

    public String getTeamName() {
        return this.teamName;
    }

    public int getIndex() {
        return this.index;
    }

    public int getContestIndex() {
        return this.contestantIndex;
    }
}

