/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.core;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Set;
import net.sf.robocode.core.Container;
import net.sf.robocode.core.RobocodeMainBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EngineClassLoader
extends URLClassLoader {
    private static final boolean isSecutityOn = !System.getProperty("NOSECURITY", "false").equals("true");
    private static Set<String> exclusions = new HashSet<String>();

    public EngineClassLoader(ClassLoader parent) {
        super(Container.findJars(File.separator + "robocode."), parent);
    }

    public EngineClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    @Override
    public synchronized void addURL(URL url) {
        super.addURL(url);
    }

    @Override
    public synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (name.startsWith("java.lang")) {
            return super.loadClass(name, resolve);
        }
        if (isSecutityOn && this.isEngineClass(name)) {
            return this.loadEngineClass(name, resolve);
        }
        return super.loadClass(name, resolve);
    }

    private Class<?> loadEngineClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> result = this.findLoadedClass(name);
        if (result == null) {
            result = this.findClass(name);
        }
        if (resolve) {
            this.resolveClass(result);
        }
        return result;
    }

    private boolean isEngineClass(String name) {
        if (name.startsWith("net.sf.robocode") || name.startsWith("robocode.control")) {
            if (exclusions.contains(name)) {
                return false;
            }
            final String path = name.replace('.', '/').concat(".class");
            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return EngineClassLoader.this.findResource(path) != null;
                }
            });
        }
        return false;
    }

    static {
        exclusions.add(EngineClassLoader.class.getName());
        exclusions.add(Container.class.getName());
        exclusions.add(RobocodeMainBase.class.getName());
    }
}

