/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.robotpaint;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.nio.ByteBuffer;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import net.sf.robocode.robotpaint.IGraphicsProxy;
import net.sf.robocode.serialization.RbSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Graphics2DSerialized
extends Graphics2D
implements IGraphicsProxy {
    final Method[] methods = (Method[])Method.class.getEnumConstants();
    private transient AffineTransform transform;
    private transient Composite composite;
    private transient Paint paint;
    private transient Stroke stroke;
    private transient RenderingHints renderingHints;
    private transient Color background;
    private transient Shape clip;
    private transient Color color;
    private transient Font font;
    private transient boolean isInitialized;
    private transient boolean isPaintingEnabled;
    private ByteBuffer calls;
    private final RbSerializer serializer = new RbSerializer();
    private int lastPos;

    @Override
    public Graphics create() {
        Graphics2DSerialized gfxProxyCopy = new Graphics2DSerialized();
        gfxProxyCopy.calls = ByteBuffer.allocate(2048);
        this.calls.put(this.calls);
        gfxProxyCopy.transform = this.transform;
        gfxProxyCopy.composite = this.copyOf(this.composite);
        gfxProxyCopy.paint = this.paint;
        gfxProxyCopy.stroke = this.copyOf(this.stroke);
        gfxProxyCopy.renderingHints = this.renderingHints;
        gfxProxyCopy.background = Graphics2DSerialized.copyOf(this.background);
        gfxProxyCopy.clip = this.copyOf(this.clip);
        gfxProxyCopy.color = Graphics2DSerialized.copyOf(this.color);
        gfxProxyCopy.font = this.font;
        gfxProxyCopy.isInitialized = this.isInitialized;
        return gfxProxyCopy;
    }

    @Override
    public Graphics create(int x, int y, int width, int height) {
        Graphics g = this.create();
        g.translate(x, y);
        g.setClip(0, 0, width, height);
        return g;
    }

    @Override
    public void translate(int x, int y) {
        this.transform.translate(x, y);
        if (this.isPaintingEnabled) {
            this.put(Method.TRANSLATE_INT);
            this.put(x);
            this.put(y);
        }
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color c) {
        this.color = c;
        if (this.isPaintingEnabled) {
            this.put(Method.SET_COLOR);
            this.put(c);
        }
    }

    @Override
    public void setPaintMode() {
        if (this.isPaintingEnabled) {
            this.put(Method.SET_PAINT_MODE);
        }
    }

    @Override
    public void setXORMode(Color c1) {
        if (this.isPaintingEnabled) {
            this.put(Method.SET_XOR_MODE);
            this.put(c1);
        }
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
        if (this.isPaintingEnabled) {
            this.put(Method.SET_FONT);
            this.put(font);
        }
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return new FontMetricsByFont(f);
    }

    @Override
    public Rectangle getClipBounds() {
        return this.clip.getBounds();
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        Area clipArea = new Area(this.clip);
        Area clipRectArea = new Area(new Rectangle(x, y, width, height));
        clipArea.intersect(clipRectArea);
        this.clip = clipArea;
        if (this.isPaintingEnabled) {
            this.put(Method.CLIP_RECT);
            this.put(x);
            this.put(y);
            this.put(width);
            this.put(height);
        }
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.clip = new Rectangle(x, y, width, height);
        if (this.isPaintingEnabled) {
            this.put(Method.SET_CLIP);
            this.put(x);
            this.put(y);
            this.put(width);
            this.put(height);
        }
    }

    @Override
    public Shape getClip() {
        return this.clip;
    }

    @Override
    public void setClip(Shape clip) {
        this.clip = clip;
        if (this.isPaintingEnabled) {
            this.put(Method.SET_CLIP_SHAPE);
            this.put(clip);
        }
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        if (this.isPaintingEnabled) {
            this.put(Method.COPY_AREA);
            this.put(x);
            this.put(y);
            this.put(width);
            this.put(height);
            this.put(dx);
            this.put(dy);
        }
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        if (this.isPaintingEnabled) {
            this.put(Method.DRAW_LINE);
            this.put(x1);
            this.put(y1);
            this.put(x2);
            this.put(y2);
        }
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        if (this.isPaintingEnabled) {
            this.put(Method.FILL_RECT);
            this.put(x);
            this.put(y);
            this.put(width);
            this.put(height);
        }
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        if (this.isPaintingEnabled) {
            this.put(Method.DRAW_RECT);
            this.put(x);
            this.put(y);
            this.put(width);
            this.put(height);
        }
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        if (this.isPaintingEnabled) {
            this.put(Method.CLEAR_RECT);
            this.put(x);
            this.put(y);
            this.put(width);
            this.put(height);
        }
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.isPaintingEnabled) {
            this.put(Method.DRAW_ROUND_RECT);
            this.put(x);
            this.put(y);
            this.put(width);
            this.put(height);
            this.put(arcWidth);
            this.put(arcHeight);
        }
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.isPaintingEnabled) {
            this.put(Method.FILL_ROUND_RECT);
            this.put(x);
            this.put(y);
            this.put(width);
            this.put(height);
            this.put(arcWidth);
            this.put(arcHeight);
        }
    }

    @Override
    public void draw3DRect(int x, int y, int width, int height, boolean raised) {
        if (this.isPaintingEnabled) {
            this.put(Method.DRAW_3D_RECT);
            this.put(x);
            this.put(y);
            this.put(width);
            this.put(height);
            this.put(raised);
        }
    }

    @Override
    public void fill3DRect(int x, int y, int width, int height, boolean raised) {
        if (this.isPaintingEnabled) {
            this.put(Method.FILL_3D_RECT);
            this.put(x);
            this.put(y);
            this.put(width);
            this.put(height);
            this.put(raised);
        }
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        if (this.isPaintingEnabled) {
            this.put(Method.DRAW_OVAL);
            this.put(x);
            this.put(y);
            this.put(width);
            this.put(height);
        }
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        if (this.isPaintingEnabled) {
            this.put(Method.FILL_OVAL);
            this.put(x);
            this.put(y);
            this.put(width);
            this.put(height);
        }
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.isPaintingEnabled) {
            this.put(Method.DRAW_ARC);
            this.put(x);
            this.put(y);
            this.put(width);
            this.put(height);
            this.put(startAngle);
            this.put(arcAngle);
        }
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.isPaintingEnabled) {
            this.put(Method.FILL_ARC);
            this.put(x);
            this.put(y);
            this.put(width);
            this.put(height);
            this.put(startAngle);
            this.put(arcAngle);
        }
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int npoints) {
        if (this.isPaintingEnabled) {
            this.put(Method.DRAW_POLYLINE);
            this.put(xPoints);
            this.put(yPoints);
            this.put(npoints);
        }
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int npoints) {
        if (this.isPaintingEnabled) {
            this.put(Method.DRAW_POLYGON);
            this.put(xPoints);
            this.put(yPoints);
            this.put(npoints);
        }
    }

    @Override
    public void drawPolygon(Polygon p) {
        if (this.isPaintingEnabled) {
            this.drawPolygon(p.xpoints, p.ypoints, p.npoints);
        }
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int npoints) {
        if (this.isPaintingEnabled) {
            this.put(Method.FILL_POLYGON);
            this.put(xPoints);
            this.put(yPoints);
            this.put(npoints);
        }
    }

    @Override
    public void fillPolygon(Polygon p) {
        if (this.isPaintingEnabled) {
            this.fillPolygon(p.xpoints, p.ypoints, p.npoints);
        }
    }

    @Override
    public void drawString(String str, int x, int y) {
        if (str == null) {
            throw new NullPointerException("str is null");
        }
        if (this.isPaintingEnabled) {
            this.put(Method.DRAW_STRING_INT);
            this.put(str);
            this.put(x);
            this.put(y);
        }
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        if (this.isPaintingEnabled) {
            this.put(Method.DRAW_STRING_ACI_INT);
            this.put(iterator);
            this.put(x);
            this.put(y);
        }
    }

    @Override
    public void drawChars(char[] data, int offset, int length, int x, int y) {
        if (this.isPaintingEnabled) {
            this.put(Method.DRAW_CHARS);
            this.put(data);
            this.put(offset);
            this.put(length);
            this.put(x);
            this.put(y);
        }
    }

    @Override
    public void drawBytes(byte[] data, int offset, int length, int x, int y) {
        if (this.isPaintingEnabled) {
            this.put(Method.DRAW_BYTES);
            this.put(data);
            this.put(offset);
            this.put(length);
            this.put(x);
            this.put(y);
        }
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        if (this.isPaintingEnabled) {
            this.notSupported();
        }
        return false;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        if (this.isPaintingEnabled) {
            this.notSupported();
        }
        return false;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        if (this.isPaintingEnabled) {
            this.notSupported();
        }
        return false;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        if (this.isPaintingEnabled) {
            this.notSupported();
        }
        return false;
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        if (this.isPaintingEnabled) {
            this.notSupported();
        }
        return false;
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        if (this.isPaintingEnabled) {
            this.notSupported();
        }
        return false;
    }

    @Override
    public void dispose() {
    }

    @Override
    @Deprecated
    public Rectangle getClipRect() {
        return this.getClipBounds();
    }

    @Override
    public boolean hitClip(int x, int y, int width, int height) {
        return this.clip != null && this.clip.intersects(x, y, width, height);
    }

    @Override
    public Rectangle getClipBounds(Rectangle r) {
        Rectangle bounds = this.clip.getBounds();
        r.setBounds(bounds);
        return bounds;
    }

    @Override
    public void draw(Shape s) {
        if (this.isPaintingEnabled) {
            this.put(Method.DRAW_SHAPE);
            this.put(s);
        }
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        if (this.isPaintingEnabled) {
            this.notSupported();
        }
        return false;
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        if (this.isPaintingEnabled) {
            this.notSupported();
        }
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        if (this.isPaintingEnabled) {
            this.notSupported();
        }
    }

    @Override
    public void drawString(String str, float x, float y) {
        if (str == null) {
            throw new NullPointerException("str is null");
        }
        if (this.isPaintingEnabled) {
            this.put(Method.DRAW_STRING_FLOAT);
            this.put(str);
            this.put(x);
            this.put(y);
        }
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        if (this.isPaintingEnabled) {
            this.put(Method.DRAW_STRING_ACI_FLOAT);
            this.put(iterator);
            this.put(x);
            this.put(y);
        }
    }

    @Override
    public void drawGlyphVector(GlyphVector gv, float x, float y) {
        if (this.isPaintingEnabled) {
            this.notSupported();
        }
    }

    @Override
    public void fill(Shape s) {
        if (this.isPaintingEnabled) {
            this.put(Method.FILL_SHAPE);
            this.put(s);
        }
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        if (onStroke && this.getStroke() != null) {
            s = this.getStroke().createStrokedShape(s);
        }
        if (this.getTransform() != null) {
            s = this.getTransform().createTransformedShape(s);
        }
        Area area = new Area(s);
        if (this.getClip() != null) {
            area.intersect(new Area(this.getClip()));
        }
        return area.intersects(rect);
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    @Override
    public void setComposite(Composite comp) {
        this.composite = comp;
        if (this.isPaintingEnabled) {
            this.put(Method.SET_COMPOSITE);
            this.put(comp);
        }
    }

    @Override
    public void setPaint(Paint paint) {
        this.paint = paint;
        if (this.isPaintingEnabled) {
            this.put(Method.SET_PAINT);
            this.put(paint);
        }
    }

    @Override
    public void setStroke(Stroke s) {
        this.stroke = s;
        if (this.isPaintingEnabled) {
            this.put(Method.SET_STROKE);
            this.put(s);
        }
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.renderingHints.put(hintKey, hintValue);
        if (this.isPaintingEnabled) {
            this.notSupportedWarn();
        }
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.renderingHints.get(hintKey);
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
        this.renderingHints.clear();
        this.renderingHints.putAll(hints);
        if (this.isPaintingEnabled) {
            this.notSupportedWarn();
        }
    }

    @Override
    public void addRenderingHints(Map<?, ?> hints) {
        this.renderingHints.putAll(hints);
        if (this.isPaintingEnabled) {
            this.notSupportedWarn();
        }
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.renderingHints;
    }

    @Override
    public void translate(double tx, double ty) {
        this.transform.translate(tx, ty);
        if (this.isPaintingEnabled) {
            this.put(Method.TRANSLATE_DOUBLE);
            this.put(tx);
            this.put(ty);
        }
    }

    @Override
    public void rotate(double theta) {
        this.transform.rotate(theta);
        if (this.isPaintingEnabled) {
            this.put(Method.ROTATE);
            this.put(theta);
        }
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.transform.rotate(theta, x, y);
        if (this.isPaintingEnabled) {
            this.put(Method.ROTATE_XY);
            this.put(theta);
            this.put(x);
            this.put(y);
        }
    }

    @Override
    public void scale(double sx, double sy) {
        this.transform.scale(sx, sy);
        if (this.isPaintingEnabled) {
            this.put(Method.SCALE);
            this.put(sx);
            this.put(sy);
        }
    }

    @Override
    public void shear(double shx, double shy) {
        this.transform.shear(shx, shy);
        if (this.isPaintingEnabled) {
            this.put(Method.SHEAR);
            this.put(shx);
            this.put(shy);
        }
    }

    @Override
    public void transform(AffineTransform Tx) {
        this.transform.concatenate(Tx);
        if (this.isPaintingEnabled) {
            this.put(Method.TRANSFORM);
            this.put(Tx);
        }
    }

    @Override
    public void setTransform(AffineTransform Tx) {
        this.transform = Tx;
        if (this.isPaintingEnabled) {
            this.put(Method.SET_TRANSFORM);
            this.put(Tx);
        }
    }

    @Override
    public AffineTransform getTransform() {
        return (AffineTransform)this.transform.clone();
    }

    @Override
    public Paint getPaint() {
        return this.paint;
    }

    @Override
    public Composite getComposite() {
        return this.composite;
    }

    @Override
    public void setBackground(Color color) {
        this.background = color;
        if (this.isPaintingEnabled) {
            this.put(Method.SET_BACKGROUND);
            this.put(color);
        }
    }

    @Override
    public Color getBackground() {
        return this.background;
    }

    @Override
    public Stroke getStroke() {
        return this.stroke;
    }

    @Override
    public void clip(Shape s) {
        if (s == null) {
            this.clip = null;
        } else {
            Area shapeArea = new Area(s);
            Area clipArea = new Area(this.clip);
            shapeArea.transform(this.transform);
            clipArea.intersect(shapeArea);
            this.clip = clipArea;
        }
        if (this.isPaintingEnabled) {
            this.put(Method.CLIP);
            this.put(s);
        }
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        RenderingHints hints = this.getRenderingHints();
        boolean isAntiAliased = hints.get(RenderingHints.KEY_TEXT_ANTIALIASING).equals(RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        boolean usesFractionalMetrics = hints.get(RenderingHints.KEY_FRACTIONALMETRICS).equals(RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        return new FontRenderContext(null, isAntiAliased, usesFractionalMetrics);
    }

    @Override
    public void setPaintingEnabled(boolean value) {
        if (value && !this.isPaintingEnabled) {
            this.calls = ByteBuffer.allocate(24576);
        }
        this.isPaintingEnabled = value;
    }

    @Override
    public void processTo(Graphics2D g) {
        if (!this.isInitialized) {
            this.transform = g.getTransform();
            this.transform = this.transform == null ? new AffineTransform() : new AffineTransform(this.transform);
            this.color = Graphics2DSerialized.copyOf(g.getColor());
            this.font = g.getFont();
            this.clip = this.copyOf(g.getClip());
            this.composite = this.copyOf(g.getComposite());
            this.paint = g.getPaint();
            this.stroke = this.copyOf(g.getStroke());
            this.renderingHints = (RenderingHints)g.getRenderingHints().clone();
            this.background = Graphics2DSerialized.copyOf(g.getBackground());
            this.isInitialized = true;
        }
        this.calls.flip();
        while (this.calls.remaining() > 0) {
            this.processQueuedCall(g);
        }
    }

    public void clearQueue() {
        this.calls.clear();
    }

    @Override
    public void processTo(Graphics2D g, Object graphicsCalls) {
        this.calls.clear();
        this.calls.put((byte[])graphicsCalls);
        this.calls.flip();
        while (this.calls.remaining() > 0) {
            try {
                this.processQueuedCall(g);
            }
            catch (Throwable t) {
                this.calls.position(this.lastPos - 4);
            }
        }
    }

    @Override
    public Object readoutQueuedCalls() {
        if (this.calls == null || this.calls.position() == 0) {
            return null;
        }
        byte[] res = new byte[this.calls.position()];
        this.calls.flip();
        this.calls.get(res);
        this.calls.clear();
        return res;
    }

    private void processQueuedCall(Graphics2D g) {
        Method m = this.readMethod();
        switch (m) {
            case TRANSLATE_INT: {
                this.processTranslate_int(g);
                break;
            }
            case SET_COLOR: {
                this.processSetColor(g);
                break;
            }
            case SET_PAINT_MODE: {
                this.processSetPaintMode(g);
                break;
            }
            case SET_XOR_MODE: {
                this.processSetXORMode(g);
                break;
            }
            case SET_FONT: {
                this.processSetFont(g);
                break;
            }
            case CLIP_RECT: {
                this.processClipRect(g);
                break;
            }
            case SET_CLIP: {
                this.processSetClip(g);
                break;
            }
            case SET_CLIP_SHAPE: {
                this.processSetClip_Shape(g);
                break;
            }
            case COPY_AREA: {
                this.processCopyArea(g);
                break;
            }
            case DRAW_LINE: {
                this.processDrawLine(g);
                break;
            }
            case FILL_RECT: {
                this.processFillRect(g);
                break;
            }
            case DRAW_RECT: {
                this.processDrawRect(g);
                break;
            }
            case CLEAR_RECT: {
                this.processClearRect(g);
                break;
            }
            case DRAW_ROUND_RECT: {
                this.processDrawRoundRect(g);
                break;
            }
            case FILL_ROUND_RECT: {
                this.processFillRoundRect(g);
                break;
            }
            case DRAW_3D_RECT: {
                this.processDraw3DRect(g);
                break;
            }
            case FILL_3D_RECT: {
                this.processFill3DRect(g);
                break;
            }
            case DRAW_OVAL: {
                this.processDrawOval(g);
                break;
            }
            case FILL_OVAL: {
                this.processFillOval(g);
                break;
            }
            case DRAW_ARC: {
                this.processDrawArc(g);
                break;
            }
            case FILL_ARC: {
                this.processFillArc(g);
                break;
            }
            case DRAW_POLYLINE: {
                this.processDrawPolyline(g);
                break;
            }
            case DRAW_POLYGON: {
                this.processDrawPolygon(g);
                break;
            }
            case FILL_POLYGON: {
                this.processFillPolygon(g);
                break;
            }
            case DRAW_STRING_INT: {
                this.processDrawString_int(g);
                break;
            }
            case DRAW_STRING_ACI_INT: {
                this.processDrawString_ACIterator_int(g);
                break;
            }
            case DRAW_CHARS: {
                this.processDrawChars(g);
                break;
            }
            case DRAW_BYTES: {
                this.processDrawBytes(g);
                break;
            }
            case DRAW_SHAPE: {
                this.processDrawShape(g);
                break;
            }
            case DRAW_STRING_FLOAT: {
                this.processDrawString_float(g);
                break;
            }
            case DRAW_STRING_ACI_FLOAT: {
                this.processDrawString_ACIterator_float(g);
                break;
            }
            case FILL_SHAPE: {
                this.processFillShape(g);
                break;
            }
            case SET_COMPOSITE: {
                this.processSetComposite(g);
                break;
            }
            case SET_PAINT: {
                this.processSetPaint(g);
                break;
            }
            case SET_STROKE: {
                this.processSetStroke(g);
                break;
            }
            case TRANSLATE_DOUBLE: {
                this.processTranslate_double(g);
                break;
            }
            case ROTATE: {
                this.processRotate(g);
                break;
            }
            case ROTATE_XY: {
                this.processRotate_xy(g);
                break;
            }
            case SCALE: {
                this.processScale(g);
                break;
            }
            case SHEAR: {
                this.processShear(g);
                break;
            }
            case TRANSFORM: {
                this.processTransform(g);
                break;
            }
            case SET_TRANSFORM: {
                this.processSetTransform(g);
                break;
            }
            case SET_BACKGROUND: {
                this.processSetBackground(g);
                break;
            }
            case CLIP: {
                this.processClip(g);
                break;
            }
            default: {
                this.notSupported();
            }
        }
    }

    private void processTranslate_int(Graphics2D g) {
        g.translate(this.calls.getInt(), this.calls.getInt());
    }

    private void processSetColor(Graphics2D g) {
        g.setColor(new Color(this.calls.getInt(), true));
    }

    private void processSetPaintMode(Graphics2D g) {
        g.setPaintMode();
    }

    private void processSetXORMode(Graphics2D g) {
        g.setXORMode(new Color(this.calls.getInt(), true));
    }

    private void processSetFont(Graphics2D g) {
        g.setFont(Font.getFont(this.serializer.deserializeString(this.calls)));
    }

    private void processClipRect(Graphics2D g) {
        g.clipRect(this.calls.getInt(), this.calls.getInt(), this.calls.getInt(), this.calls.getInt());
    }

    private void processSetClip(Graphics2D g) {
        g.setClip(this.calls.getInt(), this.calls.getInt(), this.calls.getInt(), this.calls.getInt());
    }

    private void processSetClip_Shape(Graphics2D g) {
        g.setClip(this.readShape());
    }

    private void processCopyArea(Graphics2D g) {
        g.copyArea(this.calls.getInt(), this.calls.getInt(), this.calls.getInt(), this.calls.getInt(), this.calls.getInt(), this.calls.getInt());
    }

    private void processDrawLine(Graphics2D g) {
        g.drawLine(this.calls.getInt(), this.calls.getInt(), this.calls.getInt(), this.calls.getInt());
    }

    private void processFillRect(Graphics2D g) {
        g.fillRect(this.calls.getInt(), this.calls.getInt(), this.calls.getInt(), this.calls.getInt());
    }

    private void processDrawRect(Graphics2D g) {
        g.drawRect(this.calls.getInt(), this.calls.getInt(), this.calls.getInt(), this.calls.getInt());
    }

    private void processClearRect(Graphics2D g) {
        g.clearRect(this.calls.getInt(), this.calls.getInt(), this.calls.getInt(), this.calls.getInt());
    }

    private void processDrawRoundRect(Graphics2D g) {
        g.drawRoundRect(this.calls.getInt(), this.calls.getInt(), this.calls.getInt(), this.calls.getInt(), this.calls.getInt(), this.calls.getInt());
    }

    private void processFillRoundRect(Graphics2D g) {
        g.fillRoundRect(this.calls.getInt(), this.calls.getInt(), this.calls.getInt(), this.calls.getInt(), this.calls.getInt(), this.calls.getInt());
    }

    private void processDraw3DRect(Graphics2D g) {
        g.draw3DRect(this.calls.getInt(), this.calls.getInt(), this.calls.getInt(), this.calls.getInt(), this.serializer.deserializeBoolean(this.calls));
    }

    private void processFill3DRect(Graphics2D g) {
        g.fill3DRect(this.calls.getInt(), this.calls.getInt(), this.calls.getInt(), this.calls.getInt(), this.serializer.deserializeBoolean(this.calls));
    }

    private void processDrawOval(Graphics2D g) {
        g.drawOval(this.calls.getInt(), this.calls.getInt(), this.calls.getInt(), this.calls.getInt());
    }

    private void processFillOval(Graphics2D g) {
        g.fillOval(this.calls.getInt(), this.calls.getInt(), this.calls.getInt(), this.calls.getInt());
    }

    private void processDrawArc(Graphics2D g) {
        g.drawArc(this.calls.getInt(), this.calls.getInt(), this.calls.getInt(), this.calls.getInt(), this.calls.getInt(), this.calls.getInt());
    }

    private void processFillArc(Graphics2D g) {
        g.fillArc(this.calls.getInt(), this.calls.getInt(), this.calls.getInt(), this.calls.getInt(), this.calls.getInt(), this.calls.getInt());
    }

    private void processDrawPolyline(Graphics2D g) {
        g.drawPolyline(this.serializer.deserializeIntegers(this.calls), this.serializer.deserializeIntegers(this.calls), this.calls.getInt());
    }

    private void processDrawPolygon(Graphics2D g) {
        g.drawPolygon(this.serializer.deserializeIntegers(this.calls), this.serializer.deserializeIntegers(this.calls), this.calls.getInt());
    }

    private void processFillPolygon(Graphics2D g) {
        g.fillPolygon(this.serializer.deserializeIntegers(this.calls), this.serializer.deserializeIntegers(this.calls), this.calls.getInt());
    }

    private void processDrawString_int(Graphics2D g) {
        g.drawString(this.serializer.deserializeString(this.calls), this.calls.getInt(), this.calls.getInt());
    }

    private void processDrawString_ACIterator_int(Graphics2D g) {
        g.drawString(this.serializer.deserializeString(this.calls), this.calls.getInt(), this.calls.getInt());
    }

    private void processDrawChars(Graphics2D g) {
        g.drawChars(this.serializer.deserializeChars(this.calls), this.calls.getInt(), this.calls.getInt(), this.calls.getInt(), this.calls.getInt());
    }

    private void processDrawBytes(Graphics2D g) {
        g.drawBytes(this.serializer.deserializeBytes(this.calls), this.calls.getInt(), this.calls.getInt(), this.calls.getInt(), this.calls.getInt());
    }

    private void processDrawShape(Graphics2D g) {
        g.draw(this.readShape());
    }

    private void processDrawString_float(Graphics2D g) {
        g.drawString(this.serializer.deserializeString(this.calls), this.calls.getFloat(), this.calls.getFloat());
    }

    private void processDrawString_ACIterator_float(Graphics2D g) {
        g.drawString(this.serializer.deserializeString(this.calls), this.calls.getFloat(), this.calls.getFloat());
    }

    private void processFillShape(Graphics2D g) {
        g.fill(this.readShape());
    }

    private void processSetComposite(Graphics2D g) {
        g.setComposite(this.readComposite());
    }

    private void processSetPaint(Graphics2D g) {
        g.setPaint(this.readPaint());
    }

    private void processSetStroke(Graphics2D g) {
        g.setStroke(this.readStroke());
    }

    private void processTranslate_double(Graphics2D g) {
        g.translate(this.calls.getDouble(), this.calls.getDouble());
    }

    private void processRotate(Graphics2D g) {
        g.rotate(this.calls.getDouble());
    }

    private void processRotate_xy(Graphics2D g) {
        g.rotate(this.calls.getDouble(), this.calls.getDouble(), this.calls.getDouble());
    }

    private void processScale(Graphics2D g) {
        g.scale(this.calls.getDouble(), this.calls.getDouble());
    }

    private void processShear(Graphics2D g) {
        g.shear(this.calls.getDouble(), this.calls.getDouble());
    }

    private void processTransform(Graphics2D g) {
        AffineTransform transform = this.getAffineTransform();
        g.transform(transform);
    }

    private void processSetTransform(Graphics2D g) {
        g.setTransform(this.getAffineTransform());
    }

    private void processSetBackground(Graphics2D g) {
        g.setBackground(new Color(this.calls.getInt(), true));
    }

    private void processClip(Graphics2D g) {
        g.clip(this.readShape());
    }

    private Shape readShape() {
        switch (this.calls.get()) {
            case 1: {
                return new Arc2D.Double(this.calls.getDouble(), this.calls.getDouble(), this.calls.getDouble(), this.calls.getDouble(), this.calls.getDouble(), this.calls.getDouble(), this.calls.getInt());
            }
            case 2: {
                return new Line2D.Double(this.calls.getDouble(), this.calls.getDouble(), this.calls.getDouble(), this.calls.getDouble());
            }
            case 3: {
                return new Rectangle2D.Double(this.calls.getDouble(), this.calls.getDouble(), this.calls.getDouble(), this.calls.getDouble());
            }
            case 4: {
                return new Ellipse2D.Double(this.calls.getDouble(), this.calls.getDouble(), this.calls.getDouble(), this.calls.getDouble());
            }
            case 0: {
                DeserializePathIterator pai = new DeserializePathIterator();
                GeneralPath path = new GeneralPath();
                path.append(pai, false);
                return path;
            }
        }
        this.notSupported();
        return null;
    }

    private void put(Shape clip) {
        if (clip instanceof Arc2D) {
            Arc2D arc = (Arc2D)clip;
            Rectangle bounds = arc.getBounds();
            this.put((byte)1);
            this.put(bounds.getMinX());
            this.put(bounds.getMinY());
            this.put(bounds.getWidth());
            this.put(bounds.getHeight());
            this.put(arc.getAngleStart());
            this.put(arc.getAngleExtent());
            this.put(arc.getArcType());
        } else if (clip instanceof Line2D) {
            this.put((byte)2);
            Line2D line = (Line2D)clip;
            this.put(line.getX1());
            this.put(line.getY1());
            this.put(line.getX2());
            this.put(line.getY2());
        } else if (clip instanceof Rectangle2D) {
            this.put((byte)3);
            Rectangle2D rect = (Rectangle2D)clip;
            this.put(rect.getMinX());
            this.put(rect.getMinY());
            this.put(rect.getHeight());
            this.put(rect.getWidth());
        } else if (clip instanceof Ellipse2D) {
            this.put((byte)4);
            Ellipse2D elipse = (Ellipse2D)clip;
            this.put(elipse.getMinX());
            this.put(elipse.getMinY());
            this.put(elipse.getHeight());
            this.put(elipse.getWidth());
        } else {
            this.put((byte)0);
            double[] coords = new double[6];
            int count = 0;
            PathIterator pi = clip.getPathIterator(null);
            while (!pi.isDone()) {
                ++count;
                pi.next();
            }
            this.put(count);
            pi = clip.getPathIterator(null);
            this.put(pi.getWindingRule());
            while (!pi.isDone()) {
                int type = pi.currentSegment(coords);
                this.put(type);
                this.put(coords);
                pi.next();
            }
        }
    }

    private Composite readComposite() {
        switch (this.calls.get()) {
            case 1: {
                return AlphaComposite.getInstance(this.calls.getInt());
            }
        }
        this.notSupported();
        return null;
    }

    private void put(Composite comp) {
        if (comp instanceof AlphaComposite) {
            AlphaComposite composite = (AlphaComposite)comp;
            this.put((byte)1);
            this.put(composite.getRule());
        } else {
            this.notSupported();
        }
    }

    private Paint readPaint() {
        switch (this.calls.get()) {
            case 1: {
                return new Color(this.calls.getInt(), true);
            }
        }
        this.notSupported();
        return null;
    }

    private void put(Paint paint) {
        if (paint instanceof Color) {
            Color color = (Color)paint;
            this.put((byte)1);
            this.put(color.getRGB());
        } else {
            this.notSupported();
        }
    }

    private Stroke readStroke() {
        switch (this.calls.get()) {
            case 1: {
                return new BasicStroke(this.calls.getFloat(), this.calls.getInt(), this.calls.getInt(), this.calls.getFloat(), this.serializer.deserializeFloats(this.calls), this.calls.getFloat());
            }
        }
        this.notSupported();
        return null;
    }

    private void put(Stroke stroke) {
        if (stroke instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)stroke;
            this.put((byte)1);
            this.put(bs.getLineWidth());
            this.put(bs.getEndCap());
            this.put(bs.getLineJoin());
            this.put(bs.getMiterLimit());
            this.put(bs.getDashArray());
            this.put(bs.getDashPhase());
        } else {
            this.notSupported();
        }
    }

    private AffineTransform getAffineTransform() {
        return new AffineTransform(this.serializer.deserializeDoubles(this.calls));
    }

    private void put(AffineTransform tx) {
        double[] m = new double[6];
        tx.getMatrix(m);
        this.put(m);
        this.put(tx.getType());
    }

    private Method readMethod() {
        Method m = this.methods[this.calls.get()];
        return m;
    }

    private void put(Method m) {
        this.calls.put((byte)m.ordinal());
    }

    private void put(AttributedCharacterIterator iterator) {
        StringBuilder sb = new StringBuilder();
        char c = iterator.first();
        while (c != '\uffff') {
            sb.append(c);
            c = iterator.next();
        }
        this.put(sb.toString());
    }

    private void put(String value) {
        this.serializer.serialize(this.calls, value);
    }

    private void put(boolean value) {
        this.serializer.serialize(this.calls, value);
    }

    private void put(byte value) {
        this.calls.put(value);
    }

    private void put(int value) {
        this.calls.putInt(value);
    }

    private void put(int[] values) {
        this.serializer.serialize(this.calls, values);
    }

    private void put(byte[] values) {
        this.serializer.serialize(this.calls, values);
    }

    private void put(char[] values) {
        this.serializer.serialize(this.calls, values);
    }

    private void put(double[] values) {
        this.serializer.serialize(this.calls, values);
    }

    private void put(float[] values) {
        this.serializer.serialize(this.calls, values);
    }

    private void put(double value) {
        this.calls.putDouble(value);
    }

    private void put(float value) {
        this.calls.putFloat(value);
    }

    private void put(Color value) {
        this.calls.putInt(value.getRGB());
    }

    private void put(Font value) {
        this.serializer.serialize(this.calls, value.getFontName());
    }

    public static Color copyOf(Color c) {
        return c != null ? new Color(c.getRGB(), true) : null;
    }

    private Shape copyOf(Shape s) {
        return s != null ? new GeneralPath(s) : null;
    }

    private Stroke copyOf(Stroke s) {
        if (s == null) {
            return null;
        }
        if (s instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)s;
            return new BasicStroke(bs.getLineWidth(), bs.getEndCap(), bs.getLineJoin(), bs.getMiterLimit(), bs.getDashArray(), bs.getDashPhase());
        }
        throw new UnsupportedOperationException("The Stroke type '" + s.getClass().getName() + "' is not supported");
    }

    private Composite copyOf(Composite c) {
        if (c == null) {
            return null;
        }
        if (c instanceof AlphaComposite) {
            AlphaComposite ac = (AlphaComposite)c;
            return AlphaComposite.getInstance(ac.getRule(), ac.getAlpha());
        }
        throw new UnsupportedOperationException("The Composite type '" + c.getClass().getName() + "' is not supported");
    }

    private void notSupported() {
        throw new UnsupportedOperationException("We are sorry. Operation is not supported in Robocode.");
    }

    private void notSupportedWarn() {
        System.out.println("We are sorry. Operation is not supported in Robocode.");
    }

    private class FontMetricsByFont
    extends FontMetrics {
        private static final long serialVersionUID = 1L;

        FontMetricsByFont(Font font) {
            super(font);
        }
    }

    private class DeserializePathIterator
    implements PathIterator {
        final int count;
        int pos;
        final int windingRule;
        int[] type;
        double[][] coords;

        public DeserializePathIterator() {
            this.count = Graphics2DSerialized.this.calls.getInt();
            this.pos = 0;
            this.windingRule = Graphics2DSerialized.this.calls.getInt();
            if (this.count > 0) {
                this.type = new int[this.count];
                this.coords = new double[this.count][];
                for (int i = 0; i < this.count; ++i) {
                    this.type[i] = Graphics2DSerialized.this.calls.getInt();
                    this.coords[i] = Graphics2DSerialized.this.serializer.deserializeDoubles(Graphics2DSerialized.this.calls);
                }
            }
        }

        public int getWindingRule() {
            return this.windingRule;
        }

        public boolean isDone() {
            return this.pos == this.count;
        }

        public void next() {
            ++this.pos;
        }

        public int currentSegment(float[] coords) {
            for (int i = 0; i < coords.length; ++i) {
                coords[i] = (float)this.coords[this.pos][i];
            }
            return this.type[this.pos];
        }

        public int currentSegment(double[] coords) {
            System.arraycopy(this.coords[this.pos], 0, coords, 0, coords.length);
            return this.type[this.pos];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Method {
        TRANSLATE_INT,
        SET_COLOR,
        SET_PAINT_MODE,
        SET_XOR_MODE,
        SET_FONT,
        CLIP_RECT,
        SET_CLIP,
        SET_CLIP_SHAPE,
        COPY_AREA,
        DRAW_LINE,
        FILL_RECT,
        DRAW_RECT,
        CLEAR_RECT,
        DRAW_ROUND_RECT,
        FILL_ROUND_RECT,
        DRAW_3D_RECT,
        FILL_3D_RECT,
        DRAW_OVAL,
        FILL_OVAL,
        DRAW_ARC,
        FILL_ARC,
        DRAW_POLYLINE,
        DRAW_POLYGON,
        FILL_POLYGON,
        DRAW_STRING_INT,
        DRAW_STRING_ACI_INT,
        DRAW_CHARS,
        DRAW_BYTES,
        DRAW_IMAGE_1,
        DRAW_IMAGE_2,
        DRAW_IMAGE_3,
        DRAW_IMAGE_4,
        DRAW_IMAGE_5,
        DRAW_IMAGE_6,
        DRAW_SHAPE,
        DRAW_IMAGE_7,
        DRAW_IMAGE_8,
        DRAW_RENDERED_IMAGE,
        DRAW_RENDERABLE_IMGAGE,
        DRAW_STRING_FLOAT,
        DRAW_STRING_ACI_FLOAT,
        DRAW_GLYPH_VECTOR,
        FILL_SHAPE,
        SET_COMPOSITE,
        SET_PAINT,
        SET_STROKE,
        SET_RENDERING_HINT,
        SET_RENDERING_HINTS,
        ADD_RENDERING_HINTS,
        TRANSLATE_DOUBLE,
        ROTATE,
        ROTATE_XY,
        SCALE,
        SHEAR,
        TRANSFORM,
        SET_TRANSFORM,
        SET_BACKGROUND,
        CLIP;

    }
}

