/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.peer;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import net.sf.robocode.peer.BulletCommand;
import net.sf.robocode.peer.DebugProperty;
import net.sf.robocode.peer.TeamMessage;
import net.sf.robocode.serialization.ISerializableHelper;
import net.sf.robocode.serialization.RbSerializer;
import robocode.Rules;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExecCommands
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int defaultBodyColor = -14079604;
    public static final int defaultGunColor = -14079604;
    public static final int defaultRadarColor = -14079604;
    public static final int defaultScanColor = -16776961;
    public static final int defaultBulletColor = -1;
    private double bodyTurnRemaining;
    private double radarTurnRemaining;
    private double gunTurnRemaining;
    private double distanceRemaining;
    private boolean isAdjustGunForBodyTurn;
    private boolean isAdjustRadarForGunTurn;
    private boolean isAdjustRadarForBodyTurn;
    private boolean isAdjustRadarForBodyTurnSet;
    private int bodyColor = -14079604;
    private int gunColor = -14079604;
    private int radarColor = -14079604;
    private int scanColor = -16776961;
    private int bulletColor = -1;
    private double maxTurnRate;
    private double maxVelocity;
    private boolean moved;
    private boolean scan;
    private boolean isIORobot;
    private boolean isTryingToPaint;
    private String outputText;
    private List<BulletCommand> bullets = new ArrayList<BulletCommand>();
    private List<TeamMessage> teamMessages = new ArrayList<TeamMessage>();
    private List<DebugProperty> debugProperties = new ArrayList<DebugProperty>();
    private Object graphicsCalls;

    public ExecCommands() {
        this.setMaxVelocity(Double.MAX_VALUE);
        this.setMaxTurnRate(Double.MAX_VALUE);
    }

    public ExecCommands(ExecCommands origin, boolean fromRobot) {
        this.bodyTurnRemaining = origin.bodyTurnRemaining;
        this.radarTurnRemaining = origin.radarTurnRemaining;
        this.gunTurnRemaining = origin.gunTurnRemaining;
        this.distanceRemaining = origin.distanceRemaining;
        this.isAdjustGunForBodyTurn = origin.isAdjustGunForBodyTurn;
        this.isAdjustRadarForGunTurn = origin.isAdjustRadarForGunTurn;
        this.isAdjustRadarForBodyTurn = origin.isAdjustRadarForBodyTurn;
        this.isAdjustRadarForBodyTurnSet = origin.isAdjustRadarForBodyTurnSet;
        this.bodyColor = origin.bodyColor;
        this.gunColor = origin.gunColor;
        this.radarColor = origin.radarColor;
        this.bulletColor = origin.bulletColor;
        this.scanColor = origin.scanColor;
        this.maxTurnRate = origin.maxTurnRate;
        this.maxVelocity = origin.maxVelocity;
        if (fromRobot) {
            this.debugProperties = origin.debugProperties;
            this.bullets = origin.bullets;
            this.scan = origin.scan;
            this.moved = origin.moved;
            this.graphicsCalls = origin.graphicsCalls;
            this.outputText = origin.outputText;
            this.teamMessages = origin.teamMessages;
            this.isTryingToPaint = origin.isTryingToPaint;
        }
    }

    public int getBodyColor() {
        return this.bodyColor;
    }

    public int getRadarColor() {
        return this.radarColor;
    }

    public int getGunColor() {
        return this.gunColor;
    }

    public int getBulletColor() {
        return this.bulletColor;
    }

    public int getScanColor() {
        return this.scanColor;
    }

    public void setBodyColor(int color) {
        this.bodyColor = color;
    }

    public void setRadarColor(int color) {
        this.radarColor = color;
    }

    public void setGunColor(int color) {
        this.gunColor = color;
    }

    public void setBulletColor(int color) {
        this.bulletColor = color;
    }

    public void setScanColor(int color) {
        this.scanColor = color;
    }

    public double getBodyTurnRemaining() {
        return this.bodyTurnRemaining;
    }

    public void setBodyTurnRemaining(double bodyTurnRemaining) {
        this.bodyTurnRemaining = bodyTurnRemaining;
    }

    public double getRadarTurnRemaining() {
        return this.radarTurnRemaining;
    }

    public void setRadarTurnRemaining(double radarTurnRemaining) {
        this.radarTurnRemaining = radarTurnRemaining;
    }

    public double getGunTurnRemaining() {
        return this.gunTurnRemaining;
    }

    public void setGunTurnRemaining(double gunTurnRemaining) {
        this.gunTurnRemaining = gunTurnRemaining;
    }

    public double getDistanceRemaining() {
        return this.distanceRemaining;
    }

    public void setDistanceRemaining(double distanceRemaining) {
        this.distanceRemaining = distanceRemaining;
    }

    public boolean isAdjustGunForBodyTurn() {
        return this.isAdjustGunForBodyTurn;
    }

    public void setAdjustGunForBodyTurn(boolean adjustGunForBodyTurn) {
        this.isAdjustGunForBodyTurn = adjustGunForBodyTurn;
    }

    public boolean isAdjustRadarForGunTurn() {
        return this.isAdjustRadarForGunTurn;
    }

    public void setAdjustRadarForGunTurn(boolean adjustRadarForGunTurn) {
        this.isAdjustRadarForGunTurn = adjustRadarForGunTurn;
    }

    public boolean isAdjustRadarForBodyTurn() {
        return this.isAdjustRadarForBodyTurn;
    }

    public void setAdjustRadarForBodyTurn(boolean adjustRadarForBodyTurn) {
        this.isAdjustRadarForBodyTurn = adjustRadarForBodyTurn;
    }

    public boolean isAdjustRadarForBodyTurnSet() {
        return this.isAdjustRadarForBodyTurnSet;
    }

    public void setAdjustRadarForBodyTurnSet(boolean adjustRadarForBodyTurnSet) {
        this.isAdjustRadarForBodyTurnSet = adjustRadarForBodyTurnSet;
    }

    public double getMaxTurnRate() {
        return this.maxTurnRate;
    }

    public void setMaxTurnRate(double maxTurnRate) {
        this.maxTurnRate = Math.min(Math.abs(maxTurnRate), Rules.MAX_TURN_RATE_RADIANS);
    }

    public double getMaxVelocity() {
        return this.maxVelocity;
    }

    public void setMaxVelocity(double maxVelocity) {
        this.maxVelocity = Math.min(Math.abs(maxVelocity), 8.0);
    }

    public boolean isMoved() {
        return this.moved;
    }

    public void setMoved(boolean moved) {
        this.moved = moved;
    }

    public boolean isScan() {
        return this.scan;
    }

    public void setScan(boolean scan) {
        this.scan = scan;
    }

    public List<BulletCommand> getBullets() {
        return this.bullets;
    }

    public Object getGraphicsCalls() {
        return this.graphicsCalls;
    }

    public List<DebugProperty> getDebugProperties() {
        return this.debugProperties;
    }

    public void setGraphicsCalls(Object graphicsCalls) {
        this.graphicsCalls = graphicsCalls;
    }

    public String getOutputText() {
        String out = this.outputText;
        this.outputText = "";
        return out;
    }

    public void setOutputText(String out) {
        this.outputText = out;
    }

    public List<TeamMessage> getTeamMessages() {
        return this.teamMessages;
    }

    public boolean isIORobot() {
        return this.isIORobot;
    }

    public void setIORobot() {
        this.isIORobot = true;
    }

    public void setDebugProperty(String key, String value) {
        this.debugProperties.add(new DebugProperty(key, value));
    }

    public boolean isTryingToPaint() {
        return this.isTryingToPaint;
    }

    public void setTryingToPaint(boolean tryingToPaint) {
        this.isTryingToPaint = tryingToPaint;
    }

    static ISerializableHelper createHiddenSerializer() {
        return new SerializableHelper();
    }

    private static class SerializableHelper
    implements ISerializableHelper {
        private SerializableHelper() {
        }

        public int sizeOf(RbSerializer serializer, Object object) {
            ExecCommands obj = (ExecCommands)object;
            int size = 33;
            size += 4;
            size += 20;
            size += 16;
            size += 4;
            size += serializer.sizeOf(obj.outputText);
            size += serializer.sizeOf((byte[])obj.graphicsCalls);
            size += obj.bullets.size() * serializer.sizeOf((byte)2, null);
            ++size;
            for (TeamMessage m : obj.teamMessages) {
                size += serializer.sizeOf((byte)3, (Object)m);
            }
            ++size;
            for (DebugProperty d : obj.debugProperties) {
                size += serializer.sizeOf((byte)4, (Object)d);
            }
            return ++size;
        }

        public void serialize(RbSerializer serializer, ByteBuffer buffer, Object object) {
            ExecCommands obj = (ExecCommands)object;
            serializer.serialize(buffer, obj.bodyTurnRemaining);
            serializer.serialize(buffer, obj.radarTurnRemaining);
            serializer.serialize(buffer, obj.gunTurnRemaining);
            serializer.serialize(buffer, obj.distanceRemaining);
            serializer.serialize(buffer, obj.isAdjustGunForBodyTurn);
            serializer.serialize(buffer, obj.isAdjustRadarForGunTurn);
            serializer.serialize(buffer, obj.isAdjustRadarForBodyTurn);
            serializer.serialize(buffer, obj.isAdjustRadarForBodyTurnSet);
            serializer.serialize(buffer, obj.bodyColor);
            serializer.serialize(buffer, obj.gunColor);
            serializer.serialize(buffer, obj.radarColor);
            serializer.serialize(buffer, obj.scanColor);
            serializer.serialize(buffer, obj.bulletColor);
            serializer.serialize(buffer, obj.maxTurnRate);
            serializer.serialize(buffer, obj.maxVelocity);
            serializer.serialize(buffer, obj.moved);
            serializer.serialize(buffer, obj.scan);
            serializer.serialize(buffer, obj.isIORobot);
            serializer.serialize(buffer, obj.isTryingToPaint);
            serializer.serialize(buffer, obj.outputText);
            serializer.serialize(buffer, (byte[])obj.graphicsCalls);
            for (BulletCommand bullet : obj.bullets) {
                serializer.serialize(buffer, (byte)2, (Object)bullet);
            }
            buffer.put((byte)-128);
            for (TeamMessage message : obj.teamMessages) {
                serializer.serialize(buffer, (byte)3, (Object)message);
            }
            buffer.put((byte)-128);
            for (DebugProperty prop : obj.debugProperties) {
                serializer.serialize(buffer, (byte)4, (Object)prop);
            }
            buffer.put((byte)-128);
        }

        public Object deserialize(RbSerializer serializer, ByteBuffer buffer) {
            ExecCommands res = new ExecCommands();
            res.bodyTurnRemaining = buffer.getDouble();
            res.radarTurnRemaining = buffer.getDouble();
            res.gunTurnRemaining = buffer.getDouble();
            res.distanceRemaining = buffer.getDouble();
            res.isAdjustGunForBodyTurn = serializer.deserializeBoolean(buffer);
            res.isAdjustRadarForGunTurn = serializer.deserializeBoolean(buffer);
            res.isAdjustRadarForBodyTurn = serializer.deserializeBoolean(buffer);
            res.isAdjustRadarForBodyTurnSet = serializer.deserializeBoolean(buffer);
            res.bodyColor = buffer.getInt();
            res.gunColor = buffer.getInt();
            res.radarColor = buffer.getInt();
            res.scanColor = buffer.getInt();
            res.bulletColor = buffer.getInt();
            res.maxTurnRate = buffer.getDouble();
            res.maxVelocity = buffer.getDouble();
            res.moved = serializer.deserializeBoolean(buffer);
            res.scan = serializer.deserializeBoolean(buffer);
            res.isIORobot = serializer.deserializeBoolean(buffer);
            res.isTryingToPaint = serializer.deserializeBoolean(buffer);
            res.outputText = serializer.deserializeString(buffer);
            res.graphicsCalls = serializer.deserializeBytes(buffer);
            Object item = serializer.deserializeAny(buffer);
            while (item != null) {
                if (item instanceof BulletCommand) {
                    res.bullets.add((BulletCommand)item);
                }
                item = serializer.deserializeAny(buffer);
            }
            item = serializer.deserializeAny(buffer);
            while (item != null) {
                if (item instanceof TeamMessage) {
                    res.teamMessages.add((TeamMessage)item);
                }
                item = serializer.deserializeAny(buffer);
            }
            item = serializer.deserializeAny(buffer);
            while (item != null) {
                if (item instanceof DebugProperty) {
                    res.debugProperties.add((DebugProperty)item);
                }
                item = serializer.deserializeAny(buffer);
            }
            return res;
        }
    }
}

