/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.recording;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import net.sf.robocode.battle.BattleProperties;
import net.sf.robocode.security.HiddenAccess;
import net.sf.robocode.serialization.IXmlSerializable;
import net.sf.robocode.serialization.XmlReader;
import net.sf.robocode.serialization.XmlWriter;
import robocode.BattleResults;
import robocode.BattleRules;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BattleRecordInfo
implements Serializable,
IXmlSerializable {
    private static final long serialVersionUID = 1L;
    public int robotCount;
    public int roundsCount;
    public BattleRules battleRules;
    public Integer[] turnsInRounds;
    public List<BattleResults> results;

    public void writeXml(XmlWriter writer, Dictionary<String, Object> options) throws IOException {
        writer.startElement("recordInfo");
        writer.writeAttribute("robotCount", (long)this.robotCount);
        writer.writeAttribute("roundsCount", (long)this.roundsCount);
        writer.writeAttribute("ver", 1L);
        writer.startElement("rules");
        writer.writeAttribute("battlefieldWidth", (long)this.battleRules.getBattlefieldWidth());
        writer.writeAttribute("battlefieldHeight", (long)this.battleRules.getBattlefieldHeight());
        writer.writeAttribute("numRounds", (long)this.battleRules.getNumRounds());
        writer.writeAttribute("gunCoolingRate", this.battleRules.getGunCoolingRate());
        writer.writeAttribute("inactivityTime", this.battleRules.getInactivityTime());
        writer.writeAttribute("ver", 1L);
        writer.endElement();
        writer.startElement("rounds");
        Integer[] arr$ = this.turnsInRounds;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int n = arr$[i$];
            writer.startElement("turns");
            writer.writeAttribute("value", Integer.toString(n));
            writer.endElement();
        }
        writer.endElement();
        if (this.results != null) {
            writer.startElement("results");
            for (BattleResults result : this.results) {
                new BattleResultsWrapper(result).writeXml(writer, options);
            }
            writer.endElement();
        }
        writer.endElement();
    }

    public XmlReader.Element readXml(XmlReader reader) {
        return reader.expect("recordInfo", new XmlReader.Element(){

            public IXmlSerializable read(XmlReader reader) {
                final BattleRecordInfo recordInfo = new BattleRecordInfo();
                reader.expect("robotCount", new XmlReader.Attribute(){

                    public void read(String value) {
                        recordInfo.robotCount = Integer.parseInt(value);
                    }
                });
                reader.expect("roundsCount", new XmlReader.Attribute(){

                    public void read(String value) {
                        recordInfo.roundsCount = Integer.parseInt(value);
                    }
                });
                new BattleRulesWrapper(recordInfo).readXml(reader);
                reader.expect("rounds", (XmlReader.Element)new XmlReader.ListElement(){
                    final ArrayList<Integer> ints = new ArrayList();

                    public IXmlSerializable read(XmlReader reader) {
                        return new IntValue("turns");
                    }

                    public void add(IXmlSerializable child) {
                        this.ints.add(((IntValue)child).intValue);
                    }

                    public void close() {
                        recordInfo.turnsInRounds = new Integer[this.ints.size()];
                        this.ints.toArray(recordInfo.turnsInRounds);
                    }
                });
                reader.expect("results", (XmlReader.Element)new XmlReader.ListElement(){

                    public IXmlSerializable read(XmlReader reader) {
                        recordInfo.results = new ArrayList<BattleResults>();
                        return new BattleResultsWrapper();
                    }

                    public void add(IXmlSerializable child) {
                        recordInfo.results.add((BattleResults)child);
                    }

                    public void close() {
                    }
                });
                return recordInfo;
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BattleRulesWrapper
    implements IXmlSerializable {
        final BattleProperties props = new BattleProperties();
        final BattleRecordInfo recinfo;

        BattleRulesWrapper(BattleRecordInfo recinfo) {
            this.recinfo = recinfo;
        }

        public void writeXml(XmlWriter writer, Dictionary<String, Object> options) throws IOException {
        }

        public XmlReader.Element readXml(XmlReader reader) {
            return reader.expect("rules", (XmlReader.Element)new XmlReader.ElementClose(){

                public IXmlSerializable read(XmlReader reader) {
                    reader.expect("battlefieldWidth", new XmlReader.Attribute(){

                        public void read(String value) {
                            BattleRulesWrapper.this.props.setBattlefieldWidth(Integer.parseInt(value));
                        }
                    });
                    reader.expect("battlefieldHeight", new XmlReader.Attribute(){

                        public void read(String value) {
                            BattleRulesWrapper.this.props.setBattlefieldHeight(Integer.parseInt(value));
                        }
                    });
                    reader.expect("numRounds", new XmlReader.Attribute(){

                        public void read(String value) {
                            BattleRulesWrapper.this.props.setNumRounds(Integer.parseInt(value));
                        }
                    });
                    reader.expect("inactivityTime", new XmlReader.Attribute(){

                        public void read(String value) {
                            BattleRulesWrapper.this.props.setInactivityTime((long)Integer.parseInt(value));
                        }
                    });
                    reader.expect("gunCoolingRate", new XmlReader.Attribute(){

                        public void read(String value) {
                            BattleRulesWrapper.this.props.setGunCoolingRate(Double.parseDouble(value));
                        }
                    });
                    return BattleRulesWrapper.this;
                }

                public void close() {
                    BattleRulesWrapper.this.recinfo.battleRules = HiddenAccess.createRules((int)BattleRulesWrapper.this.props.getBattlefieldWidth(), (int)BattleRulesWrapper.this.props.getBattlefieldHeight(), (int)BattleRulesWrapper.this.props.getNumRounds(), (double)BattleRulesWrapper.this.props.getGunCoolingRate(), (long)BattleRulesWrapper.this.props.getInactivityTime());
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BattleResultsWrapper
    extends BattleResults
    implements IXmlSerializable {
        private static final long serialVersionUID = 1L;

        public BattleResultsWrapper() {
            super(null, 0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0, 0, 0);
        }

        public BattleResultsWrapper(BattleResults results) {
            super(results.getTeamLeaderName(), results.getRank(), (double)results.getScore(), (double)results.getSurvival(), (double)results.getLastSurvivorBonus(), (double)results.getBulletDamage(), (double)results.getBulletDamageBonus(), (double)results.getRamDamage(), (double)results.getRamDamageBonus(), results.getFirsts(), results.getSeconds(), results.getThirds());
        }

        public void writeXml(XmlWriter writer, Dictionary<String, Object> options) throws IOException {
            writer.startElement("result");
            writer.writeAttribute("teamLeaderName", this.teamLeaderName);
            writer.writeAttribute("rank", (long)this.rank);
            writer.writeAttribute("score", this.score);
            writer.writeAttribute("survival", this.survival);
            writer.writeAttribute("lastSurvivorBonus", this.lastSurvivorBonus);
            writer.writeAttribute("bulletDamage", this.bulletDamage);
            writer.writeAttribute("bulletDamageBonus", this.bulletDamageBonus);
            writer.writeAttribute("ramDamage", this.ramDamage);
            writer.writeAttribute("ramDamageBonus", this.ramDamageBonus);
            writer.writeAttribute("firsts", (long)this.firsts);
            writer.writeAttribute("seconds", (long)this.seconds);
            writer.writeAttribute("thirds", (long)this.thirds);
            writer.writeAttribute("ver", 1L);
            writer.endElement();
        }

        public XmlReader.Element readXml(XmlReader reader) {
            return reader.expect("result", new XmlReader.Element(){

                public IXmlSerializable read(XmlReader reader) {
                    final BattleResultsWrapper rules = new BattleResultsWrapper();
                    reader.expect("teamLeaderName", new XmlReader.Attribute(){

                        public void read(String value) {
                            rules.teamLeaderName = value;
                        }
                    });
                    reader.expect("rank", new XmlReader.Attribute(){

                        public void read(String value) {
                            rules.rank = Integer.parseInt(value);
                        }
                    });
                    reader.expect("score", new XmlReader.Attribute(){

                        public void read(String value) {
                            rules.score = Double.parseDouble(value);
                        }
                    });
                    reader.expect("survival", new XmlReader.Attribute(){

                        public void read(String value) {
                            rules.survival = Double.parseDouble(value);
                        }
                    });
                    reader.expect("lastSurvivorBonus", new XmlReader.Attribute(){

                        public void read(String value) {
                            rules.lastSurvivorBonus = Double.parseDouble(value);
                        }
                    });
                    reader.expect("bulletDamage", new XmlReader.Attribute(){

                        public void read(String value) {
                            rules.bulletDamage = Double.parseDouble(value);
                        }
                    });
                    reader.expect("bulletDamageBonus", new XmlReader.Attribute(){

                        public void read(String value) {
                            rules.bulletDamageBonus = Double.parseDouble(value);
                        }
                    });
                    reader.expect("ramDamage", new XmlReader.Attribute(){

                        public void read(String value) {
                            rules.ramDamage = Double.parseDouble(value);
                        }
                    });
                    reader.expect("ramDamageBonus", new XmlReader.Attribute(){

                        public void read(String value) {
                            rules.ramDamageBonus = Double.parseDouble(value);
                        }
                    });
                    reader.expect("firsts", new XmlReader.Attribute(){

                        public void read(String value) {
                            rules.firsts = Integer.parseInt(value);
                        }
                    });
                    reader.expect("seconds", new XmlReader.Attribute(){

                        public void read(String value) {
                            rules.seconds = Integer.parseInt(value);
                        }
                    });
                    reader.expect("thirds", new XmlReader.Attribute(){

                        public void read(String value) {
                            rules.thirds = Integer.parseInt(value);
                        }
                    });
                    return rules;
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class IntValue
    implements IXmlSerializable {
        private final String name;
        public int intValue;

        IntValue(String name) {
            this.name = name;
        }

        public void writeXml(XmlWriter writer, Dictionary<String, Object> options) throws IOException {
        }

        public XmlReader.Element readXml(XmlReader reader) {
            return reader.expect(this.name, new XmlReader.Element(){

                public IXmlSerializable read(XmlReader reader) {
                    final IntValue recordInfo = new IntValue(IntValue.this.name);
                    reader.expect("value", new XmlReader.Attribute(){

                        public void read(String value) {
                            recordInfo.intValue = Integer.parseInt(value);
                        }
                    });
                    return recordInfo;
                }
            });
        }
    }
}

