/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.battle.peer;

import java.awt.Color;

public class TextPeer {
    private String text;
    private int x;
    private int y;
    private long duration;
    private long visibleTime;
    private boolean ready = true;

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.ready = false;
        this.visibleTime = 0L;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void tick() {
        if (this.text == null) {
            return;
        }
        ++this.visibleTime;
        if (this.visibleTime > this.duration) {
            this.setText(null);
            this.setReady(true);
        }
    }

    public Color getColor() {
        if (this.duration - this.visibleTime > 3L) {
            return Color.white;
        }
        if (this.duration - this.visibleTime > 2L) {
            return Color.lightGray;
        }
        if (this.duration - this.visibleTime > 1L) {
            return Color.gray;
        }
        return Color.darkGray;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void setReady(boolean ready) {
        this.ready = ready;
    }
}

