/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.battle;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import net.sf.robocode.battle.Battle;
import net.sf.robocode.battle.BattleProperties;
import net.sf.robocode.battle.IBattle;
import net.sf.robocode.battle.IBattleManager;
import net.sf.robocode.battle.events.BattleEventDispatcher;
import net.sf.robocode.core.Container;
import net.sf.robocode.host.ICpuManager;
import net.sf.robocode.host.IHostManager;
import net.sf.robocode.io.FileUtil;
import net.sf.robocode.io.Logger;
import net.sf.robocode.recording.BattlePlayer;
import net.sf.robocode.recording.IRecordManager;
import net.sf.robocode.repository.IRepositoryManager;
import net.sf.robocode.settings.ISettingsManager;
import robocode.Event;
import robocode.control.BattleSpecification;
import robocode.control.RandomFactory;
import robocode.control.RobotSpecification;
import robocode.control.events.BattlePausedEvent;
import robocode.control.events.BattleResumedEvent;
import robocode.control.events.IBattleListener;

public class BattleManager
implements IBattleManager {
    private final ISettingsManager properties;
    private final IHostManager hostManager;
    private final ICpuManager cpuManager;
    private final IRecordManager recordManager;
    private final IRepositoryManager repositoryManager;
    private volatile IBattle battle;
    private BattleProperties battleProperties = new BattleProperties();
    private final BattleEventDispatcher battleEventDispatcher;
    private String battleFilename;
    private String battlePath;
    private int pauseCount = 0;
    private final AtomicBoolean isManagedTPS = new AtomicBoolean(false);

    public BattleManager(ISettingsManager properties, IRepositoryManager repositoryManager, IHostManager hostManager, ICpuManager cpuManager, BattleEventDispatcher battleEventDispatcher, IRecordManager recordManager) {
        this.properties = properties;
        this.recordManager = recordManager;
        this.repositoryManager = repositoryManager;
        this.cpuManager = cpuManager;
        this.hostManager = hostManager;
        this.battleEventDispatcher = battleEventDispatcher;
        Logger.setLogListener((IBattleListener)battleEventDispatcher);
    }

    public synchronized void cleanup() {
        if (this.battle != null) {
            this.battle.waitTillOver();
            this.battle.cleanup();
            this.battle = null;
        }
    }

    public void startNewBattle(BattleProperties battleProperties, boolean waitTillOver, boolean enableCLIRecording) {
        this.battleProperties = battleProperties;
        RobotSpecification[] robots = this.repositoryManager.loadSelectedRobots(battleProperties.getSelectedRobots());
        this.startNewBattleImpl(robots, waitTillOver, enableCLIRecording);
    }

    public void startNewBattle(BattleSpecification spec, String initialPositions, boolean waitTillOver, boolean enableCLIRecording) {
        this.battleProperties = new BattleProperties();
        this.battleProperties.setBattlefieldWidth(spec.getBattlefield().getWidth());
        this.battleProperties.setBattlefieldHeight(spec.getBattlefield().getHeight());
        this.battleProperties.setGunCoolingRate(spec.getGunCoolingRate());
        this.battleProperties.setInactivityTime(spec.getInactivityTime());
        this.battleProperties.setNumRounds(spec.getNumRounds());
        this.battleProperties.setSelectedRobots(spec.getRobots());
        this.battleProperties.setInitialPositions(initialPositions);
        RobotSpecification[] robots = this.repositoryManager.loadSelectedRobots(spec.getRobots());
        this.startNewBattleImpl(robots, waitTillOver, enableCLIRecording);
    }

    private void startNewBattleImpl(RobotSpecification[] battlingRobotsList, boolean waitTillOver, boolean enableCLIRecording) {
        boolean recording;
        this.stop(true);
        Logger.logMessage((String)"Preparing battle...");
        boolean bl = recording = this.properties.getOptionsCommonEnableReplayRecording() && System.getProperty("TESTING", "none").equals("none") || enableCLIRecording;
        if (recording) {
            this.recordManager.attachRecorder(this.battleEventDispatcher);
        } else {
            this.recordManager.detachRecorder();
        }
        String seed = System.getProperty("RANDOMSEED", "none");
        if (!seed.equals("none")) {
            this.cpuManager.getCpuConstant();
            RandomFactory.resetDeterministic((long)Long.valueOf(seed));
        }
        Battle realBattle = (Battle)Container.createComponent(Battle.class);
        realBattle.setup(battlingRobotsList, this.battleProperties, this.isPaused());
        if (recording) {
            realBattle.setAllPaintRecorded(true);
        }
        this.battle = realBattle;
        Thread battleThread = new Thread(Thread.currentThread().getThreadGroup(), realBattle);
        battleThread.setPriority(5);
        battleThread.setName("Battle Thread");
        realBattle.setBattleThread(battleThread);
        if (!System.getProperty("NOSECURITY", "false").equals("true")) {
            this.hostManager.addSafeThread(battleThread);
        }
        battleThread.start();
        realBattle.waitTillStarted();
        if (waitTillOver) {
            realBattle.waitTillOver();
        }
    }

    public void waitTillOver() {
        if (this.battle != null) {
            this.battle.waitTillOver();
        }
    }

    private void replayBattle() {
        if (!this.recordManager.hasRecord()) {
            return;
        }
        Logger.logMessage((String)"Preparing replay...");
        if (this.battle != null && this.battle.isRunning()) {
            this.battle.stop(true);
        }
        Logger.setLogListener((IBattleListener)this.battleEventDispatcher);
        this.recordManager.detachRecorder();
        this.battle = (IBattle)Container.createComponent(BattlePlayer.class);
        Thread battleThread = new Thread(Thread.currentThread().getThreadGroup(), this.battle);
        battleThread.setPriority(5);
        battleThread.setName("BattlePlayer Thread");
        battleThread.start();
    }

    public String getBattleFilename() {
        return this.battleFilename;
    }

    public void setBattleFilename(String newBattleFilename) {
        if (newBattleFilename != null) {
            this.battleFilename = newBattleFilename.replace(File.separatorChar == '/' ? (char)'\\' : '/', File.separatorChar);
            if (this.battleFilename.indexOf(File.separatorChar) < 0) {
                try {
                    this.battleFilename = FileUtil.getBattlesDir().getCanonicalPath() + File.separatorChar + this.battleFilename;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (!this.battleFilename.endsWith(".battle")) {
                this.battleFilename = this.battleFilename + ".battle";
            }
        }
    }

    public String getBattlePath() {
        if (this.battlePath == null) {
            this.battlePath = System.getProperty("BATTLEPATH");
            if (this.battlePath == null) {
                this.battlePath = "battles";
            }
            this.battlePath = new File(FileUtil.getCwd(), this.battlePath).getAbsolutePath();
        }
        return this.battlePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveBattleProperties() {
        if (this.battleProperties == null) {
            Logger.logError((String)"Cannot save null battle properties");
            return;
        }
        if (this.battleFilename == null) {
            Logger.logError((String)"Cannot save battle to null path, use setBattleFilename()");
            return;
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.battleFilename);
            this.battleProperties.store(out, "Battle Properties");
        }
        catch (IOException e) {
            Logger.logError((String)("IO Exception saving battle properties: " + e));
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    Logger.logError((Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BattleProperties loadBattleProperties() {
        BattleProperties res = new BattleProperties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(this.getBattleFilename());
            res.load(in);
        }
        catch (FileNotFoundException e) {
            Logger.logError((String)("No file " + this.battleFilename + " found, using defaults."));
        }
        catch (IOException e) {
            Logger.logError((String)("IO Exception reading " + this.getBattleFilename() + ": " + e));
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    Logger.logError((Throwable)e);
                }
            }
        }
        return res;
    }

    public BattleProperties getBattleProperties() {
        if (this.battleProperties == null) {
            this.battleProperties = new BattleProperties();
        }
        return this.battleProperties;
    }

    public void setDefaultBattleProperties() {
        this.battleProperties = new BattleProperties();
    }

    public boolean isManagedTPS() {
        return this.isManagedTPS.get();
    }

    public void setManagedTPS(boolean value) {
        this.isManagedTPS.set(value);
    }

    public synchronized void addListener(IBattleListener listener) {
        this.battleEventDispatcher.addListener(listener);
    }

    public synchronized void removeListener(IBattleListener listener) {
        this.battleEventDispatcher.removeListener(listener);
    }

    public synchronized void stop(boolean waitTillEnd) {
        if (this.battle != null && this.battle.isRunning()) {
            this.battle.stop(waitTillEnd);
        }
    }

    public synchronized void restart() {
        this.startNewBattle(this.battleProperties, false, false);
    }

    public synchronized void replay() {
        this.replayBattle();
    }

    private boolean isPaused() {
        return this.pauseCount != 0;
    }

    public synchronized void togglePauseResumeBattle() {
        if (this.isPaused()) {
            this.resumeBattle();
        } else {
            this.pauseBattle();
        }
    }

    public synchronized void pauseBattle() {
        if (++this.pauseCount == 1) {
            if (this.battle != null && this.battle.isRunning()) {
                this.battle.pause();
            } else {
                this.battleEventDispatcher.onBattlePaused(new BattlePausedEvent());
            }
        }
    }

    public synchronized void pauseIfResumedBattle() {
        if (this.pauseCount == 0) {
            ++this.pauseCount;
            if (this.battle != null && this.battle.isRunning()) {
                this.battle.pause();
            } else {
                this.battleEventDispatcher.onBattlePaused(new BattlePausedEvent());
            }
        }
    }

    public synchronized void resumeIfPausedBattle() {
        if (this.pauseCount == 1) {
            --this.pauseCount;
            if (this.battle != null && this.battle.isRunning()) {
                this.battle.resume();
            } else {
                this.battleEventDispatcher.onBattleResumed(new BattleResumedEvent());
            }
        }
    }

    public synchronized void resumeBattle() {
        if (--this.pauseCount < 0) {
            this.pauseCount = 0;
            Logger.logError((String)"SYSTEM: pause game bug!");
        } else if (this.pauseCount == 0) {
            if (this.battle != null && this.battle.isRunning()) {
                this.battle.resume();
            } else {
                this.battleEventDispatcher.onBattleResumed(new BattleResumedEvent());
            }
        }
    }

    public synchronized void nextTurn() {
        if (this.battle != null && this.battle.isRunning()) {
            this.battle.step();
        }
    }

    public synchronized void prevTurn() {
        if (this.battle != null && this.battle.isRunning() && this.battle instanceof BattlePlayer) {
            ((BattlePlayer)this.battle).stepBack();
        }
    }

    public synchronized void killRobot(int robotIndex) {
        if (this.battle != null && this.battle.isRunning() && this.battle instanceof Battle) {
            ((Battle)this.battle).killRobot(robotIndex);
        }
    }

    public synchronized void setPaintEnabled(int robotIndex, boolean enable) {
        if (this.battle != null && this.battle.isRunning()) {
            this.battle.setPaintEnabled(robotIndex, enable);
        }
    }

    public synchronized void setSGPaintEnabled(int robotIndex, boolean enable) {
        if (this.battle != null && this.battle.isRunning() && this.battle instanceof Battle) {
            ((Battle)this.battle).setSGPaintEnabled(robotIndex, enable);
        }
    }

    public synchronized void sendInteractiveEvent(Event event) {
        if (this.battle != null && this.battle.isRunning() && !this.isPaused() && this.battle instanceof Battle) {
            ((Battle)this.battle).sendInteractiveEvent(event);
        }
    }
}

