/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.recording;

import java.util.Arrays;
import net.sf.robocode.battle.events.BattleEventDispatcher;
import net.sf.robocode.recording.RecordManager;
import robocode.control.events.BattleAdaptor;
import robocode.control.events.BattleCompletedEvent;
import robocode.control.events.BattleFinishedEvent;
import robocode.control.events.BattleStartedEvent;
import robocode.control.events.IBattleListener;
import robocode.control.events.RoundStartedEvent;
import robocode.control.events.TurnEndedEvent;

public class BattleRecorder {
    private final RecordManager recordmanager;
    private BattleObserver battleObserver;

    public BattleRecorder(RecordManager recordmanager) {
        this.recordmanager = recordmanager;
    }

    public void attachRecorder(BattleEventDispatcher battleEventDispatcher) {
        if (this.battleObserver != null) {
            this.battleObserver.dispose();
        }
        this.battleObserver = new BattleObserver(battleEventDispatcher);
    }

    public void detachRecorder() {
        if (this.battleObserver != null) {
            this.battleObserver.dispose();
        }
    }

    private class BattleObserver
    extends BattleAdaptor {
        private final BattleEventDispatcher dispatcher;
        private int currentTurn;
        private int currentRound;

        public BattleObserver(BattleEventDispatcher dispatcher) {
            this.dispatcher = dispatcher;
            dispatcher.addListener((IBattleListener)this);
        }

        public void dispose() {
            this.dispatcher.removeListener((IBattleListener)this);
            BattleRecorder.this.recordmanager.cleanupStreams();
        }

        public void onBattleStarted(BattleStartedEvent event) {
            BattleRecorder.this.recordmanager.cleanupStreams();
            BattleRecorder.this.recordmanager.createRecordInfo(event.getBattleRules(), event.getRobotsCount());
            this.currentRound = 0;
            this.currentTurn = 0;
        }

        public void onBattleFinished(BattleFinishedEvent event) {
            BattleRecorder.this.recordmanager.cleanupStreams();
        }

        public void onBattleCompleted(BattleCompletedEvent event) {
            BattleRecorder.this.recordmanager.updateRecordInfoResults(Arrays.asList(event.getIndexedResults()));
        }

        public void onRoundStarted(RoundStartedEvent event) {
            this.currentRound = event.getRound();
            this.currentTurn = 0;
            BattleRecorder.this.recordmanager.writeTurn(event.getStartSnapshot(), this.currentRound, this.currentTurn);
        }

        public void onTurnEnded(TurnEndedEvent event) {
            this.currentTurn = event.getTurnSnapshot().getTurn();
            BattleRecorder.this.recordmanager.writeTurn(event.getTurnSnapshot(), this.currentRound, this.currentTurn);
        }
    }
}

