/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.battle.snapshot;

import java.awt.geom.Arc2D;
import java.io.IOException;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.List;
import net.sf.robocode.battle.peer.RobotPeer;
import net.sf.robocode.battle.snapshot.ScoreSnapshot;
import net.sf.robocode.peer.DebugProperty;
import net.sf.robocode.serialization.IXmlSerializable;
import net.sf.robocode.serialization.XmlReader;
import net.sf.robocode.serialization.XmlWriter;
import robocode.control.snapshot.IRobotSnapshot;
import robocode.control.snapshot.IScoreSnapshot;
import robocode.control.snapshot.RobotState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RobotSnapshot
implements Serializable,
IXmlSerializable,
IRobotSnapshot {
    private static final long serialVersionUID = 1L;
    private String name;
    private String shortName;
    private String veryShortName;
    private String teamName;
    private int contestantIndex;
    private RobotState state;
    private double energy;
    private double velocity;
    private double gunHeat;
    private double bodyHeading;
    private double gunHeading;
    private double radarHeading;
    private double x;
    private double y;
    private int bodyColor = -14079604;
    private int gunColor = -14079604;
    private int radarColor = -14079604;
    private int scanColor = -16776961;
    private boolean isDroid;
    private boolean isPaintRobot;
    private boolean isPaintEnabled;
    private boolean isSGPaintEnabled;
    private SerializableArc scanArc;
    private Object graphicsCalls;
    private DebugProperty[] debugProperties;
    private String outputStreamSnapshot;
    private IScoreSnapshot robotScoreSnapshot;

    public RobotSnapshot() {
    }

    public RobotSnapshot(RobotPeer robot, boolean readoutText) {
        this.name = robot.getName();
        this.shortName = robot.getShortName();
        this.veryShortName = robot.getVeryShortName();
        this.teamName = robot.getTeamName();
        this.contestantIndex = robot.getContestIndex();
        this.state = robot.getState();
        this.energy = robot.getEnergy();
        this.velocity = robot.getVelocity();
        this.gunHeat = robot.getGunHeat();
        this.bodyHeading = robot.getBodyHeading();
        this.gunHeading = robot.getGunHeading();
        this.radarHeading = robot.getRadarHeading();
        this.x = robot.getX();
        this.y = robot.getY();
        this.bodyColor = robot.getBodyColor();
        this.gunColor = robot.getGunColor();
        this.radarColor = robot.getRadarColor();
        this.scanColor = robot.getScanColor();
        this.isDroid = robot.isDroid();
        this.isPaintRobot = robot.isPaintRobot() || robot.isTryingToPaint();
        this.isPaintEnabled = robot.isPaintEnabled();
        this.isSGPaintEnabled = robot.isSGPaintEnabled();
        this.scanArc = robot.getScanArc() != null ? new SerializableArc((Arc2D.Double)robot.getScanArc()) : null;
        this.graphicsCalls = robot.getGraphicsCalls();
        List<DebugProperty> dp = robot.getDebugProperties();
        DebugProperty[] debugPropertyArray = this.debugProperties = dp != null ? dp.toArray(new DebugProperty[dp.size()]) : null;
        if (readoutText) {
            this.outputStreamSnapshot = robot.readOutText();
        }
        this.robotScoreSnapshot = new ScoreSnapshot(robot.getName(), robot.getRobotStatistics());
    }

    public String toString() {
        return this.shortName + "(" + (int)this.energy + ") X" + (int)this.x + " Y" + (int)this.y + " " + this.state.toString();
    }

    public String getName() {
        return this.name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getVeryShortName() {
        return this.veryShortName;
    }

    public String getTeamName() {
        return this.teamName;
    }

    public int getContestantIndex() {
        return this.contestantIndex;
    }

    public RobotState getState() {
        return this.state;
    }

    public double getEnergy() {
        return this.energy;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public double getBodyHeading() {
        return this.bodyHeading;
    }

    public double getGunHeading() {
        return this.gunHeading;
    }

    public double getRadarHeading() {
        return this.radarHeading;
    }

    public double getGunHeat() {
        return this.gunHeat;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public int getBodyColor() {
        return this.bodyColor;
    }

    public int getGunColor() {
        return this.gunColor;
    }

    public int getRadarColor() {
        return this.radarColor;
    }

    public int getScanColor() {
        return this.scanColor;
    }

    public boolean isDroid() {
        return this.isDroid;
    }

    public boolean isPaintRobot() {
        return this.isPaintRobot;
    }

    public boolean isPaintEnabled() {
        return this.isPaintEnabled;
    }

    public void setPaintEnabled(boolean isPaintEnabled) {
        this.isPaintEnabled = isPaintEnabled;
    }

    public boolean isSGPaintEnabled() {
        return this.isSGPaintEnabled;
    }

    public DebugProperty[] getDebugProperties() {
        return this.debugProperties;
    }

    public String getOutputStreamSnapshot() {
        return this.outputStreamSnapshot;
    }

    public void setOutputStreamSnapshot(String outputStreamSnapshot) {
        this.outputStreamSnapshot = outputStreamSnapshot;
    }

    public IScoreSnapshot getScoreSnapshot() {
        return this.robotScoreSnapshot;
    }

    public Arc2D getScanArc() {
        return this.scanArc != null ? this.scanArc.create() : null;
    }

    public Object getGraphicsCalls() {
        return this.graphicsCalls;
    }

    public void writeXml(XmlWriter writer, Dictionary<String, Object> options) throws IOException {
        writer.startElement("robot");
        Object details = options == null ? null : options.get("skipDetails");
        writer.writeAttribute("vsName", this.veryShortName);
        writer.writeAttribute("state", this.state.toString());
        writer.writeAttribute("energy", this.energy);
        writer.writeAttribute("x", this.x);
        writer.writeAttribute("y", this.y);
        writer.writeAttribute("bodyHeading", this.bodyHeading);
        writer.writeAttribute("gunHeading", this.gunHeading);
        writer.writeAttribute("radarHeading", this.radarHeading);
        writer.writeAttribute("gunHeat", this.gunHeat);
        writer.writeAttribute("velocity", this.velocity);
        writer.writeAttribute("teamName", this.teamName);
        if (details == null) {
            writer.writeAttribute("name", this.name);
            writer.writeAttribute("sName", this.shortName);
            if (this.isDroid) {
                writer.writeAttribute("isDroid", true);
            }
            if (this.bodyColor != -14079604) {
                writer.writeAttribute("bodyColor", Integer.toHexString(this.bodyColor).toUpperCase());
            }
            if (this.gunColor != -14079604) {
                writer.writeAttribute("gunColor", Integer.toHexString(this.gunColor).toUpperCase());
            }
            if (this.radarColor != -14079604) {
                writer.writeAttribute("radarColor", Integer.toHexString(this.radarColor).toUpperCase());
            }
            if (this.scanColor != -16776961) {
                writer.writeAttribute("scanColor", Integer.toHexString(this.scanColor).toUpperCase());
            }
        }
        writer.writeAttribute("ver", 1L);
        if (this.outputStreamSnapshot != null && this.outputStreamSnapshot.length() != 0) {
            writer.writeAttribute("out", this.outputStreamSnapshot);
        }
        if (this.debugProperties != null) {
            writer.startElement("debugProperties");
            for (DebugProperty prop : this.debugProperties) {
                prop.writeXml(writer, options);
            }
            writer.endElement();
        }
        ((ScoreSnapshot)this.robotScoreSnapshot).writeXml(writer, options);
        writer.endElement();
    }

    public XmlReader.Element readXml(XmlReader reader) {
        return reader.expect("robot", new XmlReader.Element(){

            public IXmlSerializable read(XmlReader reader) {
                final RobotSnapshot snapshot = new RobotSnapshot();
                reader.expect("name", new XmlReader.Attribute(){

                    public void read(String value) {
                        snapshot.name = value;
                    }
                });
                reader.expect("sName", new XmlReader.Attribute(){

                    public void read(String value) {
                        snapshot.shortName = value;
                    }
                });
                reader.expect("vsName", new XmlReader.Attribute(){

                    public void read(String value) {
                        snapshot.veryShortName = value;
                    }
                });
                reader.expect("teamName", new XmlReader.Attribute(){

                    public void read(String value) {
                        snapshot.teamName = value;
                    }
                });
                reader.expect("state", new XmlReader.Attribute(){

                    public void read(String value) {
                        snapshot.state = RobotState.valueOf((String)value);
                    }
                });
                reader.expect("isDroid", new XmlReader.Attribute(){

                    public void read(String value) {
                        snapshot.isDroid = Boolean.valueOf(value);
                    }
                });
                reader.expect("bodyColor", new XmlReader.Attribute(){

                    public void read(String value) {
                        snapshot.bodyColor = Long.valueOf(value.toUpperCase(), 16).intValue();
                    }
                });
                reader.expect("gunColor", new XmlReader.Attribute(){

                    public void read(String value) {
                        snapshot.gunColor = Long.valueOf(value.toUpperCase(), 16).intValue();
                    }
                });
                reader.expect("radarColor", new XmlReader.Attribute(){

                    public void read(String value) {
                        snapshot.radarColor = Long.valueOf(value.toUpperCase(), 16).intValue();
                    }
                });
                reader.expect("scanColor", new XmlReader.Attribute(){

                    public void read(String value) {
                        snapshot.scanColor = Long.valueOf(value.toUpperCase(), 16).intValue();
                    }
                });
                reader.expect("energy", new XmlReader.Attribute(){

                    public void read(String value) {
                        snapshot.energy = Double.parseDouble(value);
                    }
                });
                reader.expect("velocity", new XmlReader.Attribute(){

                    public void read(String value) {
                        snapshot.velocity = Double.parseDouble(value);
                    }
                });
                reader.expect("gunHeat", new XmlReader.Attribute(){

                    public void read(String value) {
                        snapshot.gunHeat = Double.parseDouble(value);
                    }
                });
                reader.expect("bodyHeading", new XmlReader.Attribute(){

                    public void read(String value) {
                        snapshot.bodyHeading = Double.parseDouble(value);
                    }
                });
                reader.expect("gunHeading", new XmlReader.Attribute(){

                    public void read(String value) {
                        snapshot.gunHeading = Double.parseDouble(value);
                    }
                });
                reader.expect("radarHeading", new XmlReader.Attribute(){

                    public void read(String value) {
                        snapshot.radarHeading = Double.parseDouble(value);
                    }
                });
                reader.expect("x", new XmlReader.Attribute(){

                    public void read(String value) {
                        snapshot.x = Double.parseDouble(value);
                    }
                });
                reader.expect("y", new XmlReader.Attribute(){

                    public void read(String value) {
                        snapshot.y = Double.parseDouble(value);
                    }
                });
                reader.expect("out", new XmlReader.Attribute(){

                    public void read(String value) {
                        if (value != null && value.length() != 0) {
                            snapshot.outputStreamSnapshot = value;
                        }
                    }
                });
                final XmlReader.Element element = new ScoreSnapshot().readXml(reader);
                reader.expect("score", new XmlReader.Element(){

                    public IXmlSerializable read(XmlReader reader) {
                        snapshot.robotScoreSnapshot = (IScoreSnapshot)element.read(reader);
                        return (ScoreSnapshot)snapshot.robotScoreSnapshot;
                    }
                });
                return snapshot;
            }
        });
    }

    private class SerializableArc
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public double x;
        public double y;
        public double w;
        public double h;
        public double start;
        public double extent;
        public int type;

        public SerializableArc() {
        }

        public SerializableArc(Arc2D.Double arc) {
            this.x = arc.getX();
            this.y = arc.getY();
            this.w = arc.getWidth();
            this.h = arc.getHeight();
            this.start = arc.getAngleStart();
            this.extent = arc.getAngleExtent();
            this.type = arc.getArcType();
        }

        public Arc2D create() {
            return new Arc2D.Double(this.x, this.y, this.w, this.h, this.start, this.extent, this.type);
        }
    }
}

