/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.injectors;

import java.lang.reflect.Type;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.Injector;
import org.picocontainer.LifecycleStrategy;
import org.picocontainer.Parameter;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoVisitor;
import org.picocontainer.injectors.AbstractInjector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeInjector<T>
extends AbstractInjector<T> {
    private final Injector<T>[] injectors;

    public CompositeInjector(Object componentKey, Class<?> componentImplementation, Parameter[] parameters, ComponentMonitor monitor, LifecycleStrategy lifecycleStrategy, boolean useNames, Injector ... injectors) {
        super(componentKey, componentImplementation, parameters, monitor, lifecycleStrategy, useNames);
        this.injectors = injectors;
    }

    @Override
    public T getComponentInstance(PicoContainer container) throws PicoCompositionException {
        return this.getComponentInstance(container, (Type)((Object)ComponentAdapter.NOTHING.class));
    }

    @Override
    public T getComponentInstance(PicoContainer container, Type into) throws PicoCompositionException {
        Object instance = null;
        for (int i = 0; i < this.injectors.length; ++i) {
            Injector<T> injector = this.injectors[i];
            if (instance == null) {
                instance = injector.getComponentInstance(container, (Type)((Object)ComponentAdapter.NOTHING.class));
                continue;
            }
            injector.decorateComponentInstance(container, into, instance);
        }
        return instance;
    }

    @Override
    public void decorateComponentInstance(PicoContainer container, Type into, T instance) {
    }

    @Override
    public void verify(PicoContainer container) throws PicoCompositionException {
        for (int i = 0; i < this.injectors.length; ++i) {
            this.injectors[i].verify(container);
        }
    }

    @Override
    public final void accept(PicoVisitor visitor) {
        super.accept(visitor);
        for (int i = 0; i < this.injectors.length; ++i) {
            this.injectors[i].accept(visitor);
        }
    }

    @Override
    public String getDescriptor() {
        return "CompositeInjector";
    }
}

