/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.injectors;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.Injector;
import org.picocontainer.LifecycleStrategy;
import org.picocontainer.Parameter;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoVisitor;
import org.picocontainer.adapters.AbstractAdapter;
import org.picocontainer.parameters.ComponentParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInjector<T>
extends AbstractAdapter<T>
implements LifecycleStrategy,
Injector<T> {
    protected transient ThreadLocalCyclicDependencyGuard verifyingGuard;
    protected transient Parameter[] parameters;
    protected LifecycleStrategy lifecycleStrategy;
    private final boolean useNames;

    protected AbstractInjector(Object componentKey, Class<?> componentImplementation, Parameter[] parameters, ComponentMonitor monitor, LifecycleStrategy lifecycleStrategy, boolean useNames) {
        super(componentKey, componentImplementation, monitor);
        this.useNames = useNames;
        this.checkConcrete();
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                if (parameters[i] != null) continue;
                throw new NullPointerException("Parameter " + i + " is null");
            }
        }
        this.parameters = parameters;
        this.lifecycleStrategy = lifecycleStrategy;
    }

    public boolean useNames() {
        return this.useNames;
    }

    private void checkConcrete() throws NotConcreteRegistrationException {
        boolean isAbstract;
        boolean bl = isAbstract = (this.getComponentImplementation().getModifiers() & 0x400) == 1024;
        if (this.getComponentImplementation().isInterface() || isAbstract) {
            throw new NotConcreteRegistrationException(this.getComponentImplementation());
        }
    }

    protected Parameter[] createDefaultParameters(Type[] parameters) {
        Parameter[] componentParameters = new Parameter[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            componentParameters[i] = ComponentParameter.DEFAULT;
        }
        return componentParameters;
    }

    @Override
    public void verify(PicoContainer container) throws PicoCompositionException {
    }

    @Override
    public T getComponentInstance(PicoContainer container) throws PicoCompositionException {
        return this.getComponentInstance(container, (Type)((Object)ComponentAdapter.NOTHING.class));
    }

    @Override
    public abstract T getComponentInstance(PicoContainer var1, Type var2) throws PicoCompositionException;

    @Override
    public void accept(PicoVisitor visitor) {
        super.accept(visitor);
        if (this.parameters != null) {
            for (Parameter parameter : this.parameters) {
                parameter.accept(visitor);
            }
        }
    }

    @Override
    public void start(Object component) {
        this.lifecycleStrategy.start(component);
    }

    @Override
    public void stop(Object component) {
        this.lifecycleStrategy.stop(component);
    }

    @Override
    public void dispose(Object component) {
        this.lifecycleStrategy.dispose(component);
    }

    @Override
    public boolean hasLifecycle(Class<?> type) {
        return this.lifecycleStrategy.hasLifecycle(type);
    }

    @Override
    public String getDescriptor() {
        return "Asbtract Injector";
    }

    protected T newInstance(Constructor<T> constructor, Object[] parameters) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        return constructor.newInstance(parameters);
    }

    protected T caughtInstantiationException(ComponentMonitor componentMonitor, Constructor<T> constructor, InstantiationException e, PicoContainer container) {
        componentMonitor.instantiationFailed(container, this, constructor, e);
        throw new PicoCompositionException("Should never get here");
    }

    protected T caughtIllegalAccessException(ComponentMonitor componentMonitor, Constructor<T> constructor, IllegalAccessException e, PicoContainer container) {
        componentMonitor.instantiationFailed(container, this, constructor, e);
        throw new PicoCompositionException(e);
    }

    protected T caughtInvocationTargetException(ComponentMonitor componentMonitor, Member member, Object componentInstance, InvocationTargetException e) {
        componentMonitor.invocationFailed(member, componentInstance, e);
        if (e.getTargetException() instanceof RuntimeException) {
            throw (RuntimeException)e.getTargetException();
        }
        if (e.getTargetException() instanceof Error) {
            throw (Error)e.getTargetException();
        }
        throw new PicoCompositionException(e.getTargetException());
    }

    protected Object caughtIllegalAccessException(ComponentMonitor componentMonitor, Member member, Object componentInstance, IllegalAccessException e) {
        componentMonitor.invocationFailed(member, componentInstance, e);
        throw new PicoCompositionException(e);
    }

    protected Type box(Type parameterType) {
        if (parameterType instanceof Class && ((Class)parameterType).isPrimitive()) {
            String parameterTypeName = ((Class)parameterType).getName();
            if (parameterTypeName == "int") {
                return Integer.class;
            }
            if (parameterTypeName == "boolean") {
                return Boolean.class;
            }
            if (parameterTypeName == "long") {
                return Long.class;
            }
            if (parameterTypeName == "float") {
                return Float.class;
            }
            if (parameterTypeName == "double") {
                return Double.class;
            }
            if (parameterTypeName == "char") {
                return Character.class;
            }
            if (parameterTypeName == "byte") {
                return Byte.class;
            }
            if (parameterTypeName == "short") {
                return Short.class;
            }
        }
        return parameterType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NotConcreteRegistrationException
    extends PicoCompositionException {
        private final Class<?> componentImplementation;

        public NotConcreteRegistrationException(Class<?> componentImplementation) {
            super("Bad Access: '" + componentImplementation.getName() + "' is not instantiable");
            this.componentImplementation = componentImplementation;
        }

        public Class<?> getComponentImplementation() {
            return this.componentImplementation;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UnsatisfiableDependenciesException
    extends PicoCompositionException {
        private final ComponentAdapter<?> instantiatingComponentAdapter;
        private final Set unsatisfiableDependencies;
        private final Type unsatisfiedDependencyType;
        private final PicoContainer leafContainer;

        public UnsatisfiableDependenciesException(ComponentAdapter<?> instantiatingComponentAdapter, Type unsatisfiedDependencyType, Set unsatisfiableDependencies, PicoContainer leafContainer) {
            super(instantiatingComponentAdapter.getComponentImplementation().getName() + " has unsatisfied dependency: " + unsatisfiedDependencyType + " among unsatisfiable dependencies: " + unsatisfiableDependencies + " where " + leafContainer + " was the leaf container being asked for dependencies.");
            this.instantiatingComponentAdapter = instantiatingComponentAdapter;
            this.unsatisfiableDependencies = unsatisfiableDependencies;
            this.unsatisfiedDependencyType = unsatisfiedDependencyType;
            this.leafContainer = leafContainer;
        }

        public ComponentAdapter<?> getUnsatisfiableComponentAdapter() {
            return this.instantiatingComponentAdapter;
        }

        public Set getUnsatisfiableDependencies() {
            return this.unsatisfiableDependencies;
        }

        public Type getUnsatisfiedDependencyType() {
            return this.unsatisfiedDependencyType;
        }

        public PicoContainer getLeafContainer() {
            return this.leafContainer;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AmbiguousComponentResolutionException
    extends PicoCompositionException {
        private Class<?> component;
        private final Class<?> ambiguousDependency;
        private final Object[] ambiguousComponentKeys;

        public AmbiguousComponentResolutionException(Class<?> ambiguousDependency, Object[] componentKeys) {
            super("");
            this.ambiguousDependency = ambiguousDependency;
            this.ambiguousComponentKeys = new Class[componentKeys.length];
            System.arraycopy(componentKeys, 0, this.ambiguousComponentKeys, 0, componentKeys.length);
        }

        @Override
        public String getMessage() {
            StringBuffer msg = new StringBuffer();
            msg.append(this.component != null ? this.component : "<no-component>");
            msg.append(" needs a '");
            msg.append(this.ambiguousDependency.getName());
            msg.append("' injected, but there are too many choices to inject. These:");
            msg.append(Arrays.asList(this.getAmbiguousComponentKeys()));
            msg.append(", refer http://picocontainer.org/ambiguous-injectable-help.html");
            return msg.toString();
        }

        public Object[] getAmbiguousComponentKeys() {
            return this.ambiguousComponentKeys;
        }

        public void setComponent(Class<?> component) {
            this.component = component;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CyclicDependencyException
    extends PicoCompositionException {
        private final List<Class> stack = new LinkedList<Class>();

        public CyclicDependencyException(Class<?> element) {
            super((Throwable)null);
            this.push(element);
        }

        public void push(Class<?> element) {
            this.stack.add(element);
        }

        public Class[] getDependencies() {
            return this.stack.toArray(new Class[this.stack.size()]);
        }

        @Override
        public String getMessage() {
            return "Cyclic dependency: " + this.stack.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class ThreadLocalCyclicDependencyGuard<T>
    extends ThreadLocal<Boolean> {
        protected PicoContainer guardedContainer;

        ThreadLocalCyclicDependencyGuard() {
        }

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }

        public abstract T run();

        public final T observe(Class<?> stackFrame) {
            if (Boolean.TRUE.equals(this.get())) {
                throw new CyclicDependencyException(stackFrame);
            }
            T result = null;
            try {
                this.set(Boolean.TRUE);
                result = this.run();
            }
            catch (CyclicDependencyException e) {
                e.push(stackFrame);
                throw e;
            }
            finally {
                this.set(Boolean.FALSE);
            }
            return result;
        }

        public void setGuardedContainer(PicoContainer container) {
            this.guardedContainer = container;
        }
    }
}

