/*
 * Decompiled with CFR 0.152.
 */
package codesize;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;

public class Codesize {
    private static final int DEFAULT_BUFFER_SIZE = 524288;
    private static boolean verbose;
    static /* synthetic */ Class class$codesize$Codesize;

    private Codesize() {
    }

    private static List processCmdLine(String[] args) {
        ArrayList<Item> result = new ArrayList<Item>();
        for (int i = 0; i < args.length; ++i) {
            Item item;
            File file;
            if (args[i].equals("-v")) {
                verbose = true;
                continue;
            }
            if (args[i].equals("-r")) {
                File repository = new File(args[++i]);
                String[] files = repository.list();
                for (int j = 0; j < files.length; ++j) {
                    file = new File(repository, files[j]);
                    item = files[j].toLowerCase().endsWith(".class") ? Codesize.processClassFile(file) : Codesize.processZipFile(file);
                    if (item == null) continue;
                    result.add(item);
                }
                continue;
            }
            file = new File(args[i]);
            item = file.isDirectory() ? Codesize.processDirectory(file) : (args[i].toLowerCase().endsWith(".class") ? Codesize.processClassFile(file) : Codesize.processZipFile(file));
            if (item == null) continue;
            result.add(item);
        }
        Collections.sort(result);
        return result;
    }

    private static void deepListClassFiles(File directory, List result) {
        String[] files = directory.list();
        for (int i = 0; i < files.length; ++i) {
            File file = new File(directory, files[i]);
            if (file.isDirectory()) {
                Codesize.deepListClassFiles(file, result);
                continue;
            }
            if (!files[i].toLowerCase().endsWith(".class")) continue;
            result.add(file);
        }
    }

    private static String stripFilename(File file) {
        String result = file.toString();
        if (result.indexOf(File.separator) > -1) {
            result = result.substring(result.lastIndexOf(File.separator) + 1);
        }
        return result;
    }

    private static void help() {
        Package p = (class$codesize$Codesize == null ? (class$codesize$Codesize = Codesize.class$("codesize.Codesize")) : class$codesize$Codesize).getPackage();
        System.out.println(p.getImplementationTitle() + " " + p.getImplementationVersion() + " - http://user.cs.tu-berlin.de/~lulli/codesize/");
        System.out.println("SYNTAX:");
        System.out.println();
        System.out.println("  codesize [-v] [<class-file> | <zip-file> | <directory> | -r <repository>]+");
        System.out.println();
        System.out.println("- <class-file> is a single .class file");
        System.out.println("- <zip-file> is a zip compressed file (or a .jar file)");
        System.out.println("- <directory> is treated like an uncompressed <zip-file>,");
        System.out.println("  recursively processing any subdirectories");
        System.out.println("- <repository> is a directory like '<robocode>/robots':");
        System.out.println("  - any class file in it is treated like a <class-file>");
        System.out.println("  - any zip file in it is treated like a <zip-file>");
        System.out.println("  - any subdirectory is ignored (can't distinguish different robots here)");
        System.out.println("- specify -v for verbose output");
    }

    private static int processClassInputStream(InputStream inputStream, String filename) throws IOException {
        int result = 0;
        ClassParser classParser = new ClassParser(inputStream, filename);
        Method[] methods = classParser.parse().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Code code = methods[i].getCode();
            if (code == null) continue;
            result += code.getCode().length;
        }
        if (verbose) {
            System.out.println(filename + " code size: " + result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Item processClassFile(File classFile) {
        Item item;
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(classFile));
        try {
            item = new Item(classFile, 1, (int)classFile.length(), Codesize.processClassInputStream(inputStream, classFile.getName()));
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)inputStream).close();
                throw throwable;
            }
            catch (IOException e) {
                System.err.println("Ignoring " + Codesize.stripFilename(classFile) + ": " + e.getMessage());
                return null;
            }
        }
        ((InputStream)inputStream).close();
        return item;
    }

    public static Item processDirectory(File directory) {
        int ttlClassSize = 0;
        int ttlCodeSize = 0;
        ArrayList classFiles = new ArrayList();
        Codesize.deepListClassFiles(directory, classFiles);
        for (int i = 0; i < classFiles.size(); ++i) {
            Item item = Codesize.processClassFile((File)classFiles.get(i));
            ttlClassSize += item.ttlClassSize;
            ttlCodeSize += item.ttlCodeSize;
        }
        return new Item(directory, classFiles.size(), ttlClassSize, ttlCodeSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Item processZipFile(File zipFile) {
        Item item;
        if (verbose) {
            System.out.println("Processing zip file " + zipFile.getName());
        }
        ZipInputStream inputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(zipFile)));
        try {
            item = Codesize.processZipFile(zipFile, inputStream);
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException e) {
                System.err.println("Ignoring " + Codesize.stripFilename(zipFile) + ": " + e.getMessage());
                return null;
            }
        }
        inputStream.close();
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Item processZipFile(File zipFile, ZipInputStream inputStream) throws IOException {
        ZipEntry zipEntry;
        int nClassFiles = 0;
        int ttlClassSize = 0;
        int ttlCodeSize = 0;
        while ((zipEntry = inputStream.getNextEntry()) != null) {
            ByteArrayOutputStream baos;
            String lcName = zipEntry.getName().toLowerCase();
            if (lcName.endsWith(".class")) {
                baos = Codesize.getByteArrayOutputStream(inputStream, (int)zipFile.length());
                ttlCodeSize += Codesize.processClassInputStream(new ByteArrayInputStream(baos.toByteArray()), zipEntry.getName());
                ttlClassSize += baos.size();
                ++nClassFiles;
                continue;
            }
            if (!lcName.endsWith(".jar")) continue;
            baos = Codesize.getByteArrayOutputStream(inputStream, (int)zipFile.length());
            ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(baos.toByteArray()));
            try {
                Item item = Codesize.processZipFile(zipFile, zis);
                ttlCodeSize += item.ttlCodeSize;
                ttlClassSize += item.ttlClassSize;
            }
            finally {
                zis.close();
            }
        }
        if (ttlCodeSize == 0) {
            throw new IOException("total code size is 0");
        }
        return new Item(zipFile, nClassFiles, ttlClassSize, ttlCodeSize);
    }

    private static ByteArrayOutputStream getByteArrayOutputStream(ZipInputStream zis, int length) throws IOException {
        int nRead;
        if (length < 0) {
            length = 524288;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[length];
        while ((nRead = zis.read(buf, 0, length)) > -1) {
            baos.write(buf, 0, nRead);
        }
        return baos;
    }

    public static void dump(List items, PrintStream target) {
        target.println("\tCode\tClass\tClass");
        target.println("Nr\tsize\tsize\tfiles\tLocation");
        target.println("--------------------------------------------------------------------");
        for (int i = 0; i < items.size(); ++i) {
            Item item = (Item)items.get(i);
            target.println("" + (i + 1) + "\t" + item.ttlCodeSize + "\t" + item.ttlClassSize + "\t" + item.nClassFiles + "\t" + Codesize.stripFilename(item.location));
        }
    }

    public static void main(String[] args) {
        List items = Codesize.processCmdLine(args);
        if (items.size() == 0) {
            Codesize.help();
        } else {
            Codesize.dump(items, System.out);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Item
    implements Comparable {
        private File location;
        private int nClassFiles;
        private int ttlClassSize;
        private int ttlCodeSize;

        Item(File location, int nClassFiles, int ttlClassSize, int ttlCodeSize) {
            this.location = location;
            this.nClassFiles = nClassFiles;
            this.ttlClassSize = ttlClassSize;
            this.ttlCodeSize = ttlCodeSize;
        }

        public File getLocation() {
            return this.location;
        }

        public int getNClassFiles() {
            return this.nClassFiles;
        }

        public int getClassSize() {
            return this.ttlClassSize;
        }

        public int getCodeSize() {
            return this.ttlCodeSize;
        }

        public int compareTo(Object item) {
            return this.ttlCodeSize - ((Item)item).ttlCodeSize;
        }
    }
}

