/*
 * Decompiled with CFR 0.152.
 */
package rpc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jcifs.util.Hexdump;
import ndr.NdrBuffer;
import ndr.NetworkDataRepresentation;
import rpc.Connection;
import rpc.ConnectionOrientedPdu;
import rpc.Fragmentable;
import rpc.IntegrityException;
import rpc.RpcException;
import rpc.Security;
import rpc.Transport;
import rpc.core.AuthenticationVerifier;
import rpc.pdu.AlterContextPdu;
import rpc.pdu.AlterContextResponsePdu;
import rpc.pdu.Auth3Pdu;
import rpc.pdu.BindAcknowledgePdu;
import rpc.pdu.BindNoAcknowledgePdu;
import rpc.pdu.BindPdu;
import rpc.pdu.CancelCoPdu;
import rpc.pdu.FaultCoPdu;
import rpc.pdu.OrphanedPdu;
import rpc.pdu.RequestCoPdu;
import rpc.pdu.ResponseCoPdu;
import rpc.pdu.ShutdownPdu;

public class DefaultConnection
implements Connection {
    protected NetworkDataRepresentation ndr = new NetworkDataRepresentation();
    protected NdrBuffer transmitBuffer;
    protected NdrBuffer receiveBuffer;
    protected Security security;
    protected int contextId;
    private static final Logger logger = Logger.getLogger("org.jinterop");
    private boolean bytesRemainingInRecieveBuffer = false;

    public DefaultConnection() {
        this(7160, 7160);
    }

    public DefaultConnection(int transmitLength, int receiveLength) {
        this.transmitBuffer = new NdrBuffer(new byte[transmitLength], 0);
        this.receiveBuffer = new NdrBuffer(new byte[receiveLength], 0);
    }

    @Override
    public void transmit(ConnectionOrientedPdu pdu, Transport transport) throws IOException {
        if (!(pdu instanceof Fragmentable)) {
            this.transmitFragment(pdu, transport);
            return;
        }
        Iterator fragments = ((Fragmentable)((Object)pdu)).fragment(this.transmitBuffer.getCapacity());
        while (fragments.hasNext()) {
            this.transmitFragment((ConnectionOrientedPdu)fragments.next(), transport);
        }
    }

    @Override
    public ConnectionOrientedPdu receive(final Transport transport) throws IOException {
        ConnectionOrientedPdu fragment = this.receiveFragment(transport);
        if (!(fragment instanceof Fragmentable) || fragment.getFlag(2)) {
            return fragment;
        }
        return (ConnectionOrientedPdu)((Object)((Fragmentable)((Object)fragment)).assemble(new Iterator(fragment){
            ConnectionOrientedPdu currentFragment;
            private int i;
            {
                this.currentFragment = connectionOrientedPdu;
                this.i = 0;
            }

            @Override
            public boolean hasNext() {
                return this.currentFragment != null;
            }

            public Object next() {
                if (this.currentFragment == null) {
                    throw new NoSuchElementException();
                }
                try {
                    ConnectionOrientedPdu connectionOrientedPdu = this.currentFragment;
                    return connectionOrientedPdu;
                }
                finally {
                    if (this.currentFragment.getFlag(2)) {
                        this.currentFragment = null;
                    } else {
                        try {
                            if (logger.isLoggable(Level.FINEST)) {
                                logger.finest("[Fragmented Packet] [" + this.i++ + "] recieved , fragment decomposition is below:- ");
                            }
                            this.currentFragment = DefaultConnection.this.receiveFragment(transport);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            throw new IllegalStateException();
                        }
                    }
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }));
    }

    protected void transmitFragment(ConnectionOrientedPdu fragment, Transport transport) throws IOException {
        this.transmitBuffer.reset();
        fragment.encode(this.ndr, this.transmitBuffer);
        this.processOutgoing();
        if (logger.isLoggable(Level.FINEST)) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Hexdump.hexdump((PrintStream)new PrintStream(byteArrayOutputStream), (byte[])this.transmitBuffer.getBuffer(), (int)0, (int)this.transmitBuffer.length);
            logger.finest("[TRANSMIT BUFFER]:-\n" + byteArrayOutputStream.toString());
        }
        transport.send(this.transmitBuffer);
    }

    protected ConnectionOrientedPdu receiveFragment(Transport transport) throws IOException {
        int fragmentLength = -1;
        int type = -1;
        boolean read = true;
        if (this.bytesRemainingInRecieveBuffer) {
            while (this.receiveBuffer.length <= 10) {
                NdrBuffer tmpBuffer = new NdrBuffer(new byte[10], 0);
                transport.receive(tmpBuffer);
                System.arraycopy(tmpBuffer.buf, 0, this.receiveBuffer.buf, this.receiveBuffer.length, tmpBuffer.length);
                this.receiveBuffer.length += tmpBuffer.length;
            }
            read = false;
            this.bytesRemainingInRecieveBuffer = false;
        }
        if (read) {
            this.receiveBuffer.reset();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("\n Reading bytes from RecieveBuffer Socket...Current Capacity:- " + this.receiveBuffer.getCapacity());
            }
            transport.receive(this.receiveBuffer);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("[RECIEVER BUFFER] Full packet is dumped below...");
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                Hexdump.hexdump((PrintStream)new PrintStream(byteArrayOutputStream), (byte[])this.receiveBuffer.getBuffer(), (int)0, (int)this.receiveBuffer.length);
                logger.finest("\n" + byteArrayOutputStream.toString());
                logger.finest("\n Bytes read from RecieveBuffer Socket:- " + this.receiveBuffer.length);
            }
        }
        byte[] newbuffer = null;
        int counter = 0;
        int trimSize = -1;
        int lengthOfArrayTobeRead = this.receiveBuffer.length;
        if (this.receiveBuffer.length > 0) {
            ByteArrayOutputStream byteArrayOutputStream;
            this.receiveBuffer.setIndex(8);
            byte[] frag = new byte[2];
            this.receiveBuffer.readOctetArray(frag, 0, frag.length);
            fragmentLength = frag[0] & 0xFF | (frag[1] & 0xFF) << 8;
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("\n length of the fragment " + fragmentLength + "\n" + " size in bytes of the buffer [] " + this.receiveBuffer.buf.length);
            }
            if (fragmentLength < 0) {
                int h = 0;
                ++h;
                Hexdump.hexdump((PrintStream)System.out, (byte[])this.receiveBuffer.buf, (int)0, (int)this.receiveBuffer.buf.length);
            }
            newbuffer = new byte[fragmentLength];
            if (fragmentLength > this.receiveBuffer.length) {
                int remainingBytes = fragmentLength - this.receiveBuffer.length;
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("\n Some bytes from RecieveBuffer Socket have not been read: Remaining  " + remainingBytes);
                }
                while (fragmentLength > counter) {
                    System.arraycopy(this.receiveBuffer.buf, 0, newbuffer, counter, lengthOfArrayTobeRead);
                    if (fragmentLength != (counter += lengthOfArrayTobeRead)) {
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest("\n About to read more bytes from socket , current counter is: " + counter);
                        }
                        this.receiveBuffer.reset();
                        transport.receive(this.receiveBuffer);
                        if (fragmentLength - counter >= this.receiveBuffer.length) {
                            lengthOfArrayTobeRead = this.receiveBuffer.length;
                        } else {
                            lengthOfArrayTobeRead = fragmentLength - counter;
                            trimSize = this.receiveBuffer.length - lengthOfArrayTobeRead;
                        }
                        if (!logger.isLoggable(Level.FINEST)) continue;
                        logger.finest("\nlengthOfArrayTobeRead = " + lengthOfArrayTobeRead + "\n" + "trimSize = " + trimSize + "\n" + "RecieveBuffer current read size: " + this.receiveBuffer.length);
                        logger.finest("\n\n[RECIEVER BUFFER] and the read packet is dumped below...");
                        byteArrayOutputStream = new ByteArrayOutputStream();
                        Hexdump.hexdump((PrintStream)new PrintStream(byteArrayOutputStream), (byte[])this.receiveBuffer.getBuffer(), (int)0, (int)this.receiveBuffer.length);
                        logger.finest("\n" + byteArrayOutputStream.toString());
                        continue;
                    }
                    break;
                }
            } else {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("\nfragmentLength is less than  receiveBuffer.length");
                }
                System.arraycopy(this.receiveBuffer.buf, 0, newbuffer, 0, fragmentLength);
                trimSize = this.receiveBuffer.length - fragmentLength;
            }
            if (trimSize > 0) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("\ntrimSize = " + trimSize);
                }
                System.arraycopy(this.receiveBuffer.buf, this.receiveBuffer.length - trimSize, this.receiveBuffer.buf, 0, trimSize);
                this.receiveBuffer.length = trimSize;
                this.receiveBuffer.index = 0;
                this.receiveBuffer.start = 0;
                this.bytesRemainingInRecieveBuffer = true;
            }
            NdrBuffer bufferToBeUsed = new NdrBuffer(newbuffer, 0);
            bufferToBeUsed.length = newbuffer.length;
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("\nbufferToBeUsed Size = " + bufferToBeUsed.length);
                logger.finest("\n\n[bufferToBeUsed] packet is dumped below...");
                byteArrayOutputStream = new ByteArrayOutputStream();
                Hexdump.hexdump((PrintStream)new PrintStream(byteArrayOutputStream), (byte[])bufferToBeUsed.getBuffer(), (int)0, (int)bufferToBeUsed.length);
                logger.finest("\n" + byteArrayOutputStream.toString());
                logger.finest("\n*********************************************************************************");
            }
            this.processIncoming(bufferToBeUsed);
            bufferToBeUsed.setIndex(2);
            type = bufferToBeUsed.dec_ndr_small();
            ConnectionOrientedPdu pdu = null;
            switch (type) {
                case 14: {
                    pdu = new AlterContextPdu();
                    break;
                }
                case 15: {
                    pdu = new AlterContextResponsePdu();
                    break;
                }
                case 16: {
                    pdu = new Auth3Pdu();
                    break;
                }
                case 11: {
                    pdu = new BindPdu();
                    break;
                }
                case 12: {
                    pdu = new BindAcknowledgePdu();
                    break;
                }
                case 13: {
                    pdu = new BindNoAcknowledgePdu();
                    break;
                }
                case 18: {
                    pdu = new CancelCoPdu();
                    break;
                }
                case 3: {
                    pdu = new FaultCoPdu();
                    break;
                }
                case 19: {
                    pdu = new OrphanedPdu();
                    break;
                }
                case 0: {
                    pdu = new RequestCoPdu();
                    break;
                }
                case 2: {
                    pdu = new ResponseCoPdu();
                    break;
                }
                case 17: {
                    pdu = new ShutdownPdu();
                    break;
                }
                default: {
                    throw new IOException("Unknown PDU type: 0x" + Integer.toHexString(type));
                }
            }
            bufferToBeUsed.setIndex(0);
            pdu.decode(this.ndr, bufferToBeUsed);
            return pdu;
        }
        throw new IOException("Socket Closed");
    }

    private boolean isValidType(int type) {
        switch (type) {
            case 0: 
            case 2: 
            case 3: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return true;
            }
        }
        return false;
    }

    protected void processIncoming(NdrBuffer buffer) throws IOException {
        buffer.setIndex(2);
        boolean logMsg = true;
        switch (buffer.dec_ndr_small()) {
            case 12: {
                if (logMsg) {
                    logger.info("\n Recieved BIND_ACK");
                    logMsg = false;
                }
            }
            case 15: {
                if (logMsg) {
                    logger.info("\n Recieved ALTER_CTX_RESP");
                    logMsg = false;
                }
            }
            case 11: {
                if (logMsg) {
                    logger.info("\n Recieved BIND");
                    logMsg = false;
                }
            }
            case 14: {
                AuthenticationVerifier verifier;
                if (logMsg) {
                    logger.info("\n Recieved ALTER_CTX");
                    logMsg = false;
                }
                if ((verifier = this.detachAuthentication(buffer)) == null) break;
                this.incomingRebind(verifier);
                break;
            }
            case 3: {
                if (logMsg) {
                    logger.info("\n Recieved FAULT");
                    logMsg = false;
                }
            }
            case 18: {
                if (logMsg) {
                    logger.info("\n Recieved CANCEL");
                    logMsg = false;
                }
            }
            case 19: {
                if (logMsg) {
                    logger.info("\n Recieved ORPHANED");
                    logMsg = false;
                }
            }
            case 2: {
                if (logMsg) {
                    logger.info("\n Recieved RESPONSE");
                    logMsg = false;
                }
            }
            case 0: {
                if (logMsg) {
                    logger.info("\n Recieved REQUEST");
                    logMsg = false;
                }
                if (this.security != null) {
                    NetworkDataRepresentation ndr2 = new NetworkDataRepresentation();
                    ndr2.setBuffer(buffer);
                    this.verifyAndUnseal(ndr2);
                    break;
                }
                this.detachAuthentication(buffer);
                break;
            }
            case 16: {
                if (logMsg) {
                    logger.info("\n Recieved AUTH3");
                    logMsg = false;
                }
                this.incomingRebind(this.detachAuthentication2(buffer));
                break;
            }
            case 13: 
            case 17: {
                return;
            }
            default: {
                throw new RpcException("Invalid incoming PDU type.");
            }
        }
    }

    protected void processOutgoing() throws IOException {
        this.ndr.getBuffer().setIndex(2);
        boolean logMsg = true;
        switch (this.ndr.readUnsignedSmall()) {
            case 11: {
                if (logMsg) {
                    logger.info("\n Sending BIND");
                    logMsg = false;
                }
            }
            case 16: {
                if (logMsg) {
                    logger.info("\n Sending AUTH3");
                    logMsg = false;
                }
            }
            case 12: {
                if (logMsg) {
                    logger.info("\n Sending BIND_ACK");
                    logMsg = false;
                }
            }
            case 15: {
                AuthenticationVerifier verifier;
                if (logMsg) {
                    logger.info("\n Sending ALTER_CTX_RESP");
                    logMsg = false;
                }
                if ((verifier = this.outgoingRebind()) == null) break;
                this.attachAuthentication(verifier);
                break;
            }
            case 14: {
                if (!logMsg) break;
                logger.info("\n Sending ALTER_CTX");
                logMsg = false;
                break;
            }
            case 0: {
                if (logMsg) {
                    logger.info("\n Sending REQUEST");
                    logMsg = false;
                }
            }
            case 18: {
                if (logMsg) {
                    logger.info("\n Sending CANCEL");
                    logMsg = false;
                }
            }
            case 19: {
                if (logMsg) {
                    logger.info("\n Sending ORPHANED");
                    logMsg = false;
                }
            }
            case 3: {
                if (logMsg) {
                    logger.info("\n Sending FAULT");
                    logMsg = false;
                }
            }
            case 2: {
                if (logMsg) {
                    logger.info("\n Sending RESPONSE");
                    logMsg = false;
                }
                if (this.security == null) break;
                this.signAndSeal(this.ndr);
                break;
            }
            case 13: 
            case 17: {
                return;
            }
            default: {
                throw new RpcException("Invalid outgoing PDU type.");
            }
        }
    }

    protected void setSecurity(Security security) {
        this.security = security;
    }

    private void attachAuthentication(AuthenticationVerifier verifier) throws IOException {
        try {
            NdrBuffer buffer = this.ndr.getBuffer();
            int length = buffer.getLength();
            buffer.setIndex(length);
            verifier.encode(this.ndr, buffer);
            length = buffer.getLength();
            buffer.setIndex(8);
            this.ndr.writeUnsignedShort(length);
            this.ndr.writeUnsignedShort(verifier.body.length);
        }
        catch (Exception ex) {
            throw new IOException("Error attaching authentication to PDU: " + ex.getMessage());
        }
    }

    private AuthenticationVerifier detachAuthentication2(NdrBuffer buffer) throws IOException {
        try {
            buffer.setIndex(10);
            int length = buffer.dec_ndr_short();
            int index = 20;
            buffer.setIndex(index);
            AuthenticationVerifier verifier = new AuthenticationVerifier(length);
            verifier.decode(this.ndr, buffer);
            buffer.setIndex(index + 2);
            length = index - buffer.dec_ndr_small();
            buffer.setIndex(8);
            buffer.enc_ndr_short(length);
            buffer.enc_ndr_short(0);
            buffer.setIndex(length);
            return verifier;
        }
        catch (Exception ex) {
            throw new IOException("Error stripping authentication from PDU: " + ex);
        }
    }

    private AuthenticationVerifier detachAuthentication(NdrBuffer buffer) throws IOException {
        int length;
        block5: {
            try {
                buffer.setIndex(10);
                length = buffer.dec_ndr_short();
                if (length != 0) break block5;
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("\nIn [detachAuthentication] No authn info present...");
                }
                return null;
            }
            catch (Exception ex) {
                throw new IOException("Error stripping authentication from PDU: " + ex);
            }
        }
        int index = buffer.getLength() - length - 8;
        buffer.setIndex(index);
        AuthenticationVerifier verifier = new AuthenticationVerifier(length);
        verifier.decode(this.ndr, buffer);
        buffer.setIndex(index + 2);
        length = index - buffer.dec_ndr_small();
        buffer.setIndex(8);
        buffer.enc_ndr_short(length);
        buffer.enc_ndr_short(0);
        buffer.setIndex(length);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("\nIn [detachAuthentication] (after stripping authn info) setting new FRAG_LENGTH_OFFSET for the packet as = " + length);
        }
        return verifier;
    }

    private void signAndSeal(NetworkDataRepresentation ndr) throws IOException {
        int protectionLevel = this.security.getProtectionLevel();
        if (protectionLevel < 5) {
            return;
        }
        int verifierLength = this.security.getVerifierLength();
        AuthenticationVerifier verifier = new AuthenticationVerifier(this.security.getAuthenticationService(), protectionLevel, this.contextId, verifierLength);
        NdrBuffer buffer = ndr.getBuffer();
        int length = buffer.getLength();
        buffer.setIndex(length);
        verifier.encode(ndr, buffer);
        length = buffer.getLength();
        buffer.setIndex(8);
        ndr.writeUnsignedShort(length);
        ndr.writeUnsignedShort(verifierLength);
        int verifierIndex = length - verifierLength;
        length -= verifierLength + 8;
        int index = 16;
        buffer.setIndex(2);
        switch (ndr.readUnsignedSmall()) {
            case 0: {
                index += 8;
                buffer.setIndex(3);
                if ((ndr.readUnsignedSmall() & 0x80) == 0) break;
                index += 16;
                break;
            }
            case 3: {
                index += 16;
                break;
            }
            case 2: {
                index += 8;
                break;
            }
            case 18: 
            case 19: {
                index = length;
                break;
            }
            default: {
                throw new IntegrityException("Not an authenticated PDU type.");
            }
        }
        boolean isFragmented = true;
        buffer.setIndex(3);
        int flags = ndr.readUnsignedSmall();
        if ((flags & 1) == 1 && (flags & 2) == 2) {
            isFragmented = false;
        }
        this.security.processOutgoing(ndr, index, length -= index, verifierIndex, isFragmented);
    }

    private void verifyAndUnseal(NetworkDataRepresentation ndr) throws IOException {
        NdrBuffer buffer = ndr.getBuffer();
        buffer.setIndex(10);
        int verifierLength = ndr.readUnsignedShort();
        if (verifierLength <= 0) {
            return;
        }
        int verifierIndex = buffer.getLength() - verifierLength;
        int length = verifierIndex - 8;
        int index = 16;
        buffer.setIndex(2);
        switch (ndr.readUnsignedSmall()) {
            case 0: {
                index += 8;
                buffer.setIndex(3);
                if ((ndr.readUnsignedSmall() & 0x80) == 0) break;
                index += 16;
                break;
            }
            case 3: {
                index += 16;
                break;
            }
            case 2: {
                index += 8;
                break;
            }
            case 18: 
            case 19: {
                index = length;
                break;
            }
            default: {
                throw new IntegrityException("Not an authenticated PDU type.");
            }
        }
        length -= index;
        boolean isFragmented = true;
        buffer.setIndex(3);
        int flags = ndr.readUnsignedSmall();
        if ((flags & 1) == 1 && (flags & 2) == 2) {
            isFragmented = false;
        }
        this.security.processIncoming(ndr, index, length, verifierIndex, isFragmented);
        buffer.setIndex(verifierIndex - 6);
        length = verifierIndex - ndr.readUnsignedSmall() - 8;
        buffer.setIndex(8);
        ndr.writeUnsignedShort(length);
        ndr.writeUnsignedShort(0);
        buffer.length = length;
    }

    protected void incomingRebind(AuthenticationVerifier verifier) throws IOException {
    }

    protected AuthenticationVerifier outgoingRebind() throws IOException {
        return null;
    }
}

