/*
 * Decompiled with CFR 0.152.
 */
package rpc;

import ndr.Format;
import ndr.NdrBuffer;
import ndr.NdrObject;
import ndr.NetworkDataRepresentation;
import rpc.ProtocolDataUnit;

public abstract class ConnectionOrientedPdu
extends NdrObject
implements ProtocolDataUnit {
    public static final int CONNECTION_ORIENTED_MAJOR_VERSION = 5;
    public static final int MUST_RECEIVE_FRAGMENT_SIZE = 7160;
    public static final int PFC_FIRST_FRAG = 1;
    public static final int PFC_LAST_FRAG = 2;
    public static final int PFC_PENDING_CANCEL = 4;
    public static final int PFC_CONC_MPX = 16;
    public static final int PFC_DID_NOT_EXECUTE = 32;
    public static final int PFC_MAYBE = 64;
    public static final int PFC_OBJECT_UUID = 128;
    public static final int MAJOR_VERSION_OFFSET = 0;
    public static final int MINOR_VERSION_OFFSET = 1;
    public static final int TYPE_OFFSET = 2;
    public static final int FLAGS_OFFSET = 3;
    public static final int DATA_REPRESENTATION_OFFSET = 4;
    public static final int FRAG_LENGTH_OFFSET = 8;
    public static final int AUTH_LENGTH_OFFSET = 10;
    public static final int CALL_ID_OFFSET = 12;
    public static final int HEADER_LENGTH = 16;
    private int minorVersion = 0;
    private int flags = 3;
    protected static int callIdCounter = 0;
    private int callId = callIdCounter;
    private boolean useCallIdCounter = true;
    private int fragLength = 0;
    private int authLength = 0;
    private Format format;

    @Override
    public int getMajorVersion() {
        return 5;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int minorVersion) {
        this.minorVersion = minorVersion;
    }

    @Override
    public Format getFormat() {
        return this.format != null ? this.format : (this.format = Format.DEFAULT_FORMAT);
    }

    @Override
    public void setFormat(Format format) {
        this.format = format;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public boolean getFlag(int flag) {
        return (this.getFlags() & flag) != 0;
    }

    public void setFlag(int flag, boolean value) {
        this.setFlags(value ? this.getFlags() | flag : this.getFlags() & ~flag);
    }

    public int getCallId() {
        return this.callId;
    }

    public void setCallId(int callId) {
        this.useCallIdCounter = false;
        this.callId = callId;
    }

    public int getFragmentLength() {
        return this.fragLength;
    }

    protected void setFragmentLength(int fragLength) {
        this.fragLength = fragLength;
    }

    public int getAuthenticatorLength() {
        return this.authLength;
    }

    protected void setAuthenticatorLength(int authLength) {
        this.authLength = authLength;
    }

    @Override
    public void decode(NetworkDataRepresentation ndr, NdrBuffer src) {
        ndr.setBuffer(src);
        this.readPdu(ndr);
    }

    @Override
    public void encode(NetworkDataRepresentation ndr, NdrBuffer dst) {
        ndr.setBuffer(dst);
        ndr.setFormat(this.getFormat());
        this.writePdu(ndr);
        NdrBuffer buffer = ndr.getBuffer();
        int length = buffer.getLength();
        this.setFragmentLength(length);
        buffer.setIndex(8);
        ndr.writeUnsignedShort(length);
        ndr.writeUnsignedShort(this.getAuthenticatorLength());
        buffer.setIndex(length);
    }

    protected void readPdu(NetworkDataRepresentation ndr) {
        this.readHeader(ndr);
        this.readBody(ndr);
    }

    protected void writePdu(NetworkDataRepresentation ndr) {
        this.writeHeader(ndr);
        this.writeBody(ndr);
    }

    protected void readHeader(NetworkDataRepresentation ndr) {
        if (ndr.readUnsignedSmall() != 5) {
            throw new IllegalStateException("Version mismatch.");
        }
        this.setMinorVersion(ndr.readUnsignedSmall());
        if (this.getType() != ndr.readUnsignedSmall()) {
            throw new IllegalArgumentException("Incorrect PDU type.");
        }
        this.setFlags(ndr.readUnsignedSmall());
        Format format = ndr.readFormat(false);
        this.setFormat(format);
        ndr.setFormat(format);
        this.setFragmentLength(ndr.readUnsignedShort());
        this.setAuthenticatorLength(ndr.readUnsignedShort());
        this.callId = ndr.readUnsignedLong();
    }

    protected void writeHeader(NetworkDataRepresentation ndr) {
        int n;
        ndr.writeUnsignedSmall((short)this.getMajorVersion());
        ndr.writeUnsignedSmall((short)this.getMinorVersion());
        ndr.writeUnsignedSmall((short)this.getType());
        ndr.writeUnsignedSmall((short)this.getFlags());
        ndr.writeFormat(false);
        ndr.writeUnsignedShort(0);
        ndr.writeUnsignedShort(0);
        if (this.useCallIdCounter) {
            int n2 = callIdCounter;
            n = n2;
            callIdCounter = n2 + 1;
        } else {
            n = this.callId;
        }
        ndr.writeUnsignedLong(n);
    }

    protected void readBody(NetworkDataRepresentation ndr) {
    }

    protected void writeBody(NetworkDataRepresentation ndr) {
    }

    @Override
    public abstract int getType();
}

