/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.transport.niosupport;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Level;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.transport.niosupport.ChannelListener;
import org.jinterop.dcom.transport.niosupport.ChannelWrapper;
import org.jinterop.dcom.transport.niosupport.SelectorManager;

public final class ChannelWrapperImpl
implements ChannelWrapper {
    private final SelectorManager selectorManager;
    private final SelectableChannel selectableChannel;
    private final ChannelListener channelListener;

    ChannelWrapperImpl(SelectorManager selectorManager, SelectableChannel selectableChannel, ChannelListener channelListener) throws IOException {
        this.selectorManager = selectorManager;
        this.selectableChannel = selectableChannel;
        this.channelListener = channelListener;
        selectorManager.registerChannel(selectableChannel, channelListener);
    }

    private ChannelListener getChannelListener() {
        return this.channelListener;
    }

    @Override
    public boolean isConnected() {
        return ((SocketChannel)this.selectableChannel).isConnected();
    }

    @Override
    public boolean isOpen() {
        return this.selectableChannel.isOpen();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return ((SocketChannel)this.selectableChannel).socket().getRemoteSocketAddress();
    }

    @Override
    public int read(ByteBuffer buffer) throws IOException {
        return ((ReadableByteChannel)((Object)this.selectableChannel)).read(buffer);
    }

    @Override
    public void registerForRead() throws IOException {
        this.selectorManager.setReadInterest(this.selectableChannel);
    }

    @Override
    public void unregisterForRead() throws IOException {
        this.selectorManager.removeReadInterest(this.selectableChannel);
    }

    private int write(ByteBuffer buffer) throws IOException {
        return ((WritableByteChannel)((Object)this.selectableChannel)).write(buffer);
    }

    @Override
    public void writeAll(ByteBuffer buffer) throws IOException {
        while (buffer.hasRemaining()) {
            int bytesWritten = this.write(buffer);
            if (!JISystem.getLogger().isLoggable(Level.FINE)) continue;
            JISystem.getLogger().fine(this + " bytes written " + bytesWritten);
        }
    }

    @Override
    public void close() throws IOException {
        this.selectableChannel.close();
    }

    public String toString() {
        return "Channel to " + this.getRemoteSocketAddress();
    }
}

