/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.transport;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import rpc.ConnectionOrientedPdu;
import rpc.core.PresentationContext;
import rpc.core.PresentationResult;
import rpc.core.PresentationSyntax;
import rpc.pdu.AlterContextPdu;
import rpc.pdu.AlterContextResponsePdu;
import rpc.pdu.BindAcknowledgePdu;
import rpc.pdu.BindPdu;
import rpc.security.ntlm.NtlmConnectionContext;

public final class JIComRuntimeNTLMConnectionContext
extends NtlmConnectionContext {
    private static final String IID = "IID";
    private static final String IID2 = "IID2";
    private boolean established = false;
    private Properties properties = null;
    private List listOfInterfacesSupported = Collections.synchronizedList(new ArrayList());

    public ConnectionOrientedPdu init(PresentationContext context, Properties properties) throws IOException {
        super.init2(context, properties);
        this.properties = properties;
        this.listOfInterfacesSupported.add(properties.getProperty(IID).toUpperCase());
        this.listOfInterfacesSupported.add(String.valueOf(properties.getProperty(IID2).toUpperCase()) + ":0.0");
        this.updateListOfInterfacesSupported2((List)properties.get("LISTOFSUPPORTEDINTERFACES"));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionOrientedPdu accept(ConnectionOrientedPdu pdu) throws IOException {
        ConnectionOrientedPdu reply = null;
        switch (pdu.getType()) {
            case 11: {
                this.established = true;
                PresentationContext[] presentationContexts = ((BindPdu)pdu).getContextList();
                reply = new BindAcknowledgePdu();
                PresentationResult[] result = new PresentationResult[1];
                int i = 0;
                while (i < presentationContexts.length) {
                    PresentationContext presentationContext = presentationContexts[i];
                    boolean contains = false;
                    List list = this.listOfInterfacesSupported;
                    synchronized (list) {
                        contains = this.listOfInterfacesSupported.contains(presentationContext.abstractSyntax.toString().toUpperCase());
                    }
                    if (!contains) {
                        result[0] = new PresentationResult(2, 1, new PresentationSyntax("00000000-0000-0000-0000-000000000000:0.0"));
                        ((BindAcknowledgePdu)reply).setResultList(result);
                        break;
                    }
                    ++i;
                }
                if (((BindAcknowledgePdu)reply).getResultList() == null) {
                    result[0] = new PresentationResult();
                    ((BindAcknowledgePdu)reply).setAssociationGroupId(new Object().hashCode());
                    ((BindAcknowledgePdu)reply).setResultList(result);
                }
                ((BindAcknowledgePdu)reply).setCallId(pdu.getCallId());
                break;
            }
            case 14: {
                this.established = true;
                PresentationContext[] presentationContexts = ((AlterContextPdu)pdu).getContextList();
                reply = new AlterContextResponsePdu();
                PresentationResult[] result = new PresentationResult[1];
                int i = 0;
                while (i < presentationContexts.length) {
                    PresentationContext presentationContext = presentationContexts[i];
                    boolean contains = false;
                    List list = this.listOfInterfacesSupported;
                    synchronized (list) {
                        contains = this.listOfInterfacesSupported.contains(presentationContext.abstractSyntax.toString().toUpperCase());
                    }
                    if (!contains) {
                        result[0] = new PresentationResult(2, 1, new PresentationSyntax("00000000-0000-0000-0000-000000000000:0.0"));
                        ((AlterContextResponsePdu)reply).setResultList(result);
                        break;
                    }
                    ++i;
                }
                if (((AlterContextResponsePdu)reply).getResultList() == null) {
                    result[0] = new PresentationResult();
                    ((AlterContextResponsePdu)reply).setAssociationGroupId(new Object().hashCode());
                    ((AlterContextResponsePdu)reply).setResultList(result);
                }
                ((AlterContextResponsePdu)reply).setCallId(pdu.getCallId());
                break;
            }
            default: {
                reply = super.accept(reply);
            }
        }
        return reply;
    }

    public boolean isEstablished() {
        return super.isEstablished() | this.established;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateListOfInterfacesSupported(List newList) {
        List list = this.listOfInterfacesSupported;
        synchronized (list) {
            this.listOfInterfacesSupported.addAll(newList);
        }
    }

    void updateListOfInterfacesSupported2(List newList) {
        int i = 0;
        while (i < newList.size()) {
            this.listOfInterfacesSupported.add(newList.get(i) + ":0.0");
            ++i;
        }
    }
}

