/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import ndr.NdrBuffer;
import ndr.NdrException;
import ndr.NdrObject;
import ndr.NetworkDataRepresentation;
import org.jinterop.dcom.common.IJICOMRuntimeWorker;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.common.JIRuntimeException;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.JIArray;
import org.jinterop.dcom.core.JICallBuilder;
import org.jinterop.dcom.core.JIComOxidDetails;
import org.jinterop.dcom.core.JIComOxidRuntime;
import org.jinterop.dcom.core.JILocalCoClass;
import org.jinterop.dcom.core.JIMarshalUnMarshalHelper;
import org.jinterop.dcom.core.JIOrpcThat;
import org.jinterop.dcom.core.JIOrpcThis;
import org.jinterop.dcom.core.JIPointer;
import org.jinterop.dcom.core.JIStdObjRef;
import org.jinterop.dcom.core.JIString;
import org.jinterop.dcom.core.JIStruct;
import org.jinterop.dcom.core.JIVariant;

class RemUnknownObject
extends NdrObject
implements IJICOMRuntimeWorker {
    private int opnum = -1;
    private NdrBuffer buffer = null;
    private JILocalCoClass component = null;
    private rpc.core.UUID objectId = null;
    private final String selfIPID;
    private String currentIID = null;
    private List listOfIIDsQIed = new ArrayList();
    private static final JIStruct remInterfaceRef = new JIStruct();
    private static final JIArray remInterfaceRefArray;
    private Map mapOfIpidsVsRef = new HashMap();
    private boolean workerOver = false;

    static {
        try {
            remInterfaceRef.addMember(rpc.core.UUID.class);
            remInterfaceRef.addMember(Integer.class);
            remInterfaceRef.addMember(Integer.class);
        }
        catch (JIException shouldnothappen) {
            JISystem.getLogger().throwing("RemUnknownObject", "Static Initialiser", shouldnothappen);
        }
        remInterfaceRefArray = new JIArray(remInterfaceRef, null, 1, true);
    }

    RemUnknownObject(String ipidOfme, String ipidOfComponent) {
        this.selfIPID = ipidOfme;
        this.mapOfIpidsVsRef.put(ipidOfComponent.toUpperCase(), new Integer(5));
    }

    @Override
    public List getQIedIIDs() {
        return this.listOfIIDsQIed;
    }

    @Override
    public boolean isResolver() {
        return false;
    }

    @Override
    public void setOpnum(int opnum) {
        this.opnum = opnum;
    }

    public int getOpnum() {
        return this.opnum;
    }

    public void write(NetworkDataRepresentation ndr) {
        ndr.setBuffer(this.buffer);
    }

    public void read(NetworkDataRepresentation ndr) {
        block32: {
            String ipid;
            block31: {
                ipid = this.objectId.toString();
                if (!this.selfIPID.equalsIgnoreCase(ipid)) break block31;
                switch (this.opnum) {
                    case 3: {
                        this.buffer = this.QueryInterface(ndr);
                        break block32;
                    }
                    case 4: {
                        JIOrpcThis.decode(ndr);
                        int length = ndr.readUnsignedShort();
                        int[] retvals = new int[length];
                        JIArray array = (JIArray)JIMarshalUnMarshalHelper.deSerialize(ndr, remInterfaceRefArray, new ArrayList(), 8, new HashMap());
                        JIStruct[] structs = (JIStruct[])array.getArrayInstance();
                        int i = 0;
                        while (i < length) {
                            String ipidref = ((rpc.core.UUID)structs[i].getMember(0)).toString().toUpperCase();
                            int publicRefs = (Integer)structs[i].getMember(1);
                            int privateRefs = (Integer)structs[i].getMember(2);
                            if (!this.mapOfIpidsVsRef.containsKey(ipidref)) {
                                retvals[i] = -2147483645;
                            } else {
                                retvals[i] = 1;
                                int total = (Integer)this.mapOfIpidsVsRef.get(ipidref) + publicRefs + privateRefs;
                                this.mapOfIpidsVsRef.put(ipidref, new Integer(total));
                            }
                            ++i;
                        }
                        this.buffer = new NdrBuffer(new byte[length * 4 + 16], 0);
                        NetworkDataRepresentation ndr2 = new NetworkDataRepresentation();
                        ndr2.setBuffer(this.buffer);
                        JIOrpcThat.encode(ndr2);
                        int i2 = 0;
                        while (i2 < length) {
                            this.buffer.enc_ndr_long(retvals[i2]);
                            ++i2;
                        }
                        this.buffer.enc_ndr_long(0);
                        this.buffer.enc_ndr_long(0);
                        break block32;
                    }
                    case 5: {
                        JIOrpcThis.decode(ndr);
                        int length = ndr.readUnsignedShort();
                        JIArray array = (JIArray)JIMarshalUnMarshalHelper.deSerialize(ndr, remInterfaceRefArray, new ArrayList(), 8, new HashMap());
                        JIStruct[] structs = (JIStruct[])array.getArrayInstance();
                        int i = 0;
                        while (i < length) {
                            String ipidref = ((rpc.core.UUID)structs[i].getMember(0)).toString().toUpperCase();
                            int publicRefs = (Integer)structs[i].getMember(1);
                            int privateRefs = (Integer)structs[i].getMember(2);
                            if (this.mapOfIpidsVsRef.containsKey(ipidref)) {
                                int total = (Integer)this.mapOfIpidsVsRef.get(ipidref) - publicRefs - privateRefs;
                                if (total == 0) {
                                    this.mapOfIpidsVsRef.remove(ipidref);
                                } else {
                                    this.mapOfIpidsVsRef.put(ipidref, new Integer(total));
                                }
                            }
                            ++i;
                        }
                        if (this.mapOfIpidsVsRef.isEmpty()) {
                            this.workerOver = true;
                        }
                        this.buffer = new NdrBuffer(new byte[32], 0);
                        NetworkDataRepresentation ndr2 = new NetworkDataRepresentation();
                        ndr2.setBuffer(this.buffer);
                        JIOrpcThat.encode(ndr2);
                        this.buffer.enc_ndr_long(0);
                        this.buffer.enc_ndr_long(0);
                        break block32;
                    }
                    default: {
                        throw new JIRuntimeException(-1073610706);
                    }
                }
            }
            if (this.component == null) {
                JISystem.getLogger().severe("JIComOxidRuntimeHelper RemUnknownObject read(): component is null , opnum is " + this.opnum + " , IPID is " + ipid + " , selfIpid is " + this.selfIPID);
            }
            byte[] b = null;
            Object[] result = null;
            NetworkDataRepresentation ndr2 = new NetworkDataRepresentation();
            int hresult = 0;
            Object[] retArray = null;
            try {
                result = this.component.invokeMethod(ipid, this.opnum, ndr);
            }
            catch (JIException e) {
                hresult = e.getErrorCode();
                JISystem.getLogger().severe("Exception occured: " + e.getErrorCode());
                JISystem.getLogger().throwing("RemUnknownObject", "read", e);
            }
            if (this.component.getInterfaceDefinitionFromIPID(ipid).isDispInterface() && this.opnum == 6) {
                Object[] result2 = result;
                result = new Object[4];
                JIStruct excepInfo = new JIStruct();
                try {
                    excepInfo.addMember(new Short(0));
                    excepInfo.addMember(new Short(0));
                    excepInfo.addMember(new JIString(""));
                    excepInfo.addMember(new JIString(""));
                    excepInfo.addMember(new JIString(""));
                    excepInfo.addMember(new Integer(0));
                    excepInfo.addMember(new JIPointer(null, true));
                    excepInfo.addMember(new JIPointer(null, true));
                    excepInfo.addMember(new Integer(0));
                }
                catch (JIException e) {
                    e.printStackTrace();
                }
                if (result2 == null) {
                    result[0] = JIVariant.EMPTY();
                } else {
                    JIVariant variant = (JIVariant)result2[0];
                    try {
                        if (variant.isByRefFlagSet()) {
                            result[0] = JIVariant.EMPTY();
                            result[3] = new JIArray(new JIVariant[]{variant}, true);
                        } else {
                            result[0] = result2[0];
                            result[3] = new Integer(0);
                        }
                    }
                    catch (JIException e) {
                        throw new JIRuntimeException(e.getErrorCode());
                    }
                }
                result[1] = excepInfo;
                result[2] = new Integer(0);
                retArray = result;
            }
            this.buffer = new NdrBuffer(b, 0);
            ndr2.setBuffer(this.buffer);
            JICallBuilder callObject = new JICallBuilder();
            callObject.attachSession(this.component.getSession());
            if (result != null) {
                if (retArray != null) {
                    int i = 0;
                    while (i < retArray.length) {
                        callObject.addInParamAsObject(retArray[i], 0);
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < result.length) {
                        callObject.addInParamAsObject(result[i], 0);
                        ++i;
                    }
                }
            }
            callObject.write2(ndr2);
            JIMarshalUnMarshalHelper.serialize(ndr2, Integer.class, new Integer(hresult), null, 0);
        }
    }

    private NdrBuffer QueryInterface(NetworkDataRepresentation ndr) {
        JIComOxidDetails details;
        if (JISystem.getLogger().isLoggable(Level.FINEST)) {
            JISystem.getLogger().finest("Within RemUnknownObject: QueryInterface");
            JISystem.getLogger().finest("RemUnknownObject: [QI] Before call terminated listOfIIDsQIed are: " + this.listOfIIDsQIed);
        }
        JIOrpcThis.decode(ndr);
        rpc.core.UUID ipid = new rpc.core.UUID();
        try {
            ipid.decode(ndr, ndr.getBuffer());
        }
        catch (NdrException e) {
            JISystem.getLogger().throwing("JIComOxidRuntimeHelper", "QueryInterface", e);
        }
        if (JISystem.getLogger().isLoggable(Level.FINEST)) {
            JISystem.getLogger().finest("RemUnknownObject: [QI] IPID is " + ipid);
        }
        if ((details = JIComOxidRuntime.getComponentFromIPID(ipid.toString())) == null) {
            throw new JIRuntimeException(-2147022986);
        }
        JILocalCoClass component = details.getReferent();
        if (JISystem.getLogger().isLoggable(Level.FINEST)) {
            JISystem.getLogger().finest("RemUnknownObject: [QI] JIJavcCoClass is " + component.getCoClassIID());
        }
        ((Integer)JIMarshalUnMarshalHelper.deSerialize(ndr, Integer.class, null, 0, null)).intValue();
        int length = ((Short)JIMarshalUnMarshalHelper.deSerialize(ndr, Short.class, null, 0, null)).intValue();
        JIArray array = (JIArray)JIMarshalUnMarshalHelper.deSerialize(ndr, new JIArray(rpc.core.UUID.class, null, 1, true), null, 8, null);
        byte[] b = new byte[16 + length * 48 + 16];
        NdrBuffer buffer = new NdrBuffer(b, 0);
        NetworkDataRepresentation ndr2 = new NetworkDataRepresentation();
        ndr2.setBuffer(buffer);
        JIOrpcThat.encode(ndr2);
        JIMarshalUnMarshalHelper.serialize(ndr2, Integer.class, new Integer(new Object().hashCode()), null, 0);
        JIMarshalUnMarshalHelper.serialize(ndr2, Integer.class, new Integer(length), null, 0);
        Object[] arrayOfUUIDs = (Object[])array.getArrayInstance();
        int i = 0;
        while (i < arrayOfUUIDs.length) {
            String iidtemp;
            rpc.core.UUID iid = (rpc.core.UUID)arrayOfUUIDs[i];
            if (JISystem.getLogger().isLoggable(Level.FINEST)) {
                JISystem.getLogger().finest("RemUnknownObject: [QI] Array iid[" + i + "] is " + iid);
            }
            try {
                int hresult = 0;
                String ipid2 = UUID.randomUUID().toString();
                if (!component.isPresent(iid.toString())) {
                    hresult = -2147467262;
                    ipid2 = UUID.fromString("00000000000000000000000000000000").toString();
                } else {
                    String tmpIpid = null;
                    try {
                        tmpIpid = component.getIpidFromIID(iid.toString());
                    }
                    catch (Exception e) {
                        JISystem.getLogger().throwing("JIComOxidRuntimeHelper", "QueryInterface", e);
                    }
                    if (tmpIpid == null) {
                        if (JISystem.getLogger().isLoggable(Level.FINEST)) {
                            JISystem.getLogger().finest("RemUnknownObject: [QI] tmpIpid is null for iid " + iid);
                        }
                        component.exportInstance(iid.toString(), ipid2);
                    } else {
                        if (JISystem.getLogger().isLoggable(Level.FINEST)) {
                            JISystem.getLogger().finest("RemUnknownObject: [QI] tmpIpid is NOT null for iid " + iid + " and ipid sent back is " + ipid2);
                        }
                        ipid2 = tmpIpid;
                    }
                }
                JIMarshalUnMarshalHelper.serialize(ndr2, Integer.class, new Integer(hresult), null, 0);
                JIMarshalUnMarshalHelper.serialize(ndr2, Integer.class, new Integer(-858993460), null, 0);
                JIStdObjRef objRef = null;
                objRef = hresult == 0 ? new JIStdObjRef(ipid2, details.getOxid(), details.getOid()) : new JIStdObjRef(ipid2);
                objRef.encode(ndr2);
                if (hresult == 0) {
                    this.mapOfIpidsVsRef.put(ipid2.toUpperCase(), new Integer(objRef.getPublicRefs()));
                }
                if (JISystem.getLogger().isLoggable(Level.FINEST)) {
                    JISystem.getLogger().finest("RemUnknownObject: [QI] for which the stdObjRef is " + objRef);
                }
            }
            catch (IllegalAccessException e) {
                JISystem.getLogger().throwing("JIComOxidRuntimeHelper", "QueryInterface", e);
            }
            catch (InstantiationException e) {
                JISystem.getLogger().throwing("JIComOxidRuntimeHelper", "QueryInterface", e);
            }
            if (!this.listOfIIDsQIed.contains(iidtemp = String.valueOf(iid.toString().toUpperCase()) + ":0.0")) {
                this.listOfIIDsQIed.add(iidtemp);
            }
            ++i;
        }
        if (JISystem.getLogger().isLoggable(Level.FINEST)) {
            JISystem.getLogger().finest("RemUnknownObject: [QI] After call terminated listOfIIDsQIed are: " + this.listOfIIDsQIed);
        }
        return buffer;
    }

    @Override
    public void setCurrentObjectID(rpc.core.UUID objectId) {
        this.objectId = objectId;
        this.component = JIComOxidRuntime.getJavaComponentFromIPID(objectId.toString());
    }

    @Override
    public rpc.core.UUID getCurrentObjectID() {
        return this.objectId;
    }

    @Override
    public void setCurrentIID(String iid) {
        this.currentIID = iid;
    }

    @Override
    public boolean workerOver() {
        return this.workerOver;
    }
}

