/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import org.jinterop.dcom.core.JILocalParamsDescriptor;

public final class JILocalMethodDescriptor {
    private String methodName = null;
    private int methodNum = -1;
    private int dispId = -1;
    private Class[] inparametersAsClass = new Class[0];
    private JILocalParamsDescriptor parameters = null;

    public JILocalMethodDescriptor(String methodName, JILocalParamsDescriptor parameters) {
        this.methodName = methodName;
        this.setParameterObject(parameters);
    }

    public JILocalMethodDescriptor(String methodName, int dispId, JILocalParamsDescriptor parameters) {
        this.methodName = methodName;
        this.dispId = dispId;
        this.setParameterObject(parameters);
    }

    void setMethodNum(int methodNum) {
        this.methodNum = methodNum;
    }

    private void setParameterObject(JILocalParamsDescriptor parameters) {
        if (parameters == null) {
            return;
        }
        this.parameters = parameters;
        Object[] params = parameters.getInParams();
        this.inparametersAsClass = new Class[params.length];
        int i = 0;
        while (i < params.length) {
            Object obj = params[i];
            if (obj instanceof Class) {
                Class<Object> c = (Class<Boolean>)obj;
                if (c.equals(Boolean.class)) {
                    c = Boolean.TYPE;
                } else if (c.equals(Character.class)) {
                    c = Character.TYPE;
                } else if (c.equals(Byte.class)) {
                    c = Byte.TYPE;
                } else if (c.equals(Short.class)) {
                    c = Short.TYPE;
                } else if (c.equals(Integer.class)) {
                    c = Integer.TYPE;
                } else if (c.equals(Long.class)) {
                    c = Long.TYPE;
                } else if (c.equals(Float.class)) {
                    c = Float.TYPE;
                } else if (c.equals(Double.class)) {
                    c = Double.TYPE;
                } else if (c.equals(Void.class)) {
                    c = Void.TYPE;
                }
                this.inparametersAsClass[i] = c;
            } else {
                this.inparametersAsClass[i] = obj.getClass();
            }
            ++i;
        }
    }

    public String getMethodName() {
        return this.methodName;
    }

    public int getMethodNum() {
        return this.methodNum;
    }

    public int getMethodDispID() {
        return this.dispId;
    }

    public JILocalParamsDescriptor getParameterObject() {
        return this.parameters;
    }

    Class[] getInparametersAsClass() {
        return this.inparametersAsClass;
    }
}

