/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.desktop.internal.impl;

import java.io.IOException;
import java.util.Iterator;
import org.jdesktop.jdic.desktop.Message;
import org.jdesktop.jdic.desktop.internal.LaunchFailedException;
import org.jdesktop.jdic.desktop.internal.MailerService;
import org.jdesktop.jdic.desktop.internal.impl.URLUTF8Encoder;

public class MacMailerService
implements MailerService {
    public void open(Message message) throws LaunchFailedException {
        this.openComposeWindow(this.constructMailto(message));
    }

    public void open() throws LaunchFailedException {
        this.openComposeWindow("mailto:");
    }

    private void openComposeWindow(String string) throws LaunchFailedException {
        try {
            Runtime.getRuntime().exec(new String[]{"open", string});
            Thread.sleep(2000L);
        }
        catch (IOException iOException) {
            throw new LaunchFailedException("Cannot launch mail composer via command line: " + iOException);
        }
        catch (InterruptedException interruptedException) {
            InterruptedException interruptedException2 = interruptedException;
        }
    }

    private String constructMailto(Message message) {
        String string = "mailto:?";
        string = string + this.flatten("to=", message.getToAddrs());
        string = string + this.flatten("cc=", message.getCcAddrs());
        string = string + this.flatten("bcc=", message.getBccAddrs());
        string = string + this.encode("subject=", message.getSubject());
        string = string + this.encode("body=", message.getBody());
        string = string + this.flatten("attach=", message.getAttachments());
        return string;
    }

    private String encode(String string, String string2) {
        if (string2 != null) {
            return string + URLUTF8Encoder.encode((String)string2) + "&";
        }
        return "";
    }

    private String flatten(String string, Iterator iterator) {
        String string2 = "";
        if (iterator != null) {
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                string2 = string2 + string + string3 + "&";
            }
        }
        return string2;
    }
}

