/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.plugins;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.IOUtil;
import org.w3c.dom.Document;

public class RegisterExtension {
    final Log log;

    public RegisterExtension(Log log) {
        this.log = log;
    }

    public void register(File srcFile, File destFile, String[] profiles, File subsystem, String moduleId) throws Exception {
        try {
            this.log.info((CharSequence)("Register extension module=" + moduleId));
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document srcDoc = dBuilder.parse(srcFile);
            Document subsystemDoc = null;
            if (RegisterExtension.isStandaloneXml(srcDoc)) {
                profiles = null;
            }
            if (subsystem.isFile() && subsystem.canRead()) {
                subsystemDoc = dBuilder.parse(subsystem);
                this.log.info((CharSequence)("Configuring subsystem from file " + subsystem));
            } else {
                this.log.info((CharSequence)("Subsystem file [" + subsystem + "] does not exist, subsystem will not be configured"));
            }
            TransformerFactory f = TransformerFactory.newInstance();
            Transformer t = f.newTransformer(new StreamSource(this.createStylesheet(RegisterExtension.getNameSpace(srcDoc), moduleId, RegisterExtension.getNameSpace(subsystemDoc), RegisterExtension.doc2string(subsystemDoc), profiles)));
            StreamSource s = new StreamSource(srcFile);
            StreamResult r = new StreamResult(destFile);
            t.setURIResolver(null);
            t.setOutputProperty("indent", "yes");
            t.setOutputProperty("standalone", "yes");
            t.setOutputProperty("method", "xml");
            t.transform(s, r);
            this.log.info((CharSequence)("New serverConfig file written to [" + destFile.getAbsolutePath() + "]"));
        }
        catch (TransformerConfigurationException e) {
            throw new Exception(e.toString());
        }
        catch (TransformerException e) {
            throw new Exception(e.toString());
        }
    }

    private InputStream createStylesheet(String namespace, String module, String subns, String subsystem, String[] profileNames) throws IOException {
        String ignoreNs = "s";
        boolean isSubsystem = subns != null && subsystem != null;
        String profileSelector = RegisterExtension.createXPathProfileNameSelector(profileNames);
        StringBuilder sheet = new StringBuilder("<?xml version=\"1.0\" ?>");
        sheet.append("<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" xmlns:s=\"" + namespace + "\"");
        if (isSubsystem) {
            sheet.append(" xmlns:sub=\"" + subns + "\"");
            ignoreNs = ignoreNs + " sub";
        }
        sheet.append(" exclude-result-prefixes=\"" + ignoreNs + "\" version=\"1.0\">");
        sheet.append("<xsl:variable name=\"extension\"><extension module=\"" + module + "\" /></xsl:variable>");
        sheet.append("<xsl:template match=\"s:extensions\"><xsl:copy><xsl:apply-templates select=\"*[not(@module='" + module + "')]|node()\" /></xsl:copy>" + "</xsl:template><xsl:template match=\"s:extension[last()]\"><xsl:copy-of select=\"$extension\" /></xsl:template>");
        if (isSubsystem) {
            sheet.append("<xsl:variable name=\"subsystem\">" + subsystem + "</xsl:variable>");
            sheet.append("<xsl:template match=\"@s:profile" + profileSelector + "\"><xsl:copy><xsl:apply-templates select=\"*[not(namespace-uri() ='" + subns + "')]|node()\" /></xsl:copy>" + "</xsl:template><xsl:template match=\"s:profile" + profileSelector + "/*[last()]\"><xsl:copy-of select=\"$subsystem\" /></xsl:template>");
        }
        sheet.append("<xsl:template match=\"@*|node()\"><xsl:copy><xsl:apply-templates select=\"@*|node()\" /></xsl:copy></xsl:template>");
        sheet.append("</xsl:stylesheet>");
        this.log.debug((CharSequence)("XSL :" + sheet));
        return new ByteArrayInputStream(IOUtil.toByteArray((String)sheet.toString()));
    }

    private static String createXPathProfileNameSelector(String[] profiles) {
        if (profiles == null || profiles.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder("[");
        for (String profile : profiles) {
            sb.append("@name='" + profile + "' or ");
        }
        sb.delete(sb.length() - 4, sb.length());
        sb.append("]");
        return sb.toString();
    }

    private static boolean isStandaloneXml(Document doc) {
        return "server".equals(doc.getDocumentElement().getNodeName());
    }

    private static String getNameSpace(Document doc) {
        if (doc == null) {
            return null;
        }
        return doc.getDocumentElement().getAttribute("xmlns");
    }

    private static String doc2string(Document doc) {
        if (doc == null) {
            return null;
        }
        try {
            StringWriter sw = new StringWriter();
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(new DOMSource(doc), new StreamResult(sw));
            return sw.toString();
        }
        catch (Exception ex) {
            throw new RuntimeException("Error converting to String", ex);
        }
    }
}

