/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.plugins;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jboss.plugins.JBossModule;

@Mojo(name="deploy", defaultPhase=LifecyclePhase.INSTALL)
public class DeployExtensionMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}/${project.artifactId}-module.zip", required=true)
    private File moduleZip;
    @Parameter(defaultValue="${jboss.home}", required=true)
    private File jbossHome;
    @Parameter(defaultValue="standalone/configuration/standalone.xml", required=true)
    private String serverConfig;
    @Parameter
    private String[] profiles;
    @Parameter(defaultValue="${basedir}/src/main/resources/subsystem.xml", required=true)
    private File subsystem;
    @Parameter(defaultValue="false")
    private boolean skipDeploy;
    private File serverConfigAbsolute;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipDeploy) {
            this.getLog().info((CharSequence)"Skipped execution");
            return;
        }
        this.validConfiguration();
        JBossModule module = null;
        try {
            module = JBossModule.readFromZipFile(this.getLog(), this.moduleZip);
        }
        catch (Exception e) {
            throw new MojoFailureException("Failed to read module : " + e.getMessage());
        }
        try {
            module.installTo(this.jbossHome);
        }
        catch (Exception e) {
            throw new MojoFailureException("Failed to install module : " + e.getMessage());
        }
        try {
            module.registerExtension(this.serverConfigAbsolute, this.profiles, this.subsystem);
        }
        catch (Exception e) {
            throw new MojoFailureException("Failed to register module : " + e.getMessage());
        }
    }

    private void validConfiguration() throws MojoFailureException {
        if (!(this.jbossHome.exists() && this.jbossHome.isDirectory() && this.jbossHome.canRead())) {
            throw new MojoFailureException("jbossHome = " + this.jbossHome.getAbsolutePath() + " is not readable and existing directory");
        }
        if (!new File(this.jbossHome, "modules").isDirectory()) {
            throw new MojoFailureException("jbossHome = " + this.jbossHome.getAbsolutePath() + " does not seem to point to AS7/WildFly installation dir");
        }
        this.serverConfigAbsolute = new File(this.serverConfig).isAbsolute() ? new File(this.serverConfig) : new File(this.jbossHome, this.serverConfig);
        if (!(this.serverConfigAbsolute.exists() && this.serverConfigAbsolute.isFile() && this.serverConfigAbsolute.canWrite())) {
            throw new MojoFailureException("standaloneXml = " + this.serverConfig + " is not writable and existing file. [standaloneXml] must be either absolute path or relative to [jbossHome]");
        }
    }
}

